/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas;

import de.cadenas.catalogsearch.lucene.index.CatalogIndexer;
import de.cadenas.catalogsearch.lucene.index.OpenIndexRequest;
import de.cadenas.catalogsearch.lucene.index.RemoveDataRequest;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.ProjectData;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.TableRowData;
import de.cadenas.util.PConfig;
import org.apache.lucene.index.IndexWriterConfig;

class IndexGenerator {
    private final CatalogIndexer indexer;
    private final String catalogName;
    private static int maxDocsPerSegment = 50000;
    private static int maxDeletedDocsPerIndex = 100;

    IndexGenerator(OpenIndexRequest request, IndexWriterConfig.OpenMode openMode) throws Exception {
        this.indexer = new CatalogIndexer(request.indexPath, request.type, openMode, maxDocsPerSegment, maxDeletedDocsPerIndex);
        this.catalogName = request.catalogName;
    }

    public void close() {
        try {
            this.indexer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addProject(ProjectData prjData) throws Exception {
        if (prjData.indexProjectData() && prjData.rowsLength() == 0) {
            this.indexer.addData(prjData, null);
        }
        if (prjData.rowsLength() != 0) {
            StringBuilder messages = new StringBuilder();
            int rowsLength = prjData.rowsLength();
            for (int r = 0; r < rowsLength; ++r) {
                TableRowData rowData = prjData.rows(r);
                try {
                    this.indexer.addData(prjData, rowData);
                    continue;
                }
                catch (Exception e) {
                    if (messages.length() > 0) {
                        messages.append("\n");
                    }
                    messages.append(e.getClass().getCanonicalName());
                    messages.append(": ");
                    messages.append(e.getLocalizedMessage());
                }
            }
            if (prjData.indexProjectData()) {
                try {
                    this.indexer.fillDocumentsDoc(prjData);
                }
                catch (Exception e) {
                    if (messages.length() > 0) {
                        messages.append("\n");
                    }
                    messages.append(e.getClass().getCanonicalName());
                    messages.append(": ");
                    messages.append(e.getLocalizedMessage());
                }
            }
            if (messages.length() > 0) {
                throw new Exception(messages.toString());
            }
        }
    }

    public int removeData(RemoveDataRequest removeData) throws Exception {
        for (RemoveDataRequest.Item item : removeData.itemsToRemove) {
            String catalog = item.catalog;
            if (catalog == null || catalog.isEmpty()) {
                catalog = this.catalogName;
            }
            if (item.lineIds == null) {
                this.indexer.removeData(catalog, item.path, -1);
                continue;
            }
            for (int lineId : item.lineIds) {
                this.indexer.removeData(catalog, item.path, lineId);
            }
        }
        this.indexer.commit();
        return this.indexer.numDocs();
    }

    static {
        try (PConfig config = new PConfig("$CADENAS_SETUP/partsol.cfg");){
            maxDocsPerSegment = config.getInt("MaxDocsPerSegment", "INDEX:LUCENE", maxDocsPerSegment);
            maxDeletedDocsPerIndex = config.getInt("MaxDeletedDocsPerIndex", "INDEX:LUCENE", maxDeletedDocsPerIndex);
        }
    }
}

