/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.api.impl;

import de.cadenas.catalogsearch.api.ISearchRequest;
import de.cadenas.util.PDataStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FacetsRequestImpl {
    public boolean erpPreferredLine = false;
    public String erpGroupName = "";
    public List<String> languageList = null;
    public int variableFacetCount = 0;
    public Map<String, List<PartId>> parts = null;
    public List<ISearchRequest.TermFilter> termFilters = new ArrayList<ISearchRequest.TermFilter>();
    public List<ISearchRequest.RangeFilter> rangeFilters = new ArrayList<ISearchRequest.RangeFilter>();
    public List<String> facetFilter = null;

    public static FacetsRequestImpl fromBinary(byte[] requestData) {
        String field;
        int i;
        FacetsRequestImpl result = new FacetsRequestImpl();
        PDataStream stream = new PDataStream(requestData, 0, requestData.length);
        result.erpPreferredLine = stream.readBool();
        result.erpGroupName = stream.readString();
        result.languageList = stream.readStringList();
        result.variableFacetCount = stream.readInt();
        result.parts = new HashMap<String, List<PartId>>();
        int count = stream.readInt();
        for (i = 0; i < count; ++i) {
            String classification = stream.readString();
            int partCount = stream.readInt();
            ArrayList<PartId> parts = new ArrayList<PartId>(partCount);
            for (int p = 0; p < partCount; ++p) {
                PartId id = new PartId();
                id.classId = stream.readString();
                id.lineId = stream.readInt();
                id.lineSubId = stream.readInt();
                parts.add(id);
            }
            result.parts.put(classification, parts);
        }
        count = stream.readInt();
        for (i = 0; i < count; ++i) {
            field = stream.readString();
            String value = stream.readString();
            boolean erpFitler = stream.readBool();
            boolean andConjunction = stream.readBool();
            ISearchRequest.TermFilter filter = new ISearchRequest.TermFilter(field, value, erpFitler, andConjunction);
            result.termFilters.add(filter);
        }
        count = stream.readInt();
        for (i = 0; i < count; ++i) {
            field = stream.readString();
            double low = stream.readDouble();
            double high = stream.readDouble();
            boolean erpFilter = stream.readBool();
            ISearchRequest.RangeFilter filter = new ISearchRequest.RangeFilter(field, low, high, erpFilter);
            result.rangeFilters.add(filter);
        }
        count = stream.readInt();
        if (count > 0) {
            result.facetFilter = new ArrayList<String>();
            for (i = 0; i < count; ++i) {
                String name = stream.readString();
                result.facetFilter.add(name);
            }
        }
        return result;
    }

    public static class PartId {
        public String classId = null;
        public int lineId = -1;
        public int lineSubId = -1;
    }
}

