/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.api.impl;

import de.cadenas.catalogsearch.api.ISearchResult;
import de.cadenas.catalogsearch.api.ISearchResultError;
import de.cadenas.catalogsearch.api.ISearchResultFilter;
import de.cadenas.catalogsearch.api.ISearchResultItem;
import de.cadenas.catalogsearch.api.impl.SearchResultErrorImpl;
import de.cadenas.catalogsearch.api.impl.SearchResultItemImpl;
import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.exceptions.UserInputException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class SearchResultImpl
implements ISearchResult {
    public int totalHitCount = 0;
    public int totalProjectCount = 0;
    public int searchId = -1;
    public String commonDirectory = null;
    public List<ISearchResultItem> items = new ArrayList<ISearchResultItem>();
    public List<ISearchResultFilter> filters = new ArrayList<ISearchResultFilter>();
    public List<String> childFolderFilter = null;
    public List<ISearchResultError> errors = null;
    public boolean moreFacetsAvailable = false;

    public SearchResultImpl(UserInputException e) {
        this.addError(e);
    }

    public SearchResultImpl() {
    }

    public void merge(ISearchResult other) {
        if (this.totalHitCount > 0 && other.getTotalHitCount() > 0) {
            for (ISearchResultItem item : this.items) {
                SearchResultItemImpl itemImpl = (SearchResultItemImpl)item;
                itemImpl.score *= (double)FieldDefinitions.erpIndexBoost;
            }
            this.items.addAll(other.getItems());
            this.items.sort(Comparator.comparingDouble(ISearchResultItem::getScore).reversed());
        } else {
            this.items.addAll(other.getItems());
        }
        this.totalHitCount += other.getTotalHitCount();
        this.totalProjectCount += other.getProjectCount();
        for (ISearchResultFilter filter : other.getFilters()) {
            boolean foundFilter = false;
            for (ISearchResultFilter f : this.filters) {
                if (!f.getName().equals(filter.getName())) continue;
                foundFilter = true;
                break;
            }
            if (foundFilter) continue;
            this.filters.add(filter);
        }
        List<String> folderFilter = other.getChildFolderFilter();
        if (folderFilter != null) {
            if (this.childFolderFilter == null) {
                this.childFolderFilter = folderFilter;
            } else {
                this.childFolderFilter.addAll(folderFilter);
            }
        }
        if (other.getErrors() != null) {
            if (this.errors == null) {
                this.errors = new ArrayList<ISearchResultError>();
            }
            this.errors.addAll(other.getErrors());
        }
        this.moreFacetsAvailable = this.moreFacetsAvailable || other.getMoreVarFacetsAvailable();
    }

    public void addError(UserInputException e) {
        SearchResultErrorImpl error = new SearchResultErrorImpl();
        error.id = e.getID();
        error.no = e.getNO().ordinal();
        error.arguments = e.getArguments();
        error.data = e.getData();
        if (this.errors == null) {
            this.errors = new ArrayList<ISearchResultError>();
        }
        this.errors.add(error);
    }

    @Override
    public int getTotalHitCount() {
        return this.totalHitCount;
    }

    @Override
    public int getProjectCount() {
        return this.totalProjectCount;
    }

    @Override
    public String getCommonDirectory() {
        return this.commonDirectory;
    }

    @Override
    public int getSearchId() {
        return this.searchId;
    }

    @Override
    public List<ISearchResultItem> getItems() {
        return this.items;
    }

    @Override
    public List<ISearchResultFilter> getFilters() {
        return this.filters;
    }

    @Override
    public List<String> getChildFolderFilter() {
        return this.childFolderFilter;
    }

    @Override
    public List<ISearchResultError> getErrors() {
        return this.errors;
    }

    @Override
    public boolean getMoreVarFacetsAvailable() {
        return this.moreFacetsAvailable;
    }
}

