/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene;

import de.cadenas.catalogsearch.lucene.index.ErpConfiguration;
import de.cadenas.catalogsearch.lucene.queryparser.SearchField;
import de.cadenas.catalogsearch.lucene.queryparser.boost.PSolExactBoost;
import de.cadenas.catalogsearch.lucene.queryparser.boost.PSolFieldBoost;
import de.cadenas.catalogsearch.lucene.queryparser.boost.PSolStandardBoost;
import de.cadenas.util.NumUtils;
import de.cadenas.util.PConfig;
import de.cadenas.util.PGenericPair;
import de.cadenas.util.PLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.facet.FacetsConfig;
import org.json.JSONObject;

public class FieldDefinitions {
    private static final PLogger logger = new PLogger(FieldDefinitions.class.getSimpleName());
    public static CatalogBoost[] catalogBoost;
    public static float erpIndexBoost;
    public static int maxDistinctValues;
    public static int readerStateCacheSize;
    public static boolean disableRangeQuery;
    public static RowBoost[] rowBoost;
    public static final float OPT_BOOST = 0.2f;
    public static final float PHRASE_BOOST = 3.0f;
    public static final float EXACTTERM_BOOST = 1.11f;
    public static final float NUMEXACTTERM_BOOST = 1.5f;
    public static final float SYNTERM_BOOST = 1.1f;
    public static final float COMPOUND_MID_FACTOR = 0.9f;
    public static final float COMPOUND_LAST_FACTOR = 0.98f;
    public static final float LOWPRIO_BOOST = 0.7f;
    public static final int NEXT_WORD_INCREMENT = 100;
    public static final int COMPOUND_START_POS = 10000;
    public static final int FIELD_MAX_POS = 100000;
    public static final byte PAYLOAD_STEMMED = 1;
    public static final byte PAYLOAD_BGN = 2;
    public static final byte PAYLOAD_MID = 4;
    public static final byte PAYLOAD_END = 8;
    public static final byte PAYLOAD_LOWPRIO = 16;
    public static final int MaxDimCount = 10000;
    public static long WILDCARD_COST_LIMIT;
    public static final String FIELD_DOC_TYPE = "type";
    public static final String FIELD_CATALOG = "catalog";
    public static final String FIELD_PATH = "path";
    public static final String FIELD_TREEPATH = "treepath";
    public static final String FIELD_NN = "nn";
    public static final String FIELD_NT = "nt";
    public static final String FIELD_PRJDATE = "prjdate";
    public static final String FIELD_PRJTYPE = "prjtype";
    public static final String FIELD_ASSTYPE = "asstype";
    public static final String FIELD_PATH_TRANSLATED = "pathtranslated";
    public static final String FIELD_CLASSID = "classid";
    public static final String FIELD_LINEID = "lineid";
    public static final String FIELD_LINESUBID = "linesubid";
    public static final String FIELD_VARSET = "varset";
    public static final String FIELD_PERSISTENT_ID = "persid";
    public static final String FIELD_PERSISTENT_IDX = "persidx";
    public static final String FIELD_NB = "nb";
    public static final String FIELD_ORDERNUMBER = "ordernumber";
    public static final String FIELD_TYPECODE = "typecode";
    public static final String FIELD_PRIO = "prio";
    public static final String FIELD_LIC_LOW = "lic_low";
    public static final String FIELD_LIC_UP = "lic_up";
    public static final String FIELD_COLUMN_TEXT_PREFIX = "col_text_";
    public static final String FIELD_COLUMN_NUMBER_PREFIX = "col_number_";
    public static final String FIELD_COLUMN_TEXT_TAGS_PREFIX = "col_text_tags_";
    public static final String FIELD_LINE_TEXT_VALUES = "textvalues";
    public static final String FIELD_LINE_NUMBER_VALUES = "numbervalues";
    public static final String FIELD_KEYWORDS = "keywords";
    public static final String FIELD_TOPOANYVALUE = "topoanyvalue";
    public static final String FIELD_EXACTDATA = "exactdata";
    public static final String FIELD_DOCUMENT = "document";
    public static final String FIELD_DOCUMENT_LANGUAGE = "document_language";
    public static final String FIELD_DOCCOLUMN = "column";
    public static final String FIELD_DOCPATH = "docpath";
    public static final String FIELD_DOCBASEPATH = "docbasepath";
    public static final String FIELD_DOCRELPATH = "docrelpath";
    public static final String FIELD_VALUERANGEDEF = "valuerangedef";
    public static final String FIELD_POSTFIX_ERP_FLAG = "_erp_flag";
    public static final String FIELD_ERP_STATE = "erp_state";
    public static final String ERP_GROUP_FLAG_VISIBLE = "visible";
    public static final String ERP_GROUP_FLAG_PREFERRED = "preferred";
    public static final String FIELD_POSTFIX_EXACT = "_exact";
    public static final String FIELD_POSTFIX_LANG = "_lang";
    public static final String FIELD_POSTFIX_PREFIX = "_pre";
    public static final String FIELD_POSTFIX_EXACTQUERY = "_ex";
    public static final String FIELD_POSTFIX_WILDCARD = "_wld";
    public static final String FACET_PREFIX = "facet_";
    public static final String FACET_DIM_NUMVAR = "facet_numvar";
    public static final String FACET_DIM_ERP_NUMVAR = "facet_erp_numvar";
    public static final String FACET_DIM_RANGEVAR = "facet_rangevar";
    public static final String FACET_DIM_ERP_RANGEVAR = "facet_erp_rangevar";
    public static final String FACET_DIM_DOCID = "facet_document_id";
    public static final String FACET_DIM_TREEPATH = "facet_treepath";
    public static final String FACET_IDX_TREEPATH = "index_treepath";
    public static final String VALUE_DOC_DATA_TYPE_ROW = "psol-row";
    public static final String VALUE_DOC_DATA_TYPE_HIDDEN_ROW = "psol-hidden-row";
    private static final Set<String> untokenizedFields;
    private static final List<String> icuLanguages;
    public static final CharArraySet frenchArticles;
    private static List<SearchField> fulltextNumericFields;
    private static List<SearchField> fulltextExactFields;
    private static List<SearchField> fulltextTextualFields;
    private static List<SearchField> fulltextWildcardFields;
    private static List<SearchField> fulltextPhraseFields;
    private static final PSolExactBoost defaultExactTermBoost;
    private static final PSolExactBoost defaultNumericExactTermBoost;
    private static final PSolExactBoost defaultSynTermBoost;
    private static final PSolStandardBoost defaultStandardBoost;
    private static float spellCheckerAccuracy;
    private static int spellCheckerLengthAccuracy;
    private static final Map<String, LanguageGroup> languageGroups;
    private static final FacetsConfig.DimConfig PS_DEFAULT_DIM_CONFIG;
    private static final FacetsConfig.DimConfig PS_VARFACETS_DIM_CONFIG;
    private static final FacetsConfig.DimConfig PS_FILTERASS_DIM_CONFIG;

    public static FacetsConfig getFacetsConfig() {
        FacetsConfig fc = new FacetsConfig(){

            @Override
            protected FacetsConfig.DimConfig getDefaultDimConfig() {
                return PS_DEFAULT_DIM_CONFIG;
            }

            @Override
            public FacetsConfig.DimConfig getDimConfig(String dimName) {
                if (dimName.startsWith("facet_text_") || dimName.equals(FieldDefinitions.FACET_DIM_NUMVAR) || dimName.equals(FieldDefinitions.FACET_DIM_RANGEVAR)) {
                    if (dimName.contains("f:")) {
                        return PS_FILTERASS_DIM_CONFIG;
                    }
                    if (!dimName.contains("c:")) {
                        return PS_VARFACETS_DIM_CONFIG;
                    }
                }
                return super.getDimConfig(dimName);
            }
        };
        fc.setIndexFieldName(FACET_DIM_TREEPATH, FACET_IDX_TREEPATH);
        fc.setMultiValued(FACET_DIM_TREEPATH, true);
        fc.setHierarchical(FACET_DIM_TREEPATH, true);
        return fc;
    }

    public static List<SearchField> getWildcardFields() {
        return fulltextWildcardFields;
    }

    public static List<SearchField> getNumericFields(String erpGroup) {
        String combinedGroup;
        ErpConfiguration erpConfig;
        if (erpGroup != null && !erpGroup.isEmpty() && (erpConfig = ErpConfiguration.getInstance()).isValid() && (combinedGroup = erpConfig.getCombinedGroup(erpGroup)) != null && !combinedGroup.isEmpty()) {
            for (SearchField field : fulltextNumericFields) {
                if (!field.getName().equals(FIELD_LINE_NUMBER_VALUES)) continue;
                ArrayList<SearchField> fields = new ArrayList<SearchField>(fulltextNumericFields.size() + 1);
                fields.addAll(fulltextNumericFields);
                try {
                    SearchField groupField = field.clone(combinedGroup + "_numbervalues");
                    fields.add(groupField);
                }
                catch (CloneNotSupportedException ignored) {
                    return fulltextNumericFields;
                }
                return fields;
            }
        }
        return fulltextNumericFields;
    }

    public static List<SearchField> getExactFields(List<String> langList, String erpGroup) {
        return FieldDefinitions.getLanguageFields(langList, fulltextExactFields, erpGroup);
    }

    public static List<SearchField> getTextualFields(List<String> langList, String erpGroup) {
        return FieldDefinitions.getLanguageFields(langList, fulltextTextualFields, erpGroup);
    }

    public static List<SearchField> getPhraseFields(List<String> langList, String erpGroup) {
        return FieldDefinitions.getLanguageFields(langList, fulltextPhraseFields, erpGroup);
    }

    private static List<SearchField> getLanguageFields(List<String> langList, List<SearchField> fieldList, String erpGroup) {
        String combinedGroup;
        ErpConfiguration erpConfig;
        Object erpGroupPrefix = "";
        if (erpGroup != null && !erpGroup.isEmpty() && (erpConfig = ErpConfiguration.getInstance()).isValid() && (combinedGroup = erpConfig.getCombinedGroup(erpGroup)) != null && !combinedGroup.isEmpty()) {
            erpGroupPrefix = combinedGroup + "_";
        }
        ArrayList<SearchField> fields = new ArrayList<SearchField>();
        for (SearchField field : fieldList) {
            String fieldName = field.getName();
            String erpFieldName = null;
            if (field.isFulltext() && !((String)erpGroupPrefix).isEmpty()) {
                erpFieldName = (String)erpGroupPrefix + fieldName;
            }
            if (field.isLanguageField()) {
                for (String language : langList) {
                    FieldDefinitions.createSearchField(fields, field, fieldName, language);
                    if (erpFieldName == null) continue;
                    FieldDefinitions.createSearchField(fields, field, erpFieldName, language);
                }
                continue;
            }
            if (field.isFulltext() && !((String)erpGroupPrefix).isEmpty()) {
                SearchField lfield = new SearchField(erpFieldName, field.getBoostHandler(), field.isLanguageField(), field.isTokenized(), field.isOptional(), field.isExact(), field.isFulltext(), field.isCommonField());
                if (field.isDocField()) {
                    lfield.setIsDocField(true);
                }
                fields.add(lfield);
            }
            fields.add(field);
        }
        return fields;
    }

    private static void createSearchField(List<SearchField> fields, SearchField field, String fieldName, String language) {
        String builder = fieldName + "_" + language + FIELD_POSTFIX_LANG;
        SearchField lfield = new SearchField(builder, field.getBoostHandler(), field.isLanguageField(), field.isTokenized(), field.isOptional(), field.isExact(), field.isFulltext(), field.isCommonField());
        if (field.isDocField()) {
            lfield.setIsDocField(true);
        }
        FieldDefinitions.evaluateLanguageFieldSettings(lfield, language);
        fields.add(lfield);
    }

    public static void evaluateLanguageFieldSettings(SearchField field, String language) {
        if (language.equals("german")) {
            field.setIsCompoundField(true);
        }
    }

    public static KeyWordType getKeyWordType(String fieldName) {
        if (fieldName.compareTo(FIELD_LINEID) == 0 || fieldName.compareTo(FIELD_LINESUBID) == 0 || fieldName.compareTo(FIELD_LIC_LOW) == 0 || fieldName.compareTo(FIELD_LIC_UP) == 0) {
            return KeyWordType.IntKeyWord;
        }
        if (fieldName.startsWith(FIELD_COLUMN_NUMBER_PREFIX)) {
            return KeyWordType.NumericKeyWord;
        }
        return KeyWordType.StringKeyWord;
    }

    public static List<SearchField> getSearchFieldsForVariable(String name, List<String> langList, boolean numeric) {
        ArrayList<SearchField> result = new ArrayList<SearchField>();
        String varName = null;
        String clsName = null;
        int pos = name.lastIndexOf(".");
        if (pos != -1) {
            varName = name.substring(pos + 1);
            clsName = name.substring(0, pos);
        } else {
            varName = name;
        }
        if (clsName != null) {
            String fname = FieldDefinitions.getIndexFieldNameForEClassVariable(clsName, varName, numeric);
            if (numeric) {
                result.add(new SearchField(fname));
            } else {
                for (String language : langList) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(fname);
                    builder.append("_");
                    builder.append(language);
                    builder.append(FIELD_POSTFIX_LANG);
                    SearchField lfield = new SearchField(builder.toString());
                    FieldDefinitions.evaluateLanguageFieldSettings(lfield, language);
                    result.add(lfield);
                }
            }
        } else if (numeric) {
            String fname = FieldDefinitions.getIndexFieldNameForVariable(varName, numeric);
            result.add(new SearchField(fname));
        } else {
            for (String language : langList) {
                StringBuilder builder = new StringBuilder();
                builder.append(FIELD_COLUMN_TEXT_PREFIX);
                builder.append(varName.toLowerCase());
                builder.append("_");
                builder.append(language);
                builder.append(FIELD_POSTFIX_LANG);
                SearchField lfield = new SearchField(builder.toString());
                FieldDefinitions.evaluateLanguageFieldSettings(lfield, language);
                result.add(lfield);
            }
        }
        return result;
    }

    public static List<SearchField> toExactFields(List<SearchField> textFields) {
        ArrayList<SearchField> exactFieldList = new ArrayList<SearchField>();
        for (SearchField searchField : textFields) {
            try {
                SearchField exactField = (SearchField)searchField.clone();
                if (exactField.isTokenized()) {
                    exactField.setIsExact(true);
                }
                exactFieldList.add(exactField);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        return exactFieldList;
    }

    public static String getIndexFieldNameForVariable(String variable, boolean numeric) {
        StringBuilder sb = new StringBuilder();
        if (numeric) {
            sb.append(FIELD_COLUMN_NUMBER_PREFIX);
            sb.append(variable.toLowerCase());
        } else {
            sb.append(FIELD_COLUMN_TEXT_PREFIX);
            sb.append(variable.toLowerCase());
        }
        return sb.toString();
    }

    public static String getIndexFieldNameForEClassVariable(String cls, String variable, boolean numeric) {
        boolean isFormatted;
        StringBuilder sb = new StringBuilder();
        boolean bl = isFormatted = variable.startsWith("c:") || variable.startsWith("f:");
        if (numeric) {
            sb.append(FIELD_COLUMN_NUMBER_PREFIX);
        } else {
            sb.append(FIELD_COLUMN_TEXT_PREFIX);
        }
        if (!isFormatted) {
            sb.append("c:");
            sb.append(cls.toLowerCase());
            sb.append(':');
            sb.append(variable.toLowerCase());
        } else {
            sb.append(variable.toLowerCase());
        }
        return sb.toString();
    }

    public static boolean isNumberField(String field) {
        if (field.compareTo(FIELD_LINEID) == 0) {
            return true;
        }
        if (field.compareTo(FIELD_LINESUBID) == 0) {
            return true;
        }
        if (field.startsWith(FIELD_COLUMN_NUMBER_PREFIX)) {
            return true;
        }
        if (field.compareTo(FIELD_LINE_NUMBER_VALUES) == 0) {
            return true;
        }
        return field.compareTo(FIELD_TOPOANYVALUE) == 0;
    }

    public static boolean isTranslatedField(String field) {
        return field.endsWith(FIELD_POSTFIX_LANG);
    }

    public static boolean isICUTokenized(String field) {
        if (field.endsWith(FIELD_POSTFIX_LANG)) {
            int pos = field.length() - FIELD_POSTFIX_LANG.length();
            for (String lang : icuLanguages) {
                if (!field.regionMatches(pos - lang.length(), lang, 0, lang.length())) continue;
                return true;
            }
        }
        return false;
    }

    public static LanguageGroup getLanguageGroup(String language) {
        return languageGroups.getOrDefault(language, LanguageGroup.Default);
    }

    public static String getLanguageOfField(String field) {
        String result = null;
        int pos = field.lastIndexOf(95, field.length() - 6);
        if (pos != -1) {
            result = field.substring(pos + 1, field.length() - 5);
        }
        return result;
    }

    public static PGenericPair<String, String> getLanguageAndVarName(String field) {
        String language = "";
        String varName = "";
        int pos = field.lastIndexOf(95, field.length() - 6);
        if (pos != -1) {
            language = field.substring(pos + 1, field.length() - 5);
            int pos2 = field.startsWith(FIELD_COLUMN_TEXT_PREFIX) ? FIELD_COLUMN_TEXT_PREFIX.length() - 1 : (field.startsWith("facet_text_") ? "facet_text_".length() - 1 : (field.startsWith("facet_erp_") ? "facet_erp_".length() - 1 : field.lastIndexOf(95, pos - 1)));
            if (pos2 != -1) {
                varName = field.substring(pos2 + 1, pos);
            }
        }
        if (!language.isEmpty() && !varName.isEmpty()) {
            return new PGenericPair<String, String>(language, varName);
        }
        return null;
    }

    public static String getVarNameFromErpFacet(String field) {
        String varName = "";
        int pos = field.lastIndexOf(95, field.length() - 6);
        if (pos != -1) {
            int pos2 = "facet_erp_".length();
            varName = field.substring(pos2, pos);
        }
        return varName;
    }

    public static boolean isUntokenizedField(String field) {
        if (untokenizedFields.contains(field)) {
            return true;
        }
        return field.endsWith(FIELD_POSTFIX_ERP_FLAG);
    }

    public static PSolExactBoost getExactTermBoost(String fieldName, boolean numeric) {
        for (SearchField field : fulltextTextualFields) {
            if (!field.getName().equals(fieldName) || field.getExactTermBoost(numeric) == null) continue;
            return field.getExactTermBoost(numeric);
        }
        return FieldDefinitions.getDefaultExactTermBoost(numeric);
    }

    public static PSolExactBoost getSynTermBoost(String fieldName) {
        for (SearchField field : fulltextTextualFields) {
            if (!field.getName().equals(fieldName) || field.getSynTermBoost() == null) continue;
            return field.getSynTermBoost();
        }
        return FieldDefinitions.getDefaultSynTermBoost();
    }

    public static PSolStandardBoost getStandardBoost(String fieldName) {
        for (SearchField field : fulltextTextualFields) {
            if (!field.getName().equals(fieldName) || field.getStandardBoost() == null) continue;
            return field.getStandardBoost();
        }
        return FieldDefinitions.getDefaultStandardBoost();
    }

    private static PSolExactBoost getDefaultExactTermBoost(boolean numeric) {
        if (numeric && defaultNumericExactTermBoost != null) {
            return defaultNumericExactTermBoost;
        }
        return defaultExactTermBoost;
    }

    private static PSolExactBoost getDefaultSynTermBoost() {
        return defaultSynTermBoost;
    }

    private static PSolStandardBoost getDefaultStandardBoost() {
        return defaultStandardBoost;
    }

    private static List<SearchField> parseFieldConfiguration(PConfig config, String block, String key, List<SearchField> defaultDefinition) {
        String[] fieldNameList;
        String fieldDef = config.getValue(key, block);
        if (fieldDef == null || fieldDef.isEmpty()) {
            return defaultDefinition;
        }
        if (fieldDef.charAt(0) == '{') {
            String[] fieldNameList2;
            ArrayList<SearchField> result = new ArrayList<SearchField>();
            JSONObject jRoot = new JSONObject(fieldDef);
            for (String fieldName : fieldNameList2 = JSONObject.getNames(jRoot)) {
                SearchField field = FieldDefinitions.getFieldFromList(fieldName, defaultDefinition);
                if (field == null) continue;
                try {
                    SearchField newField = (SearchField)field.clone();
                    JSONObject jField = jRoot.getJSONObject(fieldName);
                    if (jField != null) {
                        JSONObject jBoost;
                        if (jField.has("og")) {
                            newField.getBoostHandler().setOg((float)jField.getDouble("og"));
                        }
                        if (jField.has("ug")) {
                            newField.getBoostHandler().setUg((float)jField.getDouble("ug"));
                        }
                        if (jField.has("step")) {
                            newField.getBoostHandler().setStep((float)jField.getDouble("step"));
                            newField.getBoostHandler().setNeedPositions(true);
                        }
                        if (jField.has("boost")) {
                            PSolFieldBoost boost = newField.getBoostHandler();
                            float value = (float)jField.getDouble("boost");
                            boost.setOg(value);
                            boost.setUg(value);
                            boost.setStep(0.0f);
                            boost.setNeedPositions(false);
                        }
                        if (jField.has("exactBoost")) {
                            jBoost = jField.getJSONObject("exactBoost");
                            PSolExactBoost exactBoost = (PSolExactBoost)FieldDefinitions.getDefaultExactTermBoost(false).clone();
                            FieldDefinitions.parseBoostObject(jBoost, exactBoost);
                            newField.setExactTermBoost(exactBoost);
                        }
                        if (jField.has("numericExactBoost")) {
                            jBoost = jField.getJSONObject("numericExactBoost");
                            PSolExactBoost exactBoost = (PSolExactBoost)FieldDefinitions.getDefaultExactTermBoost(true).clone();
                            FieldDefinitions.parseBoostObject(jBoost, exactBoost);
                            newField.setNumericExactTermBoost(exactBoost);
                        }
                        if (jField.has("synBoost")) {
                            jBoost = jField.getJSONObject("synBoost");
                            PSolExactBoost synBoost = (PSolExactBoost)FieldDefinitions.getDefaultSynTermBoost().clone();
                            FieldDefinitions.parseBoostObject(jBoost, synBoost);
                            newField.setSynTermBoost(synBoost);
                        }
                        if (jField.has("lowprioBoost")) {
                            jBoost = jField.getJSONObject("lowprioBoost");
                            PSolStandardBoost stdBoost = (PSolStandardBoost)FieldDefinitions.getDefaultStandardBoost().clone();
                            if (jBoost.has("low")) {
                                stdBoost.setLowPrioBoost((float)jBoost.getDouble("low"));
                            }
                            newField.setStandardBoost(stdBoost);
                        }
                        if (jField.has("exact")) {
                            newField.setIsExact(jField.getBoolean("exact"));
                        }
                        if (jField.has("needPositions")) {
                            newField.getBoostHandler().setNeedPositions(jField.getBoolean("needPositions"));
                        }
                    }
                    result.add(newField);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
            }
            return result;
        }
        ArrayList<SearchField> result = new ArrayList<SearchField>();
        for (String fieldName : fieldNameList = fieldDef.split(",")) {
            SearchField field = FieldDefinitions.getFieldFromList(fieldName, defaultDefinition);
            if (field == null) continue;
            result.add(field);
        }
        return result;
    }

    private static void parseBoostObject(JSONObject jBoost, PSolExactBoost boost) {
        if (jBoost.has("factor")) {
            boost.setDefaultBoost((float)jBoost.getDouble("factor"));
        }
        if (jBoost.has("mid")) {
            boost.setMidFactor((float)jBoost.getDouble("mid"));
        }
        if (jBoost.has("last")) {
            boost.setLastFactor((float)jBoost.getDouble("last"));
        }
        if (jBoost.has("low")) {
            boost.setLowPrioBoost((float)jBoost.getDouble("low"));
        }
    }

    private static SearchField getFieldFromList(String fieldName, List<SearchField> list) {
        for (SearchField field : list) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    private static CatalogBoost[] readCatalogBoost(PConfig config) {
        String[] boostDefList = config.getStringArray("SimilarityFactor", "FULLTEXTSEARCH");
        if (boostDefList == null || boostDefList.length == 0) {
            return null;
        }
        CatalogBoost[] boostList = new CatalogBoost[boostDefList.length];
        for (int i = 0; i < boostDefList.length; ++i) {
            boolean byPrefix;
            String catalog;
            String boostDef = boostDefList[i];
            int pos = boostDef.indexOf(61);
            if (pos == -1) continue;
            if (pos > 0 && boostDef.charAt(pos - 1) == '*') {
                catalog = boostDef.substring(0, pos - 1);
                byPrefix = true;
            } else {
                catalog = boostDef.substring(0, pos);
                byPrefix = false;
            }
            float factor = Float.parseFloat(boostDef.substring(pos + 1));
            boostList[i] = new CatalogBoost(catalog, byPrefix, factor);
        }
        return boostList;
    }

    private static void readRowBoost(RowBoost[] rowBoost, PConfig config) {
        for (RowBoost item : rowBoost) {
            String valAsString = config.getValue(item.id + "Factor", "FULLTEXTSEARCH");
            if (valAsString == null || valAsString.isEmpty()) continue;
            try {
                if (valAsString.startsWith("*")) {
                    valAsString = valAsString.substring(1);
                    item.multiply = true;
                    item.factor = Float.parseFloat(valAsString);
                    if (!(item.factor < 0.0f)) continue;
                    item.factor = 1.0f + item.factor;
                    continue;
                }
                item.factor = Float.parseFloat(valAsString);
                item.multiply = false;
            }
            catch (NumberFormatException e) {
                logger.error(e.getMessage());
            }
        }
    }

    public static float getSpellCheckerAccuracy() {
        return spellCheckerAccuracy;
    }

    public static int getSpellCheckerLengthAccuracy() {
        return spellCheckerLengthAccuracy;
    }

    static {
        erpIndexBoost = 1.2f;
        maxDistinctValues = 25;
        readerStateCacheSize = 50;
        disableRangeQuery = false;
        WILDCARD_COST_LIMIT = 1000000000L;
        untokenizedFields = new HashSet<String>();
        icuLanguages = new ArrayList<String>();
        frenchArticles = new CharArraySet(10, true);
        fulltextNumericFields = null;
        fulltextExactFields = null;
        fulltextTextualFields = null;
        fulltextWildcardFields = null;
        fulltextPhraseFields = null;
        defaultExactTermBoost = new PSolExactBoost(1.11f, 0.7f, 0.9f, 0.98f);
        defaultNumericExactTermBoost = new PSolExactBoost(1.5f, 0.7f, 0.9f, 0.98f);
        defaultSynTermBoost = new PSolExactBoost(1.1f, 0.7f, 0.9f, 0.98f);
        defaultStandardBoost = new PSolStandardBoost(0.7f);
        spellCheckerAccuracy = 0.6f;
        spellCheckerLengthAccuracy = 3;
        languageGroups = new HashMap<String, LanguageGroup>();
        untokenizedFields.add(FIELD_DOC_TYPE);
        untokenizedFields.add(FIELD_CATALOG);
        untokenizedFields.add(FIELD_PATH);
        untokenizedFields.add(FIELD_TREEPATH);
        untokenizedFields.add(FIELD_PRJDATE);
        untokenizedFields.add(FIELD_PRJTYPE);
        untokenizedFields.add(FIELD_ASSTYPE);
        untokenizedFields.add(FIELD_VARSET);
        untokenizedFields.add("$facets");
        icuLanguages.add("japanese");
        icuLanguages.add("chinese");
        icuLanguages.add("chinese_traditional");
        icuLanguages.add("korean");
        icuLanguages.add("french");
        icuLanguages.add("italian");
        languageGroups.put("german", LanguageGroup.German);
        languageGroups.put("english", LanguageGroup.English);
        languageGroups.put("french", LanguageGroup.French);
        languageGroups.put("italian", LanguageGroup.Italian);
        languageGroups.put("spanish", LanguageGroup.Spanish);
        languageGroups.put("japanese", LanguageGroup.AsianCjk);
        languageGroups.put("korean", LanguageGroup.AsianCjk);
        languageGroups.put("chinese", LanguageGroup.AsianCjk);
        languageGroups.put("chinese_traditional", LanguageGroup.AsianCjk);
        frenchArticles.add("l");
        frenchArticles.add("m");
        frenchArticles.add("t");
        frenchArticles.add("n");
        frenchArticles.add("a");
        frenchArticles.add("j");
        frenchArticles.add("d");
        frenchArticles.add("c");
        frenchArticles.add("qu");
        frenchArticles.add("jusqu");
        frenchArticles.add("quoiqu");
        frenchArticles.add("lorsqu");
        frenchArticles.add("puisqu");
        try (PConfig config = new PConfig("$CADENAS_SETUP/partsol.cfg");){
            String maxWildcardTermStr;
            String accuracyAsString;
            double db;
            fulltextNumericFields = new ArrayList<SearchField>();
            fulltextNumericFields.add(new SearchField(FIELD_LINE_NUMBER_VALUES, 4.0f).setFulltext(true));
            fulltextNumericFields.add(new SearchField(FIELD_TOPOANYVALUE, 0.5f));
            fulltextNumericFields = FieldDefinitions.parseFieldConfiguration(config, "FULLTEXTSEARCH", "NumericFields", fulltextNumericFields);
            fulltextTextualFields = new ArrayList<SearchField>();
            fulltextTextualFields.add(new SearchField(FIELD_ORDERNUMBER, new PSolFieldBoost(6.0f, true), false, true, false, true));
            fulltextTextualFields.add(new SearchField(FIELD_TYPECODE, new PSolFieldBoost(6.0f, true), false, true, false, true));
            fulltextTextualFields.add(new SearchField(FIELD_NN, new PSolFieldBoost(3.0f, 2.0f, 0.2f), true, true, false, false, false, true));
            fulltextTextualFields.add(new SearchField(FIELD_NT, new PSolFieldBoost(2.99f, 2.0f, 0.2f), true, true, false, false, false, true));
            fulltextTextualFields.add(new SearchField(FIELD_NB, new PSolFieldBoost(2.98f, 2.0f, 0.2f), true));
            fulltextTextualFields.add(new SearchField(FIELD_PATH_TRANSLATED, new PSolFieldBoost(1.0f, true), true, true, false, false, false, true));
            fulltextTextualFields.add(new SearchField(FIELD_LINE_TEXT_VALUES, new PSolFieldBoost(1.0f, true), true).setFulltext(true));
            fulltextTextualFields.add(new SearchField(FIELD_CLASSID, new PSolFieldBoost(1.0f, false), false, true, false));
            fulltextTextualFields.add(new SearchField(FIELD_KEYWORDS, new PSolFieldBoost(0.95f, true), true, true, false, false, false, true));
            SearchField externalDocField = new SearchField(FIELD_DOCUMENT, new PSolFieldBoost(0.9f, true), true, true, false);
            externalDocField.setIsDocField(true);
            fulltextTextualFields.add(externalDocField);
            fulltextExactFields = new ArrayList<SearchField>();
            for (SearchField searchField : fulltextTextualFields) {
                try {
                    SearchField exactField = (SearchField)searchField.clone();
                    if (exactField.isTokenized()) {
                        exactField.setIsExact(true);
                    }
                    fulltextExactFields.add(exactField);
                }
                catch (CloneNotSupportedException exactField) {}
            }
            fulltextExactFields.add(new SearchField("nn_exact", new PSolFieldBoost(5.0f, 4.0f, 0.2f), false, true, false, false, false, true));
            fulltextExactFields.add(new SearchField("nt_exact", new PSolFieldBoost(4.99f, 4.0f, 0.2f), false, true, false, false, false, true));
            fulltextExactFields.add(new SearchField("nb_exact", new PSolFieldBoost(4.98f, 4.0f, 0.2f), false, true, false, false, false, true));
            fulltextExactFields.add(new SearchField("pathtranslated_exact", new PSolFieldBoost(3.5f, true), false, true, false, false, false, true));
            fulltextExactFields.add(new SearchField("keywords_exact", new PSolFieldBoost(3.4f, true), false, true, false, false, false, true));
            fulltextExactFields.add(new SearchField(FIELD_EXACTDATA, new PSolFieldBoost(3.5f, true), false, true, false, false, true, true));
            fulltextTextualFields = FieldDefinitions.parseFieldConfiguration(config, "FULLTEXTSEARCH", "TextualFields", fulltextTextualFields);
            fulltextExactFields = FieldDefinitions.parseFieldConfiguration(config, "FULLTEXTSEARCH", "ExactFields", fulltextExactFields);
            fulltextPhraseFields = new ArrayList<SearchField>();
            fulltextPhraseFields.add(new SearchField("nn_exact", new PSolFieldBoost(3.03f, 2.0f, 0.2f), false, true, false, false, false, true));
            fulltextPhraseFields.add(new SearchField("nt_exact", new PSolFieldBoost(3.02f, 2.0f, 0.2f), false, true, false, false, false, true));
            fulltextPhraseFields.add(new SearchField("nb_exact", new PSolFieldBoost(3.01f, 2.0f, 0.2f), false, true, false, false, false, true));
            fulltextPhraseFields.add(new SearchField("pathtranslated_exact", new PSolFieldBoost(1.1f, true), false, true, false, false, false, true));
            fulltextPhraseFields.add(new SearchField("keywords_exact", new PSolFieldBoost(1.0f, true), false, true, false, false, false, true));
            fulltextPhraseFields.add(new SearchField(FIELD_EXACTDATA, new PSolFieldBoost(1.1f, true), false, true, false, false, true, true));
            fulltextPhraseFields = FieldDefinitions.parseFieldConfiguration(config, "FULLTEXTSEARCH", "PhraseFields", fulltextPhraseFields);
            fulltextWildcardFields = new ArrayList<SearchField>();
            fulltextWildcardFields.add(new SearchField("nn_exact", 1.3f));
            fulltextWildcardFields.add(new SearchField("nt_exact", 1.2f));
            fulltextWildcardFields.add(new SearchField("nb_exact", 1.1f));
            fulltextWildcardFields.add(new SearchField("pathtranslated_exact", 1.0f));
            fulltextWildcardFields.add(new SearchField("keywords_exact", 0.95f));
            fulltextWildcardFields.add(new SearchField(FIELD_EXACTDATA, 1.0f));
            fulltextWildcardFields = FieldDefinitions.parseFieldConfiguration(config, "FULLTEXTSEARCH", "WildcardFields", fulltextWildcardFields);
            catalogBoost = FieldDefinitions.readCatalogBoost(config);
            rowBoost = new RowBoost[5];
            FieldDefinitions.rowBoost[0] = new RowBoost("eol", "End of life", -0.1f, false, 1L);
            FieldDefinitions.rowBoost[1] = new RowBoost("assist", "Assistant", -0.1f, false, 2L);
            FieldDefinitions.rowBoost[2] = new RowBoost("dir", "Directory", -2.0f, false, 4L);
            FieldDefinitions.rowBoost[3] = new RowBoost("doc", "Document", -0.1f, false, 8L);
            FieldDefinitions.rowBoost[4] = new RowBoost("nocad", "No Geometry", -0.1f, false, 16L);
            FieldDefinitions.readRowBoost(rowBoost, config);
            String strErpIndexBoost = config.getValue("ErpIndexBoost", "FULLTEXTSEARCH");
            if (strErpIndexBoost != null && !strErpIndexBoost.isEmpty() && !Double.isNaN(db = NumUtils.getNumeric(strErpIndexBoost))) {
                erpIndexBoost = (float)db;
            }
            if ((accuracyAsString = config.getValue("Accuracy", "INDEX:DYM")) != null && !accuracyAsString.isEmpty()) {
                try {
                    spellCheckerAccuracy = Float.parseFloat(accuracyAsString);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
            if ((maxWildcardTermStr = config.getValue("WildcardLimit", "FULLTEXTSEARCH")) != null && !maxWildcardTermStr.isEmpty()) {
                try {
                    WILDCARD_COST_LIMIT = Long.parseLong(maxWildcardTermStr);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
            maxDistinctValues = config.getInt("MaxDistinctNumericValues", "FULLTEXTSEARCH", 25);
            readerStateCacheSize = config.getInt("ReaderStateCacheSize", "FULLTEXTSEARCH", 50);
            disableRangeQuery = config.getBool("DisableRangeQuery", "FULLTEXTSEARCH");
        }
        PS_DEFAULT_DIM_CONFIG = new FacetsConfig.DimConfig();
        FieldDefinitions.PS_DEFAULT_DIM_CONFIG.multiValued = true;
        PS_VARFACETS_DIM_CONFIG = new FacetsConfig.DimConfig();
        FieldDefinitions.PS_VARFACETS_DIM_CONFIG.multiValued = true;
        FieldDefinitions.PS_VARFACETS_DIM_CONFIG.indexFieldName = "$varfacets";
        PS_FILTERASS_DIM_CONFIG = new FacetsConfig.DimConfig();
        FieldDefinitions.PS_FILTERASS_DIM_CONFIG.multiValued = true;
        FieldDefinitions.PS_FILTERASS_DIM_CONFIG.indexFieldName = "$filterfacets";
    }

    public static enum KeyWordType {
        NoKeyWord,
        StringKeyWord,
        NumericKeyWord,
        IntKeyWord;

    }

    public static enum LanguageGroup {
        German,
        English,
        French,
        Italian,
        Spanish,
        AsianCjk,
        Default;


        public int getFlagValue() {
            return 1 << this.ordinal();
        }
    }

    public static class CatalogBoost {
        public String catalog;
        public boolean byPrefix;
        public float boost;

        CatalogBoost(String catalog, boolean byPrefix, float boost) {
            this.catalog = catalog;
            this.byPrefix = byPrefix;
            this.boost = boost;
        }
    }

    public static class RowBoost {
        public String id;
        public String desc;
        public float factor;
        public boolean multiply;
        public long mask;

        RowBoost(String id, String desc, float factor, boolean multiply, long mask) {
            this.id = id;
            this.desc = desc;
            this.factor = factor;
            this.multiply = multiply;
            this.mask = mask;
        }
    }

    public static enum WordPart {
        WordComplete(0),
        WordBgn(2),
        WordMid(4),
        WordEnd(8);

        private final int payLoad;

        private WordPart(int payLoad) {
            this.payLoad = payLoad;
        }

        public int getPayLoad() {
            return this.payLoad;
        }
    }

    public static enum NumberFlag {
        Original,
        Converted,
        OriginalMatching,
        NoUnit;

    }

    public static enum FacetType {
        FacetCommon,
        FacetVariable,
        FacetFilterAssistant;


        public static String toIndexName(FacetType type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case FacetCommon -> "$facets";
                case FacetVariable -> "$varfacets";
                case FacetFilterAssistant -> "$filterfacets";
            };
        }
    }

    public static enum IndexType {
        Fulltext(0),
        LinkDb(1);

        private final int index;

        private IndexType(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static IndexType fromString(String s) {
            IndexType type = null;
            if (s.compareToIgnoreCase("fulltext") == 0) {
                type = Fulltext;
            } else if (s.compareToIgnoreCase("linkdb") == 0) {
                type = LinkDb;
            }
            return type;
        }

        public static String toString(IndexType type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case Fulltext -> "fulltext";
                case LinkDb -> "linkdb";
            };
        }
    }
}

