/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene;

import de.cadenas.catalogsearch.HighlightingRequest;
import de.cadenas.catalogsearch.api.IDocIdIndex;
import de.cadenas.catalogsearch.api.IFacetsResult;
import de.cadenas.catalogsearch.api.IIndexManager;
import de.cadenas.catalogsearch.api.ISearchRequest;
import de.cadenas.catalogsearch.api.ISearchResult;
import de.cadenas.catalogsearch.api.ISearchResultItem;
import de.cadenas.catalogsearch.api.ISearchServiceApi;
import de.cadenas.catalogsearch.api.impl.FacetsRequestImpl;
import de.cadenas.catalogsearch.api.impl.FacetsResultImpl;
import de.cadenas.catalogsearch.api.impl.SearchRequestImpl;
import de.cadenas.catalogsearch.api.impl.SearchResultImpl;
import de.cadenas.catalogsearch.api.impl.SearchResultItemImpl;
import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.analysis.FieldAwareAnalyzer;
import de.cadenas.catalogsearch.lucene.exceptions.UserInputException;
import de.cadenas.catalogsearch.lucene.exceptions.VariableNotAllowedException;
import de.cadenas.catalogsearch.lucene.facet.DefaultFacetListBuilder;
import de.cadenas.catalogsearch.lucene.facet.FacetStateProvider;
import de.cadenas.catalogsearch.lucene.facet.IFacetListBuilder;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightingInfoReceiverImpl;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightingScorer;
import de.cadenas.catalogsearch.lucene.index.CatalogMappingIndexReader;
import de.cadenas.catalogsearch.lucene.index.ExplanationData;
import de.cadenas.catalogsearch.lucene.queryparser.LexerToken;
import de.cadenas.catalogsearch.lucene.queryparser.QueryLexer;
import de.cadenas.catalogsearch.lucene.queryparser.QueryParser;
import de.cadenas.catalogsearch.lucene.queryparser.TokenType;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQuery;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeight;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumData;
import de.cadenas.catalogsearch.lucene.related.RelatedWord;
import de.cadenas.catalogsearch.lucene.related.RelatedWords;
import de.cadenas.catalogsearch.lucene.related.RelatedWordsRequest;
import de.cadenas.catalogsearch.lucene.search.CatalogBoostQuery;
import de.cadenas.catalogsearch.lucene.search.CountingCollectorManager;
import de.cadenas.catalogsearch.lucene.search.DocumentResolveCollector;
import de.cadenas.catalogsearch.lucene.search.DocumentResolveCollectorManager;
import de.cadenas.catalogsearch.lucene.search.FacetCountingFilter;
import de.cadenas.catalogsearch.lucene.search.FilteringCollectorManager;
import de.cadenas.catalogsearch.lucene.search.PSolDrillSideways;
import de.cadenas.catalogsearch.lucene.search.PSolTopScoreDocCollector;
import de.cadenas.catalogsearch.lucene.search.PSolTopScoreDocCollectorManager;
import de.cadenas.catalogsearch.lucene.search.QueryFactory;
import de.cadenas.catalogsearch.lucene.search.ResultVarsetBuilder;
import de.cadenas.catalogsearch.lucene.search.SearchResultBuilder;
import de.cadenas.catalogsearch.lucene.search.ValueRangeQuery;
import de.cadenas.catalogsearch.lucene.spell.SpellCheckRequest;
import de.cadenas.catalogsearch.lucene.spell.SpellChecker;
import de.cadenas.catalogsearch.lucene.util.DirectExecutorService;
import de.cadenas.util.PConfig;
import de.cadenas.util.PGenericPair;
import de.cadenas.util.PLogger;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.function.BiFunction;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.DrillSideways;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.apache.lucene.search.spell.LuceneLevenshteinDistance;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.ThreadInterruptedException;

public class LuceneSearchService
implements ISearchServiceApi {
    private static final PLogger logger = new PLogger(LuceneSearchService.class.getSimpleName());
    private final ExecutorService executorService;
    private final ExecutorService ddqExecutorService;
    private final boolean optimizedFacetCounter;
    private final Int2ObjectMap<List<SearchState>> searchStates = new Int2ObjectOpenHashMap<List<SearchState>>();
    private int lastSearchId = -1;

    public LuceneSearchService() {
        int threadCount = 2;
        try (PConfig partsol = new PConfig("$CADENAS_SETUP/partsol.cfg");){
            this.optimizedFacetCounter = true;
            try {
                String strValue = partsol.getValue("SearchThreadCount", "FULLTEXTSEARCH");
                if (strValue != null && !strValue.isEmpty()) {
                    int parsedInt;
                    threadCount = parsedInt = Integer.parseInt(strValue);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (threadCount > 1) {
            this.executorService = Executors.newWorkStealingPool();
            this.ddqExecutorService = Executors.newWorkStealingPool();
        } else {
            this.executorService = new DirectExecutorService();
            this.ddqExecutorService = new DirectExecutorService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISearchResult handleCachedSearch(ISearchRequest req, IIndexManager indexManager) {
        List stateList;
        int searchId = req.getSearchId();
        if (searchId == -1) {
            return null;
        }
        Int2ObjectMap<List<SearchState>> int2ObjectMap = this.searchStates;
        synchronized (int2ObjectMap) {
            stateList = (List)this.searchStates.get(searchId);
        }
        if (stateList == null) {
            return null;
        }
        SearchResultImpl lastResult = null;
        for (SearchState state : stateList) {
            SearchResultImpl searchResult = new SearchResultImpl();
            long[] scoreDocs = null;
            int offset = req.getLineOffset();
            if (offset == -1) {
                offset = state.lineOffset;
            }
            if (req.isTreeView()) {
                PSolTopScoreDocCollector.TopProjects result = state.collector.getTopProjects(req.getLimit(), offset, false, null);
                scoreDocs = result.scoreDocs();
            } else {
                scoreDocs = state.collector.getTopDocs(req.getLimit());
            }
            if (scoreDocs == null) continue;
            try {
                IIndexManager.IndexSearcherContainerLocked lockedContainer = indexManager.createIndexSearcher(req, state.indexType, this.executorService);
                try {
                    IIndexManager.IndexSearcherContainer container;
                    if (lockedContainer == null || (container = lockedContainer.getContainer()) == null) continue;
                    IndexSearcher indexSearcher = lockedContainer.getIndexSearcher();
                    boolean linkDbIndex = container.indexType == FieldDefinitions.IndexType.LinkDb;
                    this.fillSearchResult(searchResult, indexSearcher, state.query, scoreDocs, req, linkDbIndex, offset, state.referencedDocs, state.collector.getDocsFoundInCommonField(), indexManager);
                    state.lineOffset = scoreDocs.length;
                    if (lastResult == null) {
                        lastResult = searchResult;
                        continue;
                    }
                    SearchResultImpl result = lastResult;
                    result.merge(searchResult);
                }
                finally {
                    if (lockedContainer == null) continue;
                    lockedContainer.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (lastResult != null) {
            lastResult.searchId = searchId;
        }
        return lastResult;
    }

    String findCommonPathSequence(String path1, String path2) {
        String longerString;
        int i;
        int lastSlashPos = 0;
        for (i = 0; i < path1.length() && i < path2.length(); ++i) {
            if (path1.charAt(i) != path2.charAt(i)) {
                return path1.substring(0, lastSlashPos);
            }
            if (path1.charAt(i) != '/') continue;
            lastSlashPos = i;
        }
        String string = longerString = path1.length() > path2.length() ? path1 : path2;
        if (i == longerString.length() || longerString.charAt(i) == '/') {
            lastSlashPos = i;
        }
        return path1.substring(0, lastSlashPos);
    }

    String getCommonDirectory(List<SearchState> stateList, IIndexManager indexManager) {
        String bestDir = null;
        for (SearchState state : stateList) {
            IIndexManager.IIndexReaderData readerData;
            List<FacetsCollector.MatchingDocs> matchingDocList = state.collector.getMatchingDocs();
            if (matchingDocList.isEmpty() || (readerData = indexManager.findReaderData(matchingDocList.get((int)0).context.parent.reader())) == null) continue;
            int docBase = matchingDocList.get((int)0).context.parent.docBaseInParent;
            IDocIdIndex docIdIndex = readerData.getDocIdIndex();
            LongArrayList allDocs = state.collector.getDocsForProjectEvaluation();
            LongListIterator longListIterator = allDocs.iterator();
            while (longListIterator.hasNext()) {
                int idx;
                long sd = (Long)longListIterator.next();
                int doc = (int)sd * -1;
                String path = docIdIndex.getDocPath(doc -= docBase);
                if (path == null || !path.endsWith(".prj") || (idx = path.lastIndexOf(47)) < 1) continue;
                String pathSequence = path.substring(0, idx);
                if (bestDir == null) {
                    bestDir = pathSequence;
                    continue;
                }
                if ((bestDir = this.findCommonPathSequence(pathSequence, bestDir)) != null && !bestDir.isEmpty()) continue;
                return null;
            }
        }
        return bestDir;
    }

    void processFacetResults(ISearchRequest req, IIndexManager indexManager, List<SearchState> stateList, FacetCountingFilter facetFilter, SearchResultBuilder builder, ISearchResult searchResult) {
        if (stateList.isEmpty()) {
            return;
        }
        Object commonCatalog = null;
        for (SearchState state : stateList) {
            String catalogName = FacetStateProvider.getCommonCatalogName(state.collector.getMatchingDocs(), indexManager);
            if (catalogName == null) continue;
            if (commonCatalog == null) {
                commonCatalog = catalogName;
                continue;
            }
            if (((String)commonCatalog).equals(catalogName)) continue;
            commonCatalog = null;
            break;
        }
        if (req.evaluateCommonDir() && commonCatalog != null && !((String)commonCatalog).isEmpty()) {
            ((SearchResultImpl)searchResult).commonDirectory = this.getCommonDirectory(stateList, indexManager);
        }
        ArrayList<PGenericPair<SearchState, IFacetListBuilder.Result>> statesAndFacets = new ArrayList<PGenericPair<SearchState, IFacetListBuilder.Result>>();
        int idx = 0;
        for (SearchState state : stateList) {
            boolean bl;
            IFacetListBuilder.Result facetList;
            facetFilter.setFilterMode(idx > 0);
            if (state.facetListBuilder == null || (facetList = state.facetListBuilder.buildResults(commonCatalog != null && !((String)commonCatalog).isEmpty(), bl = (req.facetTypes() & 4) != 0)) == null) continue;
            statesAndFacets.add(new PGenericPair<SearchState, IFacetListBuilder.Result>(state, facetList));
            ++idx;
        }
        if (statesAndFacets.size() == 2) {
            List<FacetResult> list1 = null;
            if (!((IFacetListBuilder.Result)((PGenericPair)statesAndFacets.get((int)0)).second).facetResults.isEmpty()) {
                list1 = ((IFacetListBuilder.Result)((PGenericPair)statesAndFacets.get((int)0)).second).facetResults.get(0);
            }
            List<FacetResult> list2 = null;
            if (!((IFacetListBuilder.Result)((PGenericPair)statesAndFacets.get((int)1)).second).facetResults.isEmpty()) {
                list2 = ((IFacetListBuilder.Result)((PGenericPair)statesAndFacets.get((int)1)).second).facetResults.get(0);
            }
            if (list1 != null && list2 != null) {
                SearchResultBuilder.filterLanguageDependentFacets(list1, list2, req.getLanguageList());
            }
        }
        int run = 0;
        for (PGenericPair pGenericPair : statesAndFacets) {
            facetFilter.setFilterMode(run > 0);
            SearchState state = (SearchState)pGenericPair.first;
            IFacetListBuilder.Result facetList = (IFacetListBuilder.Result)pGenericPair.second;
            SearchResultImpl resultImpl = (SearchResultImpl)searchResult;
            if (run > 0) {
                resultImpl = new SearchResultImpl();
            }
            for (List<FacetResult> facetResults : facetList.facetResults) {
                String groupName = run == 0 ? req.getErpGroupName() : null;
                builder.fillSearchResultWithMinMax(resultImpl, facetResults, state.collector.getMatchingDocs(), facetList.numericSideways, groupName);
                builder.fillSearchResultWithFacets(resultImpl, facetResults, req.getErpGroupName());
            }
            if (run > 0) {
                ((SearchResultImpl)searchResult).merge(resultImpl);
            }
            ++run;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISearchResult executeSearch(ISearchRequest req, IIndexManager indexManager) throws Exception {
        ISearchResult lastResult;
        block32: {
            ISearchResult res = this.handleCachedSearch(req, indexManager);
            if (res != null) {
                return res;
            }
            ExecutorService executorService = this.executorService;
            ExecutorService ddqExecutorService = this.ddqExecutorService;
            int threadCount = req.getThreadCount();
            if (threadCount > 0) {
                if (threadCount == 1) {
                    executorService = new DirectExecutorService();
                    ddqExecutorService = new DirectExecutorService();
                } else {
                    executorService = Executors.newFixedThreadPool(threadCount);
                    ddqExecutorService = Executors.newFixedThreadPool(threadCount);
                }
            }
            lastResult = null;
            try (IIndexManager.IndexSearcherContainerLocked container0 = req.getErpGroupName() == null || req.getErpGroupName().isEmpty() ? null : indexManager.createIndexSearcher(req, FieldDefinitions.IndexType.LinkDb, executorService);
                 IIndexManager.IndexSearcherContainerLocked container1 = req.getErpGroupName() != null && !req.getErpGroupName().isEmpty() && req.isErpPreferredLine() ? null : indexManager.createIndexSearcher(req, FieldDefinitions.IndexType.Fulltext, executorService);){
                IIndexManager.IndexSearcherContainerLocked[] containers = container0 != null && container1 != null ? new IIndexManager.IndexSearcherContainerLocked[]{container0, container1} : (container0 != null ? new IIndexManager.IndexSearcherContainerLocked[]{container0} : new IIndexManager.IndexSearcherContainerLocked[]{container1});
                FacetCountingFilter facetFilter = new FacetCountingFilter(indexManager);
                SearchResultBuilder builder = new SearchResultBuilder(facetFilter, req.facetFilter(), req.getLanguageList());
                int varCount = req.getVariableFacetCount();
                if (varCount > 0) {
                    builder.setVariableFacetCount(varCount);
                }
                if ((req.facetTypes() & 4) != 0) {
                    builder.setIncludeFilterAssistantFacets(true);
                }
                ArrayList<SearchState> stateList = new ArrayList<SearchState>();
                HashSet<String> countedProjects = null;
                if (req.countProjects() && containers.length > 1) {
                    countedProjects = new HashSet<String>();
                }
                block17: for (int i = 0; i < containers.length; ++i) {
                    IIndexManager.IndexSearcherContainer container;
                    IIndexManager.IndexSearcherContainerLocked lockedContainer = containers[i];
                    if (lockedContainer == null || (container = lockedContainer.getContainer()) == null) continue;
                    try {
                        SearchState state = new SearchState();
                        state.indexType = container.indexType;
                        state.countedProjects = countedProjects;
                        res = this.doSearch(req, container, lockedContainer.getIndexSearcher(), indexManager, facetFilter, state, executorService, ddqExecutorService);
                        if (i == 0 && containers.length > 1 && state.collector != null) {
                            facetFilter.setupFilter(state.collector);
                            facetFilter.setFilterMode(true);
                        }
                        if (res == null) continue;
                        stateList.add(state);
                        if (lastResult == null) {
                            lastResult = res;
                            continue;
                        }
                        if (!(lastResult instanceof SearchResultImpl)) continue;
                        SearchResultImpl result = (SearchResultImpl)lastResult;
                        result.merge(res);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error(e);
                        for (Throwable ep = e; ep != null; ep = ep.getCause()) {
                            if (!(ep instanceof UserInputException)) continue;
                            UserInputException ue = (UserInputException)ep;
                            SearchResultImpl searchResult = new SearchResultImpl();
                            searchResult.addError(ue);
                            lastResult = searchResult;
                            continue block17;
                        }
                    }
                }
                if (req.isFacetedSearch() && lastResult != null && (lastResult.getTotalHitCount() > 0 || req.getForceFacetCreation())) {
                    this.processFacetResults(req, indexManager, stateList, facetFilter, builder, lastResult);
                }
                if (lastResult == null || stateList.isEmpty()) break block32;
                for (SearchState state : stateList) {
                    state.facetListBuilder = null;
                    state.countedProjects = null;
                }
                if (!req.keepSearch()) break block32;
                Int2ObjectMap<List<SearchState>> int2ObjectMap = this.searchStates;
                synchronized (int2ObjectMap) {
                    int searchId = ++this.lastSearchId;
                    this.searchStates.put(searchId, (List<SearchState>)stateList);
                    SearchResultImpl resultImpl = (SearchResultImpl)lastResult;
                    resultImpl.searchId = searchId;
                }
            }
        }
        return lastResult;
    }

    private IFacetsResult retrieveFilteredFacets(FacetsRequestImpl req, IIndexManager indexManager) throws Exception {
        SearchRequestImpl searchRequest = new SearchRequestImpl();
        searchRequest.query = "";
        searchRequest.facetedSearch = true;
        searchRequest.restoreVarsets = false;
        searchRequest.limit = 1;
        searchRequest.languageList = req.languageList;
        searchRequest.searchDocuments = false;
        searchRequest.erpGroupName = req.erpGroupName;
        searchRequest.erpPreferredLine = req.erpPreferredLine;
        searchRequest.termFilters = req.termFilters;
        searchRequest.rangeFilters = req.rangeFilters;
        List<String> catalogs = new ArrayList<String>(req.parts.size());
        catalogs.addAll(req.parts.keySet());
        catalogs = indexManager.mapToContainingCatalogs(catalogs);
        ISearchRequest.PathFilter pathFilter = new ISearchRequest.PathFilter(catalogs, null, null, null);
        searchRequest.pathFilters.add(pathFilter);
        searchRequest.partFilter = req.parts;
        ISearchResult searchResult = this.executeSearch(searchRequest, indexManager);
        if (searchResult == null) {
            return null;
        }
        FacetsResultImpl ret = new FacetsResultImpl();
        ret.moreVarFacetsAvailable = searchResult.getMoreVarFacetsAvailable();
        ret.filters = searchResult.getFilters();
        ret.commonDirectory = searchResult.getCommonDirectory();
        return ret;
    }

    private FieldDefinitions.IndexType[] getSearchIndexTypes(String erpGroupName, boolean erpPreferredLine) {
        FieldDefinitions.IndexType[] indexTypes = null;
        indexTypes = erpGroupName == null || erpGroupName.isEmpty() ? new FieldDefinitions.IndexType[]{FieldDefinitions.IndexType.Fulltext} : (erpPreferredLine ? new FieldDefinitions.IndexType[]{FieldDefinitions.IndexType.LinkDb} : new FieldDefinitions.IndexType[]{FieldDefinitions.IndexType.LinkDb, FieldDefinitions.IndexType.Fulltext});
        return indexTypes;
    }

    @Override
    public IFacetsResult retrieveFacets(FacetsRequestImpl req, IIndexManager indexManager) throws Exception {
        if (!req.termFilters.isEmpty() || !req.rangeFilters.isEmpty()) {
            return this.retrieveFilteredFacets(req, indexManager);
        }
        List<String> catalogs = new ArrayList<String>(req.parts.size());
        catalogs.addAll(req.parts.keySet());
        boolean loadVariableFacets = catalogs.size() == 1;
        catalogs = indexManager.mapToContainingCatalogs(catalogs);
        FacetCountingFilter facetFilter = new FacetCountingFilter(indexManager);
        FieldDefinitions.IndexType[] indexTypes = this.getSearchIndexTypes(req.erpGroupName, req.erpPreferredLine);
        SearchResultImpl resultImpl = new SearchResultImpl();
        SearchResultBuilder resultBuilder = new SearchResultBuilder(facetFilter, req.facetFilter, req.languageList);
        if (req.variableFacetCount > 0) {
            resultBuilder.setVariableFacetCount(req.variableFacetCount);
        }
        for (FieldDefinitions.IndexType indexType : indexTypes) {
            try (IIndexManager.IndexSearcherContainerLocked lockedContainer = indexManager.createIndexSearcher(catalogs, indexType, this.executorService);){
                IIndexManager.IndexSearcherContainer container;
                if (lockedContainer == null || (container = lockedContainer.getContainer()) == null) continue;
                HashMap<CompositeReader, IntList> docIDs = new HashMap<CompositeReader, IntList>();
                ArrayList<FacetsCollector.MatchingDocs> matchingDocs = new ArrayList<FacetsCollector.MatchingDocs>();
                IndexReaderContext context = container.getIndexReader().getContext();
                List<LeafReaderContext> leaves = context.leaves();
                for (int l = 0; l < leaves.size(); ++l) {
                    LeafReaderContext leafReaderContext = leaves.get(l);
                    IIndexManager.IIndexReaderData readerData = indexManager.findReaderData(leafReaderContext.parent.reader());
                    IntList docIdList = (IntList)docIDs.get(leafReaderContext.parent.reader());
                    if (docIdList == null) {
                        docIdList = new IntArrayList();
                        if (readerData != null) {
                            Object usedCatalog;
                            List<FacetsRequestImpl.PartId> partList = null;
                            Iterator<String> iterator = readerData.getUsedCatalogNames().iterator();
                            while (iterator.hasNext() && (partList = req.parts.get(usedCatalog = iterator.next())) == null) {
                            }
                            if (partList == null) continue;
                            IDocIdIndex docIdIndex = readerData.getDocIdIndex();
                            usedCatalog = partList.iterator();
                            while (usedCatalog.hasNext()) {
                                FacetsRequestImpl.PartId partId = (FacetsRequestImpl.PartId)usedCatalog.next();
                                docIdIndex.collectDocIds(partId.classId, partId.lineId, partId.lineSubId, docIdList, true);
                            }
                        }
                        docIDs.put(leafReaderContext.parent.reader(), docIdList);
                    }
                    if (docIdList.isEmpty()) continue;
                    int rangeBegin = leafReaderContext.docBaseInParent;
                    int rangeEnd = Integer.MAX_VALUE;
                    if (l < leaves.size() - 1 && leaves.get((int)l).parent == leaves.get((int)(l + 1)).parent) {
                        rangeEnd = leaves.get((int)(l + 1)).docBaseInParent;
                    }
                    DocIdSetBuilder docsBuilder = new DocIdSetBuilder(context.reader().maxDoc());
                    int hitCount = 0;
                    IntListIterator intListIterator = docIdList.iterator();
                    while (intListIterator.hasNext()) {
                        int doc = (Integer)intListIterator.next();
                        if (doc < rangeBegin || doc >= rangeEnd) continue;
                        docsBuilder.grow(1).add(doc - rangeBegin);
                        ++hitCount;
                    }
                    matchingDocs.add(new FacetsCollector.MatchingDocs(leafReaderContext, docsBuilder.build(), hitCount, null));
                }
                DefaultFacetListBuilder builder = new DefaultFacetListBuilder(indexManager, container, matchingDocs, facetFilter, 3, this.optimizedFacetCounter, this.executorService);
                IFacetListBuilder.Result facetResult = builder.buildResults(loadVariableFacets, false);
                if (facetResult == null) continue;
                for (List<FacetResult> facetsResults : facetResult.facetResults) {
                    String groupName = container.indexType == FieldDefinitions.IndexType.LinkDb ? req.erpGroupName : null;
                    resultBuilder.fillSearchResultWithMinMax(resultImpl, facetsResults, matchingDocs, null, groupName);
                    resultBuilder.fillSearchResultWithFacets(resultImpl, facetsResults, groupName);
                }
            }
        }
        if (!resultImpl.filters.isEmpty()) {
            FacetsResultImpl ret = new FacetsResultImpl();
            ret.moreVarFacetsAvailable = resultImpl.moreFacetsAvailable;
            ret.filters = resultImpl.filters;
            return ret;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSearch(int searchId) {
        Int2ObjectMap<List<SearchState>> int2ObjectMap = this.searchStates;
        synchronized (int2ObjectMap) {
            this.searchStates.remove(searchId);
        }
    }

    @Override
    public ISearchServiceApi.CountingResult estimateResultCount(ISearchRequest req, IIndexManager indexManager) throws Exception {
        ISearchServiceApi.CountingResult result = null;
        try (IIndexManager.IndexSearcherContainerLocked searcherContainer = indexManager.createIndexSearcher(req, FieldDefinitions.IndexType.Fulltext, this.executorService);){
            if (searcherContainer != null) {
                Query baseQuery = QueryFactory.createQuery(req, null);
                CountingCollectorManager collectorManager = new CountingCollectorManager();
                IndexSearcher indexSearcher = searcherContainer.getIndexSearcher();
                result = indexSearcher.search(baseQuery, collectorManager);
            }
        }
        String erpGroupName = req.getErpGroupName();
        if (erpGroupName != null) {
            try (IIndexManager.IndexSearcherContainerLocked searcherContainer = indexManager.createIndexSearcher(req, FieldDefinitions.IndexType.LinkDb, this.executorService);){
                if (searcherContainer != null) {
                    Query baseQuery = QueryFactory.createQuery(req, erpGroupName);
                    CountingCollectorManager collectorManager = new CountingCollectorManager();
                    IndexSearcher indexSearcher = searcherContainer.getIndexSearcher();
                    ISearchServiceApi.CountingResult linkDbResult = indexSearcher.search(baseQuery, collectorManager);
                    if (result != null) {
                        Set<String> usedCatalogs = result.usedCatalogs();
                        usedCatalogs.addAll(linkDbResult.usedCatalogs());
                        result = new ISearchServiceApi.CountingResult(result.totalHitCount() + linkDbResult.totalHitCount(), usedCatalogs);
                    } else {
                        result = linkDbResult;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public PGenericPair<List<String>, Boolean> executeHighlighting(HighlightingRequest req, IIndexManager indexManager) throws Exception {
        PGenericPair<List<String>, Boolean> response = new PGenericPair<List<String>, Boolean>(new ArrayList(), false);
        if (req.searchQuery.trim().compareTo("*") == 0) {
            for (HighlightingRequest.Fragment frag : req.fragments) {
                ((List)response.first).add(frag.value);
            }
            response.second = true;
        } else {
            Query query = QueryFactory.createQuery(req.searchQuery, req.languageList, null, false);
            if (query != null) {
                HighlightingInfoReceiverImpl highlightingTree = new HighlightingInfoReceiverImpl(query, req);
                response.first = highlightingTree.getHighlightedFragments();
                response.second = highlightingTree.highlightingFinished();
            }
        }
        return response;
    }

    @Override
    public ExplanationData explainSearchResults(ISearchRequest req, IIndexManager indexManager) throws Exception {
        try (IIndexManager.IndexSearcherContainerLocked searcherContainer = req.getErpGroupName() == null || req.getErpGroupName().isEmpty() ? indexManager.createIndexSearcher(req, FieldDefinitions.IndexType.Fulltext, this.executorService) : indexManager.createIndexSearcher(req, FieldDefinitions.IndexType.LinkDb, this.executorService);){
            if (searcherContainer == null) {
                ExplanationData explanationData = new ExplanationData();
                return explanationData;
            }
            Query baseQuery = QueryFactory.createQuery(req, req.getErpGroupName());
            if (searcherContainer.getContainer().hasCatalogBoosts) {
                baseQuery = new CatalogBoostQuery(baseQuery, searcherContainer.getContainer().getCatalogBoosts());
            }
            TopScoreDocCollector collector = TopScoreDocCollector.create(req.getOffset() + req.getLimit(), Integer.MAX_VALUE);
            searcherContainer.getIndexSearcher().search(baseQuery, collector);
            TopDocs topDocs = collector.topDocs(req.getOffset(), req.getLimit());
            ExplanationData explanationData = this.getResultsExplanation(indexManager, searcherContainer.getIndexSearcher(), baseQuery, topDocs.scoreDocs);
            return explanationData;
        }
    }

    @SafeVarargs
    private FilteringCollectorManager createFilteringCollectorManager(int topDocs, boolean collectFacets, boolean boostCatalogs, boolean collectProjects, boolean enableCheckinCommonField, String childFolderFilter, CollectorManager<? extends Collector, ?> ... collectorManagers) {
        if (topDocs <= 0) {
            return new FilteringCollectorManager(collectorManagers);
        }
        CollectorManager[] arr = new CollectorManager[collectorManagers.length + 1];
        arr[0] = new PSolTopScoreDocCollectorManager(topDocs, collectFacets, boostCatalogs, collectProjects, enableCheckinCommonField, childFolderFilter);
        System.arraycopy(collectorManagers, 0, arr, 1, collectorManagers.length);
        return new FilteringCollectorManager(arr);
    }

    private ISearchResult doSearch(ISearchRequest req, IIndexManager.IndexSearcherContainer indexSearcherContainer, IndexSearcher indexSearcher, IIndexManager indexManager, FacetCountingFilter facetFilter, SearchState state, ExecutorService executorService, ExecutorService ddqExecutorService) throws IOException {
        List<FacetsCollector.MatchingDocs> matchingDocs;
        Query baseQuery;
        if (indexSearcher.getIndexReader().numDocs() == 0) {
            return null;
        }
        String erpGroup = null;
        if (indexSearcherContainer.indexType.equals((Object)FieldDefinitions.IndexType.LinkDb)) {
            erpGroup = req.getErpGroupName();
        } else {
            for (ISearchRequest.TermFilter termFilter : req.getTermFilters()) {
                if (!termFilter.isErpFilter()) continue;
                return null;
            }
            for (ISearchRequest.RangeFilter rangeFilter : req.getRangeFilters()) {
                if (!rangeFilter.isErpFilter()) continue;
                return null;
            }
        }
        try {
            baseQuery = QueryFactory.createQuery(req, erpGroup);
        }
        catch (UserInputException e) {
            return new SearchResultImpl(e);
        }
        if (baseQuery == null) {
            return null;
        }
        PSolTopScoreDocCollector docCollector = null;
        long[] scoreDocs = null;
        FilteringCollectorManager collectorManager = null;
        ResultCollector resultCollector = null;
        int totalHits = 0;
        int projectCount = 0;
        Int2ObjectMap<IntList> referencedDocs = null;
        IFacetListBuilder facetListBuilder = null;
        if (!req.isFacetedSearch()) {
            try {
                QueryFactory.DrillDownQueryContainer ddq = QueryFactory.createDrillDownQuery(req, baseQuery, true);
                baseQuery = ddq.modifiedBaseQuery;
            }
            catch (VariableNotAllowedException e) {
                return new SearchResultImpl(e);
            }
        }
        Query executedQuery = baseQuery;
        boolean boostCatalogs = indexSearcherContainer.hasCatalogBoosts;
        int offset = req.getLineOffset();
        if (offset == -1) {
            offset = 0;
        }
        boolean enableCheckInCommonField = this.checkIfSinglePSolQuery(baseQuery);
        if (req.isFacetedSearch()) {
            QueryFactory.DrillDownQueryContainer ddq;
            try {
                ddq = QueryFactory.createDrillDownQuery(req, baseQuery, false);
            }
            catch (VariableNotAllowedException e) {
                return new SearchResultImpl(e);
            }
            executedQuery = baseQuery = ddq.modifiedBaseQuery;
            logger.debug("search (+facets): " + baseQuery.toString());
            if (req.searchDocuments()) {
                DocumentResolveCollectorManager docResolverManager = new DocumentResolveCollectorManager();
                collectorManager = this.createFilteringCollectorManager(req.getLimit(), true, boostCatalogs, req.isTreeView(), enableCheckInCommonField, req.getChildFolderFilter(), docResolverManager);
            } else {
                collectorManager = this.createFilteringCollectorManager(req.getLimit(), true, boostCatalogs, req.isTreeView(), enableCheckInCommonField, req.getChildFolderFilter(), new CollectorManager[0]);
            }
            collectorManager.setSearchResultFilter(req.getByProjectFilter(), req.getExcludedProjectsFilter());
            if (ddq.ddq == null) {
                Object[] result = indexSearcher.search(baseQuery, collectorManager);
                resultCollector = new ResultCollector(result);
            } else {
                executedQuery = ddq.ddq;
                FacetStateProvider facetProvider = new FacetStateProvider(indexManager, indexSearcherContainer);
                PSolDrillSideways ds = new PSolDrillSideways(indexSearcher, FieldDefinitions.getFacetsConfig(), facetProvider, facetFilter, ddqExecutorService, this.optimizedFacetCounter);
                if (ddq.specialNumericQueries != null) {
                    for (Map.Entry<String, Query> item : ddq.specialNumericQueries.entrySet()) {
                        PSolTopScoreDocCollector collector = new PSolTopScoreDocCollector(50, true, false);
                        indexSearcher.search(item.getValue(), collector);
                        ds.addNumericSidewaysDocs(item.getKey(), collector.getMatchingDocs());
                    }
                }
                DrillSideways.ConcurrentDrillSidewaysResult<Object[]> res = ds.search(ddq.ddq, collectorManager);
                Object[] result = (Object[])res.collectorResult;
                resultCollector = new ResultCollector(result);
                facetListBuilder = ds.getFacetListBuilder();
            }
            if (req.isTreeView()) {
                PSolTopScoreDocCollector.TopProjects ret = resultCollector.docCollector.getTopProjects(req.getLimit(), offset, req.countProjects(), state.countedProjects);
                scoreDocs = ret.scoreDocs();
                projectCount = ret.projectCount();
            }
        } else if (req.isTreeView()) {
            logger.debug("search (treeview): " + baseQuery.toString());
            collectorManager = req.searchDocuments() ? new FilteringCollectorManager(new PSolTopScoreDocCollectorManager(1000, true, boostCatalogs, req.isTreeView(), enableCheckInCommonField, req.getChildFolderFilter()), new DocumentResolveCollectorManager()) : new FilteringCollectorManager(new PSolTopScoreDocCollectorManager(1000, true, boostCatalogs, req.isTreeView(), enableCheckInCommonField, req.getChildFolderFilter()));
            collectorManager.setSearchResultFilter(req.getByProjectFilter(), req.getExcludedProjectsFilter());
            result = indexSearcher.search(baseQuery, collectorManager);
            resultCollector = new ResultCollector(result);
            docCollector = resultCollector.docCollector;
            PSolTopScoreDocCollector.TopProjects collectResults = docCollector.getTopProjects(req.getLimit(), offset, req.countProjects(), state.countedProjects);
            totalHits = collectResults.totalHits();
            scoreDocs = collectResults.scoreDocs();
            projectCount = collectResults.projectCount();
        } else {
            collectorManager = req.searchDocuments() ? this.createFilteringCollectorManager(req.getLimit(), false, boostCatalogs, req.isTreeView(), enableCheckInCommonField, req.getChildFolderFilter(), new DocumentResolveCollectorManager()) : this.createFilteringCollectorManager(req.getLimit(), false, boostCatalogs, req.isTreeView(), enableCheckInCommonField, req.getChildFolderFilter(), new CollectorManager[0]);
            collectorManager.setSearchResultFilter(req.getByProjectFilter(), req.getExcludedProjectsFilter());
            logger.debug("search (-facets): " + baseQuery.toString());
            result = indexSearcher.search(baseQuery, collectorManager);
            resultCollector = new ResultCollector(result);
        }
        docCollector = resultCollector.docCollector;
        if (totalHits == 0) {
            totalHits = resultCollector.totalHits;
        }
        if (scoreDocs == null) {
            scoreDocs = resultCollector.scoreDocs;
        }
        if (resultCollector.docResolver != null) {
            referencedDocs = resultCollector.docResolver.getReferencedDocs();
        }
        if (facetFilter.getFilterMode() && (matchingDocs = docCollector.getMatchingDocs()) != null && !matchingDocs.isEmpty()) {
            totalHits = 0;
            for (FacetsCollector.MatchingDocs md : matchingDocs) {
                CompositeReader reader = md.context.parent.reader();
                IIndexManager.IIndexReaderData container = indexManager.findReaderData(reader);
                if (container == null) continue;
                totalHits += facetFilter.countFilteredDocIds(container, md, null);
            }
        }
        SearchResultImpl searchResult = new SearchResultImpl();
        searchResult.totalHitCount = totalHits;
        searchResult.totalProjectCount = projectCount;
        if (scoreDocs != null && scoreDocs.length > 0) {
            boolean linkDbIndex = indexSearcherContainer.indexType == FieldDefinitions.IndexType.LinkDb;
            this.fillSearchResult(searchResult, indexSearcher, executedQuery, scoreDocs, req, linkDbIndex, offset, referencedDocs, docCollector.getDocsFoundInCommonField(), indexManager);
        }
        if (docCollector != null) {
            searchResult.childFolderFilter = docCollector.getCollectedChilds();
        }
        if (state != null) {
            state.collector = docCollector;
            state.query = executedQuery;
            if (scoreDocs != null) {
                state.lineOffset = scoreDocs.length;
            }
            if (facetListBuilder == null) {
                facetListBuilder = new DefaultFacetListBuilder(indexManager, indexSearcherContainer, docCollector.getMatchingDocs(), facetFilter, req.facetTypes(), this.optimizedFacetCounter, executorService);
            }
            state.facetListBuilder = facetListBuilder;
        }
        return searchResult;
    }

    private void fillSearchResult(SearchResultImpl searchResult, IndexSearcher indexSearcher, Query query, long[] scoreDocs, ISearchRequest req, boolean linkDbIndex, int offset, Int2ObjectMap<IntList> referencedDocs, IntArrayList docsFoundInCommonField, IIndexManager indexManager) {
        ResultVarsetBuilder vsBuilder = null;
        boolean restoreVarsets = req.restoreVarsets();
        if (restoreVarsets && scoreDocs.length > 0) {
            vsBuilder = new ResultVarsetBuilder(query);
        }
        CatalogMappingIndexReader indexReader = (CatalogMappingIndexReader)indexSearcher.getIndexReader();
        Int2ObjectOpenHashMap<BytesRef> vrDataLookup = null;
        if (restoreVarsets) {
            vrDataLookup = new Int2ObjectOpenHashMap<BytesRef>();
        }
        for (int i = offset; i < scoreDocs.length; ++i) {
            long sd = scoreDocs[i];
            try {
                Explanation explanation;
                IntList docList;
                BytesRef vrData;
                int vrDoc;
                int sdDoc = (int)sd * -1;
                int scoreBits = (int)(sd >> 32);
                float sdScore = NumericUtils.sortableIntToFloat(scoreBits);
                IndexReader subReader = indexReader.readerByDocId(sdDoc);
                IIndexManager.IIndexReaderData container = indexManager.findReaderData(subReader);
                IDocIdIndex docIdIndex = container.getDocIdIndex();
                int baseDocId = indexReader.docIdBase(sdDoc);
                IDocIdIndex.LineData data = docIdIndex.findLineData(sdDoc - baseDocId);
                if (data == null) continue;
                SearchResultItemImpl resultItem = new SearchResultItemImpl();
                resultItem.score = sdScore;
                resultItem.catalog = data.catalogPath;
                resultItem.path = data.path;
                resultItem.lineId = data.lineId;
                resultItem.lineSubId = data.lineSubId;
                resultItem.varset = data.varset;
                resultItem.hidesOriginalLine = data.hidesOriginalLine;
                if (restoreVarsets && (docsFoundInCommonField == null || !docsFoundInCommonField.contains(sdDoc)) && (vrDoc = data.valueRangeDoc) != -1 && (vrData = vrDataLookup.computeIfAbsent(vrDoc + baseDocId, k -> {
                    try {
                        Document doc = indexSearcher.doc(vrDoc + baseDocId);
                        return doc.getBinaryValue("valuerangedef");
                    }
                    catch (IOException ignored) {
                        return null;
                    }
                })) != null && vrData.length > 0) {
                    vsBuilder.processItem(resultItem, vrData, linkDbIndex);
                }
                if (req.searchDocuments() && !req.docHlStart().isEmpty() && referencedDocs != null && !referencedDocs.isEmpty() && (docList = (IntList)referencedDocs.get(sdDoc)) != null && !docList.isEmpty()) {
                    IntListIterator intListIterator = docList.iterator();
                    while (intListIterator.hasNext()) {
                        String[] fragments;
                        int docDocId = (Integer)intListIterator.next();
                        Document docDoc = indexSearcher.doc(docDocId);
                        String docContents = docDoc.get("document");
                        String language = docDoc.get("document_language");
                        if (docContents == null || docContents.isEmpty() || (fragments = this.highlightDocumentContents(docContents, query, req, language)) == null) continue;
                        ISearchResultItem.DocumentInfo docInfo = new ISearchResultItem.DocumentInfo();
                        docInfo.columnName = docDoc.get("column");
                        docInfo.documentPath = docDoc.get("docpath");
                        docInfo.basePath = docDoc.get("docbasepath");
                        docInfo.documentRelPath = docDoc.get("docrelpath");
                        docInfo.fragments = fragments;
                        if (resultItem.documentInfos == null) {
                            resultItem.documentInfos = new ArrayList<ISearchResultItem.DocumentInfo>();
                        }
                        resultItem.documentInfos.add(docInfo);
                    }
                }
                if (req.explainResults() && (explanation = indexSearcher.explain(query, sdDoc)) != null) {
                    resultItem.explanation = explanation.toString();
                }
                searchResult.items.add(resultItem);
                continue;
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
    }

    boolean checkIfSinglePSolQuery(Query query) {
        if (this.countPSolQueries(query) == 1) {
            return this.checkIfSinglePSolQueryRecursive(query);
        }
        return false;
    }

    int countPSolQueries(Query query) {
        if (query == null) {
            return 0;
        }
        int count = 0;
        if (query instanceof BooleanQuery) {
            BooleanQuery bquery = (BooleanQuery)query;
            for (BooleanClause clause : bquery.clauses()) {
                count += this.countPSolQueries(clause.getQuery());
            }
        } else if (query instanceof PSolQuery) {
            ++count;
        } else if (query instanceof ValueRangeQuery) {
            count += 100;
        }
        return count;
    }

    boolean checkIfSinglePSolQueryRecursive(Query query) {
        PSolQuery psquery;
        if (query == null) {
            return false;
        }
        if (query instanceof BooleanQuery) {
            BooleanQuery bquery = (BooleanQuery)query;
            for (BooleanClause clause : bquery.clauses()) {
                if (!this.checkIfSinglePSolQueryRecursive(clause.getQuery())) continue;
                return true;
            }
        }
        if (query instanceof PSolQuery && (psquery = (PSolQuery)query).getQueryItems().size() > 1) {
            psquery.setCheckInCommonField(true);
            return true;
        }
        return false;
    }

    private String[] highlightDocumentContents(String contents, Query query, ISearchRequest req, String language) {
        FieldAwareAnalyzer analyzer = new FieldAwareAnalyzer(false);
        HighlightingScorer scorer = new HighlightingScorer(query, "document");
        SimpleHTMLFormatter formatter = new SimpleHTMLFormatter(req.docHlStart(), req.docHlEnd());
        Highlighter highlighter = new Highlighter(formatter, scorer);
        SimpleSpanFragmenter fragmenter = new SimpleSpanFragmenter(scorer, 20);
        highlighter.setTextFragmenter(fragmenter);
        try {
            String[] fragments = highlighter.getBestFragments(analyzer, "document_" + language + "_lang", contents, 10);
            if (fragments.length == 0) {
                fragments = highlighter.getBestFragments(analyzer, "document", contents, 10);
            }
            if (fragments.length > 0) {
                return fragments;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private ExplanationData getResultsExplanation(IIndexManager indexManager, IndexSearcher indexSearcher, Query query, ScoreDoc[] scoreDocs) {
        ExplanationData ret = new ExplanationData();
        CatalogMappingIndexReader indexReader = (CatalogMappingIndexReader)indexSearcher.getIndexReader();
        for (ScoreDoc sd : scoreDocs) {
            try {
                IndexReader subReader = indexReader.readerByDocId(sd.doc);
                IIndexManager.IIndexReaderData container = indexManager.findReaderData(subReader);
                IDocIdIndex docIdIndex = container.getDocIdIndex();
                int baseDocId = indexReader.docIdBase(sd.doc);
                IDocIdIndex.LineData data = docIdIndex.findLineData(sd.doc - baseDocId);
                if (data == null) continue;
                ExplanationData.ExplanationItem item = new ExplanationData.ExplanationItem();
                item.catalog = data.catalogPath;
                item.path = data.path;
                item.lineId = data.lineId;
                item.lineSubId = data.lineSubId;
                item.varset = data.varset;
                item.score = sd.score;
                Explanation explanation = indexSearcher.explain(query, sd.doc);
                item.explanation = explanation.toString();
                ret.items.add(item);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    private int countTokensValidForSpellCheck(List<SpellToken> tokenList) {
        int count = 0;
        for (SpellToken token : tokenList) {
            if (!token.validForSpellCheck.booleanValue()) continue;
            ++count;
        }
        return count;
    }

    void spellCheckSplitLanguageList(List<String> languageList, List<String> spellCheckLanguages, List<String> luceneSearchLanguages) {
        boolean eol = false;
        for (String language : languageList) {
            if (language == null || language.isEmpty()) {
                eol = true;
                continue;
            }
            luceneSearchLanguages.add(language);
            if (eol) continue;
            spellCheckLanguages.add(language);
        }
    }

    @Override
    public String[] executeSpellCheck(SpellCheckRequest req, IIndexManager indexManager) throws Exception {
        String[] result = null;
        IndexSearcher indexSearcher = indexManager.createSpellSearcher(req.catalogList, this.executorService);
        if (indexSearcher != null) {
            try {
                ArrayList<SpellToken> spellTokens = new ArrayList<SpellToken>();
                Boolean allowSearchForTokensToRemove = this.splitSpellCheckQuery(req.word, spellTokens);
                if (!spellTokens.isEmpty()) {
                    ArrayList<String> spellCheckLanguages = new ArrayList<String>();
                    ArrayList<String> luceneSearchLanguages = new ArrayList<String>();
                    this.spellCheckSplitLanguageList(req.languageList, spellCheckLanguages, luceneSearchLanguages);
                    int numberOfReducedQueries = 0;
                    if (allowSearchForTokensToRemove.booleanValue() && spellTokens.size() <= req.maxWordsFulltext) {
                        numberOfReducedQueries = this.spellCheckFindTokensToRemove(indexManager, spellTokens, req.catalogList, luceneSearchLanguages, req.erpGroupName, req.erpPreferredLine);
                    }
                    if (numberOfReducedQueries != -1) {
                        int pos;
                        StringBuilder sb;
                        String word;
                        int i;
                        int maxSuggestions = 0;
                        if (req.maxWords <= 0 || this.countTokensValidForSpellCheck(spellTokens) <= req.maxWords) {
                            SpellChecker spellChecker = new SpellChecker((StringDistance)new LuceneLevenshteinDistance());
                            for (SpellToken stoken : spellTokens) {
                                if (!stoken.validForSpellCheck.booleanValue() || stoken.matching != null) continue;
                                String[] suggList = spellChecker.suggestSimilar(indexSearcher, stoken.token.data, spellCheckLanguages, req.maxResults, FieldDefinitions.getSpellCheckerAccuracy(), FieldDefinitions.getSpellCheckerLengthAccuracy());
                                suggList = this.filterExact(suggList, stoken.token.data);
                                stoken.similarList = suggList;
                                if (suggList.length <= maxSuggestions) continue;
                                maxSuggestions = suggList.length;
                            }
                        }
                        result = new String[maxSuggestions + numberOfReducedQueries];
                        for (i = 0; i < numberOfReducedQueries; ++i) {
                            word = req.word;
                            int bgn = 0;
                            sb = new StringBuilder();
                            for (SpellToken stoken : spellTokens) {
                                if (stoken.matching != null && stoken.matching[i] != null && stoken.matching[i].booleanValue()) continue;
                                pos = stoken.token.begin;
                                if (pos > bgn) {
                                    sb.append(word, bgn, pos);
                                }
                                bgn = stoken.token.end;
                            }
                            if (bgn < word.length()) {
                                sb.append(word, bgn, word.length());
                            }
                            result[i] = sb.toString();
                        }
                        for (i = 0; i < maxSuggestions; ++i) {
                            word = req.word;
                            int bgn = 0;
                            sb = new StringBuilder();
                            for (SpellToken stoken : spellTokens) {
                                if (stoken.similarList == null || i >= stoken.similarList.length || stoken.matching != null) continue;
                                pos = stoken.token.begin;
                                if (pos > bgn) {
                                    sb.append(word, bgn, pos);
                                }
                                sb.append(stoken.similarList[i]);
                                bgn = stoken.token.end;
                            }
                            if (bgn < word.length()) {
                                sb.append(word, bgn, word.length());
                            }
                            result[i + numberOfReducedQueries] = sb.toString();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.info("Exception in Spellchecker: " + e.getMessage());
                throw e;
            }
        }
        if (result == null) {
            result = new String[]{};
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private int spellCheckFindTokensToRemove(IIndexManager indexManager, List<SpellToken> spellTokens, List<String> catalogList, List<String> languageList, String erpGroup, Boolean preferredLine) throws IOException {
        void var11_16;
        SearchRequestImpl req = new SearchRequestImpl();
        req.pathFilters.add(new ISearchRequest.PathFilter(catalogList, null, null, null));
        FieldDefinitions.IndexType[] indexTypes = this.getSearchIndexTypes(erpGroup, preferredLine);
        ArrayList<LexerToken> tokenList = new ArrayList<LexerToken>(spellTokens.size());
        for (SpellToken spellToken : spellTokens) {
            tokenList.add(spellToken.token);
        }
        Int2IntOpenHashMap scoreMap = new Int2IntOpenHashMap();
        for (FieldDefinitions.IndexType indexType : indexTypes) {
            try (IIndexManager.IndexSearcherContainerLocked container = indexManager.createIndexSearcher(req, indexType, this.executorService);){
                PSolQuery psolQuery;
                Weight weight;
                IndexSearcher indexSearcher = container.getIndexSearcher();
                IIndexManager.IndexSearcherContainer indexSearcherContainer = container.getContainer();
                String grp = indexSearcherContainer.indexType.equals((Object)FieldDefinitions.IndexType.LinkDb) ? erpGroup : "";
                QueryParser qparser = new QueryParser(new FieldAwareAnalyzer(false));
                qparser.setSearchDocuments(false);
                Query query = qparser.parse(tokenList, languageList, grp);
                if (!(query instanceof PSolQuery) || !((weight = (psolQuery = (PSolQuery)query).createWeight(indexSearcher, ScoreMode.COMPLETE, 1.0f)) instanceof PSolWeight)) continue;
                PSolWeight pSolWeight = (PSolWeight)weight;
                List<LeafReaderContext> leaves = indexSearcherContainer.getIndexReader().leaves();
                if (leaves.size() == 1) {
                    Int2IntMap scMap = this.findMatchingTokens(leaves.get(0), pSolWeight);
                    this.mergeScoreMap(scoreMap, scMap);
                    continue;
                }
                ArrayList<FutureTask<CollectItem>> futures = new ArrayList<FutureTask<CollectItem>>(leaves.size());
                class CollectItem {
                    Int2IntMap scoreMap = null;

                    CollectItem() {
                    }
                }
                ArrayList<CollectItem> collectors = new ArrayList<CollectItem>(leaves.size());
                for (LeafReaderContext leafReaderContext : leaves) {
                    CollectItem collector = new CollectItem();
                    collectors.add(collector);
                    FutureTask<CollectItem> task = new FutureTask<CollectItem>(() -> {
                        collector.scoreMap = this.findMatchingTokens(ctx, pSolWeight);
                        return collector;
                    });
                    this.executorService.execute(task);
                    futures.add(task);
                }
                for (Future future : futures) {
                    try {
                        future.get();
                    }
                    catch (InterruptedException e) {
                        throw new ThreadInterruptedException(e);
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                for (CollectItem collectItem : collectors) {
                    this.mergeScoreMap(scoreMap, collectItem.scoreMap);
                }
            }
        }
        boolean bl = false;
        if (!scoreMap.isEmpty()) {
            record MatchItem(int numMatching, int bitField) {
            }
            ArrayList mList = new ArrayList();
            scoreMap.forEach((k, v) -> mList.add(new MatchItem(Integer.bitCount(k), (int)k)));
            mList.sort((a, b) -> {
                if (a.numMatching() == b.numMatching()) {
                    return a.bitField() - b.bitField();
                }
                if (a.numMatching() > b.numMatching()) {
                    return -1;
                }
                return 1;
            });
            int maxMatching = ((MatchItem)mList.get((int)0)).numMatching;
            if (maxMatching == spellTokens.size()) {
                int n = -1;
            } else {
                void var14_23;
                void var11_15;
                MatchItem m;
                Iterator iterator = mList.iterator();
                while (iterator.hasNext() && (m = (MatchItem)iterator.next()).numMatching() >= maxMatching) {
                    ++var11_15;
                }
                boolean bl2 = false;
                while (var14_23 < var11_15) {
                    m = (MatchItem)mList.get((int)var14_23);
                    int bit = 1;
                    for (SpellToken token : spellTokens) {
                        if ((m.bitField() & bit) == bit) {
                            if (token.matching == null) {
                                token.matching = new Boolean[var11_15];
                            }
                            token.matching[var14_23] = true;
                        }
                        bit <<= 1;
                    }
                    ++var14_23;
                }
            }
        }
        return (int)var11_16;
    }

    private Int2IntMap findMatchingTokens(LeafReaderContext ctx, PSolWeight pSolWeight) throws IOException {
        Int2IntOpenHashMap scoreMap = null;
        PostingsEnumData[] postList = pSolWeight.getCompletePostingList(ctx, true);
        int minDoc = Integer.MAX_VALUE;
        for (PostingsEnumData post : postList) {
            int doc;
            if (post == null || (doc = post.postings.nextDoc()) >= minDoc) continue;
            minDoc = doc;
        }
        if (minDoc != Integer.MAX_VALUE) {
            scoreMap = new Int2IntOpenHashMap();
            while (minDoc != Integer.MAX_VALUE) {
                int nexMinDoc = Integer.MAX_VALUE;
                int score = 0;
                int bit = 1;
                for (PostingsEnumData post : postList) {
                    if (post != null) {
                        int doc = post.postings.docID();
                        if (doc == minDoc) {
                            score |= bit;
                            doc = post.postings.nextDoc();
                        }
                        if (doc < nexMinDoc) {
                            nexMinDoc = doc;
                        }
                    }
                    bit <<= 1;
                }
                if (score > 0) {
                    scoreMap.compute(score, (BiFunction<? super Integer, ? super Integer, ? extends Integer>)((BiFunction<Integer, Integer, Integer>)(k, v) -> v == null ? 1 : v + 1));
                }
                minDoc = nexMinDoc;
            }
        }
        return scoreMap;
    }

    private void mergeScoreMap(Int2IntMap scoreMap, Int2IntMap mapToMerge) {
        if (mapToMerge != null && !mapToMerge.isEmpty()) {
            mapToMerge.int2IntEntrySet().forEach(e -> {
                int value = e.getIntValue();
                scoreMap.merge(e.getIntKey(), value, (BiFunction<? super Integer, ? super Integer, ? extends Integer>)((BiFunction<Integer, Integer, Integer>)(x, y) -> value + y));
            });
        }
    }

    private String[] filterExact(String[] stringList, String word) {
        for (String s : stringList) {
            if (!word.equalsIgnoreCase(s)) continue;
            return new String[]{word};
        }
        return stringList;
    }

    private Boolean splitSpellCheckQuery(String queryText, List<SpellToken> spellTokens) {
        boolean allowSearchForTokensToRemove = true;
        QueryLexer lexer = new QueryLexer(queryText);
        List<LexerToken> tokens = lexer.getTokens();
        for (LexerToken token : tokens) {
            if (token.type == TokenType.TT_TERM || token.type == TokenType.TT_TERM_NUMBER) {
                SpellToken spellToken = new SpellToken();
                spellToken.token = token;
                spellToken.validForSpellCheck = this.isValidForSpellCheck(token.data);
                spellTokens.add(spellToken);
                continue;
            }
            if (token.type == TokenType.TT_OPERATOR) {
                if (!spellTokens.isEmpty()) {
                    spellTokens.remove(spellTokens.size() - 1);
                }
                allowSearchForTokensToRemove = false;
                continue;
            }
            if (token.type == TokenType.TT_AND) continue;
            allowSearchForTokensToRemove = false;
        }
        return allowSearchForTokensToRemove && spellTokens.size() > 1;
    }

    private boolean isValidForSpellCheck(String word) {
        for (int i = 0; i < word.length(); ++i) {
            char ch = word.charAt(i);
            if (!Character.isLetter(ch)) continue;
            return true;
        }
        return false;
    }

    private List<LexerToken> splitRelatedWordQuery(String queryText) {
        ArrayList<LexerToken> result = new ArrayList<LexerToken>();
        QueryLexer lexer = new QueryLexer(queryText);
        List<LexerToken> tokens = lexer.getTokens();
        for (LexerToken token : tokens) {
            if (token.type != TokenType.TT_TERM && token.type != TokenType.TT_EXACT && token.type != TokenType.TT_QUOTED || !this.isValidForSpellCheck(token.data)) continue;
            result.add(token);
        }
        return result;
    }

    @Override
    public List<RelatedWord> executeRelatedWordSearch(RelatedWordsRequest req, IIndexManager indexManager) throws Exception {
        List<RelatedWord> result = null;
        IndexSearcher indexSearcher = indexManager.createRelatedWordsSearcher(req.catalogList, this.executorService);
        if (indexSearcher != null) {
            try {
                RelatedWords relatedWordSearcher = new RelatedWords();
                List<LexerToken> tokenList = this.splitRelatedWordQuery(req.query);
                ArrayList<String> searchWords = new ArrayList<String>();
                tokenList.forEach(t -> searchWords.add(t.data));
                result = relatedWordSearcher.findRelatedWords(indexSearcher, searchWords, req.languageList, req.maxResults);
            }
            catch (Exception e) {
                logger.info("Exception in related words: " + e.getMessage());
                throw e;
            }
        }
        return result;
    }

    private static class SearchState {
        FieldDefinitions.IndexType indexType;
        PSolTopScoreDocCollector collector;
        Query query;
        int lineOffset = 0;
        Int2ObjectMap<IntList> referencedDocs;
        IFacetListBuilder facetListBuilder = null;
        Set<String> countedProjects = null;

        private SearchState() {
        }
    }

    private static class ResultCollector {
        PSolTopScoreDocCollector docCollector = null;
        long[] scoreDocs = null;
        int totalHits = 0;
        DocumentResolveCollector docResolver = null;

        public ResultCollector(Object[] result) {
            for (Object res : result) {
                if (res instanceof PSolTopScoreDocCollector) {
                    PSolTopScoreDocCollector docCollectorResult = (PSolTopScoreDocCollector)res;
                    this.scoreDocs = docCollectorResult.getTopDocs();
                    this.totalHits = docCollectorResult.getTotalHits();
                    this.docCollector = docCollectorResult;
                    continue;
                }
                if (!(res instanceof DocumentResolveCollector)) continue;
                this.docResolver = (DocumentResolveCollector)res;
            }
        }
    }

    private static class SpellToken {
        LexerToken token = null;
        String[] similarList = null;
        Boolean validForSpellCheck = false;
        Boolean[] matching = null;

        private SpellToken() {
        }
    }
}

