/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.analysis.filter;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.AttributeSource;

public class ClassidFilter
extends TokenFilter {
    private final CharTermAttribute termAttr = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAttr = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncAtt = this.addAttribute(PositionIncrementAttribute.class);
    private AttributeSource.State state = null;
    private int[] bufferedParts = new int[12];
    private int bufferedLen = 0;
    private int bufferedPos = 0;
    private static final char[] eClassPrefix = new char[]{'e', 'c', 'l', 'a', 's', 's'};
    private final boolean isIndexer;

    public ClassidFilter(TokenStream input, boolean isIndexer) {
        super(input);
        this.isIndexer = isIndexer;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.state == null) {
            if (!this.input.incrementToken()) {
                return false;
            }
            this.splitClassId(this.termAttr.buffer(), this.termAttr.length());
            if (this.bufferedLen == 0) {
                return true;
            }
            if (this.bufferedLen > 1) {
                this.state = this.captureState();
            }
        }
        if (this.bufferedPos < this.bufferedLen) {
            int startOffset = this.bufferedParts[4 * this.bufferedPos];
            int endOffset = this.bufferedParts[4 * this.bufferedPos + 1];
            int increment = this.bufferedParts[4 * this.bufferedPos + 2];
            int isClassName = this.bufferedParts[4 * this.bufferedPos + 3];
            if (this.bufferedPos > 0) {
                this.restoreState(this.state);
            }
            if (isClassName == 1) {
                int tlength = endOffset - startOffset;
                this.termAttr.resizeBuffer(tlength + 2);
                System.arraycopy(this.termAttr.buffer(), startOffset, this.termAttr.buffer(), 1, tlength);
                this.termAttr.buffer()[0] = 36;
                this.termAttr.buffer()[tlength + 1] = 36;
                this.termAttr.setLength(tlength + 2);
            } else {
                this.termAttr.copyBuffer(this.termAttr.buffer(), startOffset, endOffset - startOffset);
            }
            this.offsetAttr.setOffset(this.offsetAttr.startOffset() + startOffset, this.offsetAttr.endOffset() + startOffset);
            this.posIncAtt.setPositionIncrement(increment);
            ++this.bufferedPos;
            if (this.bufferedPos == this.bufferedLen) {
                this.state = null;
                this.bufferedLen = 0;
                this.bufferedPos = 0;
            }
            return true;
        }
        return false;
    }

    private void splitClassId(char[] text, int textlen) {
        int start = 0;
        for (int i = 0; i < textlen; ++i) {
            char ch = text[i];
            if (ch != ':') continue;
            if (i > start) {
                this.saveOffset(start, i, 1, 1);
                if (this.isIndexer && start == 0 && this.iseClass(text, textlen)) {
                    this.saveOffset(0, 6, 0, 1);
                }
            }
            start = i + 1;
        }
        if (start != 0 && start < textlen) {
            this.saveOffset(start, textlen, 1, 0);
        }
    }

    boolean iseClass(char[] text, int textlen) {
        if (textlen > eClassPrefix.length) {
            return Arrays.equals(text, 0, eClassPrefix.length, eClassPrefix, 0, eClassPrefix.length);
        }
        return false;
    }

    private void saveOffset(int startOffset, int endOffset, int increment, int isClassName) {
        if ((this.bufferedLen + 1) * 4 > this.bufferedParts.length) {
            this.bufferedParts = ArrayUtil.grow(this.bufferedParts, (this.bufferedLen + 1) * 4);
        }
        this.bufferedParts[this.bufferedLen * 4] = startOffset;
        this.bufferedParts[this.bufferedLen * 4 + 1] = endOffset;
        this.bufferedParts[this.bufferedLen * 4 + 2] = increment;
        this.bufferedParts[this.bufferedLen * 4 + 3] = isClassName;
        ++this.bufferedLen;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.bufferedLen = 0;
        this.bufferedPos = 0;
        this.state = null;
    }

    private static enum CharType {
        none,
        textual,
        numeric;

    }
}

