/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.analysis.filter;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;

public final class EnglishPossessiveFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public EnglishPossessiveFilter(TokenStream input) {
        super(input);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        if (this.keywordAttr.isKeyword()) {
            return true;
        }
        char[] buffer = this.termAtt.buffer();
        int bufferLength = this.termAtt.length();
        if (!(bufferLength < 2 || buffer[bufferLength - 2] != '\'' && buffer[bufferLength - 2] != '\u2019' && buffer[bufferLength - 2] != '\uff07' || buffer[bufferLength - 1] != 's' && buffer[bufferLength - 1] != 'S')) {
            this.termAtt.setLength(bufferLength - 2);
        }
        return true;
    }
}

