/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.analysis.filter;

import de.cadenas.catalogsearch.lucene.analysis.helper.TokenFlags;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.util.BytesRef;

public class RemoveDuplicateTokenFilter
extends TokenFilter {
    private final CharTermAttribute termAttr = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAttr = this.addAttribute(OffsetAttribute.class);
    private final FlagsAttribute flagsAttr = this.addAttribute(FlagsAttribute.class);
    private final PayloadAttribute payloadAttr = this.addAttribute(PayloadAttribute.class);
    private boolean lastWasExact = false;
    private int offset = -1;
    private char[] buffer = null;
    private static final byte[] payloadBytes = new byte[]{0, 2, 4, 8, 1, 16, 17};
    private static final BytesRef[] payLoad = new BytesRef[payloadBytes.length];

    public RemoveDuplicateTokenFilter(TokenStream in) {
        super(in);
    }

    @Override
    public boolean incrementToken() throws IOException {
        while (this.input.incrementToken()) {
            if (TokenFlags.isSet(TokenFlags.Flag.ExactToken, this.flagsAttr) && !TokenFlags.isSet(TokenFlags.Flag.SynonymToken, this.flagsAttr)) {
                this.lastWasExact = true;
                this.offset = this.offsetAttr.startOffset();
                this.buffer = Arrays.copyOf(this.termAttr.buffer(), this.termAttr.length());
            } else if (TokenFlags.isSet(TokenFlags.Flag.DupToken, this.flagsAttr)) {
                if (this.lastWasExact && this.offset == this.offsetAttr.startOffset() && RemoveDuplicateTokenFilter.equalsBuffer(this.buffer, this.termAttr.buffer(), this.termAttr.length())) {
                    continue;
                }
            } else {
                this.lastWasExact = false;
            }
            int payPos = 0;
            if (TokenFlags.isSet(TokenFlags.Flag.ModToken, this.flagsAttr)) {
                payPos = TokenFlags.isSet(TokenFlags.Flag.LowPrioToken, this.flagsAttr) ? 6 : 4;
            } else if (TokenFlags.isSet(TokenFlags.Flag.LowPrioToken, this.flagsAttr)) {
                payPos = 5;
            } else if (!TokenFlags.isSet(TokenFlags.Flag.CompoundPart, this.flagsAttr)) {
                if (TokenFlags.isSet(TokenFlags.Flag.WordBgn, this.flagsAttr)) {
                    payPos = 1;
                } else if (TokenFlags.isSet(TokenFlags.Flag.WordMid, this.flagsAttr)) {
                    payPos = 2;
                } else if (TokenFlags.isSet(TokenFlags.Flag.WordEnd, this.flagsAttr)) {
                    payPos = 3;
                }
            }
            if (payPos > 0) {
                this.payloadAttr.setPayload(payLoad[payPos]);
            }
            return true;
        }
        return false;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.lastWasExact = false;
    }

    private static boolean equalsBuffer(char[] a, char[] b, int lenB) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length != lenB) {
            return false;
        }
        for (int i = 0; i < lenB; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    static {
        for (int i = 0; i < payloadBytes.length; ++i) {
            RemoveDuplicateTokenFilter.payLoad[i] = new BytesRef(payloadBytes, i, 1);
        }
    }
}

