/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.analysis.filter;

import de.cadenas.catalogsearch.lucene.analysis.helper.TokenFlags;
import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.AttributeSource;

public class SplitLetterNumberFilter
extends TokenFilter {
    private final CharTermAttribute termAttr = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAttr = this.addAttribute(OffsetAttribute.class);
    private final FlagsAttribute flagsAttr = this.addAttribute(FlagsAttribute.class);
    private AttributeSource.State state = null;
    private int[] bufferedParts = new int[16];
    private int bufferedLen = 0;
    private int bufferedPos = 0;

    public SplitLetterNumberFilter(TokenStream input) {
        super(input);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.state == null) {
            if (!this.input.incrementToken()) {
                return false;
            }
            this.splitLetterNumber(this.termAttr.buffer(), this.termAttr.length());
            if (this.bufferedLen == 0) {
                return true;
            }
            if (this.bufferedLen > 1) {
                this.state = this.captureState();
            }
        }
        if (this.bufferedPos < this.bufferedLen) {
            int startOffset = this.bufferedParts[2 * this.bufferedPos];
            int endOffset = this.bufferedParts[2 * this.bufferedPos + 1];
            if (this.bufferedPos > 0) {
                this.restoreState(this.state);
            }
            this.termAttr.copyBuffer(this.termAttr.buffer(), startOffset, endOffset - startOffset);
            this.offsetAttr.setOffset(this.offsetAttr.startOffset() + startOffset, this.offsetAttr.startOffset() + endOffset);
            if (TokenFlags.isSet(TokenFlags.Flag.WordBgn, this.flagsAttr)) {
                if (this.bufferedPos > 0) {
                    TokenFlags.setFlag(TokenFlags.Flag.WordMid, this.flagsAttr);
                }
            } else if (TokenFlags.isSet(TokenFlags.Flag.WordEnd, this.flagsAttr)) {
                if (this.bufferedPos + 1 != this.bufferedLen) {
                    TokenFlags.setFlag(TokenFlags.Flag.WordMid, this.flagsAttr);
                }
            } else if (!TokenFlags.isSet(TokenFlags.Flag.WordMid, this.flagsAttr) && this.bufferedLen > 1) {
                if (this.bufferedPos == 0) {
                    TokenFlags.setFlag(TokenFlags.Flag.WordBgn, this.flagsAttr);
                } else if (this.bufferedPos + 1 == this.bufferedLen) {
                    TokenFlags.setFlag(TokenFlags.Flag.WordEnd, this.flagsAttr);
                } else {
                    TokenFlags.setFlag(TokenFlags.Flag.WordMid, this.flagsAttr);
                }
            }
            ++this.bufferedPos;
            if (this.bufferedPos == this.bufferedLen) {
                this.state = null;
                this.bufferedLen = 0;
                this.bufferedPos = 0;
            }
            return true;
        }
        return false;
    }

    private void splitLetterNumber(char[] text, int textlen) {
        CharType lastType = CharType.none;
        int start = 0;
        for (int i = 0; i < textlen; ++i) {
            char ch = text[i];
            CharType type = Character.isDigit(ch) ? CharType.numeric : (ch == '.' ? CharType.numeric : CharType.textual);
            if (lastType != CharType.none && type != lastType) {
                this.saveOffset(start, i);
                start = i;
            }
            lastType = type;
        }
        if (start != 0 && start < textlen) {
            this.saveOffset(start, textlen);
        }
    }

    private void saveOffset(int startOffset, int endOffset) {
        if ((this.bufferedLen + 1) * 2 > this.bufferedParts.length) {
            this.bufferedParts = ArrayUtil.grow(this.bufferedParts, (this.bufferedLen + 1) * 2);
        }
        this.bufferedParts[this.bufferedLen * 2] = startOffset;
        this.bufferedParts[this.bufferedLen * 2 + 1] = endOffset;
        ++this.bufferedLen;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.bufferedLen = 0;
        this.bufferedPos = 0;
        this.state = null;
    }

    private static enum CharType {
        none,
        textual,
        numeric;

    }
}

