/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.analysis.filter;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public class TypeToKeywordFilter
extends TokenFilter {
    private static final String HAN_TYPE = StandardTokenizer.TOKEN_TYPES[3];
    private static final String HIRAGANA_TYPE = StandardTokenizer.TOKEN_TYPES[4];
    private static final String KATAKANA_TYPE = StandardTokenizer.TOKEN_TYPES[5];
    private static final String HANGUL_TYPE = StandardTokenizer.TOKEN_TYPES[6];
    private static final String[] cjkTypeList = new String[]{HAN_TYPE, HIRAGANA_TYPE, KATAKANA_TYPE, HANGUL_TYPE};
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public TypeToKeywordFilter(TokenStream input) {
        super(input);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String type = this.typeAtt.type();
            if (TypeToKeywordFilter.isInList(type, cjkTypeList)) {
                this.keywordAttr.setKeyword(true);
            }
            return true;
        }
        return false;
    }

    private static boolean isInList(String str, String[] searchStrs) {
        if (str != null) {
            for (String sstr : searchStrs) {
                if (!str.equals(sstr)) continue;
                return true;
            }
        }
        return false;
    }
}

