/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.analysis.filter;

import de.cadenas.catalogsearch.lucene.analysis.helper.TokenFlags;
import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.AttributeSource;

public class TypecodeFilter
extends TokenFilter {
    private final PositionIncrementAttribute posIncAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final CharTermAttribute termAttr = this.addAttribute(CharTermAttribute.class);
    private final FlagsAttribute flagsAttr = this.addAttribute(FlagsAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);
    private AttributeSource.State state = null;
    private char[] charbuffer = null;
    private int bufferLength = 0;

    public TypecodeFilter(TokenStream input) {
        super(input);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.state != null) {
            this.restoreState(this.state);
            this.state = null;
            System.arraycopy(this.charbuffer, 0, this.termAttr.buffer(), 0, this.bufferLength);
            this.termAttr.setLength(this.bufferLength);
            this.posIncAtt.setPositionIncrement(0);
            TokenFlags.setFlag(TokenFlags.Flag.ModToken, this.flagsAttr);
            return true;
        }
        if (this.input.incrementToken()) {
            this.unifyOrdernumber(this.termAttr.buffer(), this.termAttr.length());
            TokenFlags.setFlag(TokenFlags.Flag.ExactToken, this.flagsAttr);
            this.keywordAttr.setKeyword(true);
            return true;
        }
        return false;
    }

    private void unifyOrdernumber(char[] text, int textLength) {
        boolean lastWasBlank = true;
        int pos = 0;
        for (int i = 0; i < textLength; ++i) {
            char ch = text[i];
            boolean keep = false;
            if (Character.isSurrogate(ch)) {
                keep = true;
            } else if (Character.isLetterOrDigit(ch)) {
                keep = true;
            } else {
                int codePoint = Character.toCodePoint(ch, '\u0000');
                if (Character.isAlphabetic(codePoint)) {
                    keep = true;
                }
            }
            if (keep) {
                if (i != pos) {
                    this.charbuffer[pos] = ch;
                }
                ++pos;
                continue;
            }
            if (i != pos) continue;
            this.state = this.captureState();
            if (this.charbuffer == null || this.charbuffer.length < textLength) {
                this.charbuffer = new char[textLength];
            }
            if (i <= 0) continue;
            System.arraycopy(text, 0, this.charbuffer, 0, i);
        }
        if (pos != textLength) {
            this.bufferLength = pos;
        }
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.state = null;
        this.bufferLength = 0;
    }
}

