/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.analysis.filter;

import de.cadenas.catalogsearch.lucene.analysis.filter.WordDelimiterIterator;
import de.cadenas.catalogsearch.lucene.analysis.helper.TokenFlags;
import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.RamUsageEstimator;

public final class WordDelimiterGraphFilter
extends TokenFilter {
    private int[] bufferedParts = new int[16];
    private int bufferedLen;
    private int bufferedPos;
    private char[][] bufferedTermParts = new char[4][];
    private final CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttribute = this.addAttribute(KeywordAttribute.class);
    private final OffsetAttribute offsetAttribute = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncAttribute = this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLenAttribute = this.addAttribute(PositionLengthAttribute.class);
    private final FlagsAttribute flagsAttr = this.addAttribute(FlagsAttribute.class);
    private final WordDelimiterIterator iterator;
    private int accumPosInc;
    private char[] savedTermBuffer = new char[16];
    private int savedTermLength;
    private int savedStartOffset;
    private int savedEndOffset;
    private AttributeSource.State savedState;
    private int lastStartOffset;
    private boolean adjustingOffsets;
    private int wordPos;

    public WordDelimiterGraphFilter(TokenStream in, boolean keepEnglishPossesive, boolean keepWildcards) {
        super(in);
        this.iterator = new WordDelimiterIterator(keepEnglishPossesive, keepWildcards);
    }

    private void bufferWordParts() throws IOException {
        this.saveState();
        this.adjustingOffsets = this.savedEndOffset - this.savedStartOffset == this.savedTermLength;
        this.bufferedLen = 0;
        this.wordPos = 0;
        if (this.iterator.isSingleWord()) {
            this.buffer(this.wordPos, this.wordPos + 1, this.iterator.current, this.iterator.end);
            ++this.wordPos;
            this.iterator.next();
        } else {
            while (this.iterator.end != -1) {
                int wordType = this.iterator.type();
                if (this.shouldGenerateParts(wordType)) {
                    this.buffer(this.wordPos, this.wordPos + 1, this.iterator.current, this.iterator.end);
                    ++this.wordPos;
                }
                this.iterator.next();
            }
        }
        this.wordPos = 0;
        this.bufferedPos = 0;
    }

    @Override
    public boolean incrementToken() throws IOException {
        while (true) {
            if (this.savedState == null) {
                if (!this.input.incrementToken()) {
                    return false;
                }
                if (this.keywordAttribute.isKeyword()) {
                    return true;
                }
                int termLength = this.termAttribute.length();
                char[] termBuffer = this.termAttribute.buffer();
                this.iterator.setText(termBuffer, termLength);
                this.iterator.next();
                if (this.iterator.end == -1) continue;
                this.accumPosInc += this.posIncAttribute.getPositionIncrement();
                if (this.iterator.current == 0 && this.iterator.end == termLength) {
                    this.posIncAttribute.setPositionIncrement(this.accumPosInc);
                    this.accumPosInc = 0;
                    return true;
                }
                this.bufferWordParts();
            }
            if (this.bufferedPos < this.bufferedLen) {
                int endOffset;
                int startOffset;
                this.clearAttributes();
                this.restoreState(this.savedState);
                char[] termPart = this.bufferedTermParts[this.bufferedPos];
                int startPos = this.bufferedParts[4 * this.bufferedPos];
                int endPos = this.bufferedParts[4 * this.bufferedPos + 1];
                int startPart = this.bufferedParts[4 * this.bufferedPos + 2];
                int endPart = this.bufferedParts[4 * this.bufferedPos + 3];
                ++this.bufferedPos;
                if (!this.adjustingOffsets) {
                    startOffset = this.savedStartOffset;
                    endOffset = this.savedEndOffset;
                } else {
                    startOffset = this.savedStartOffset + startPart;
                    endOffset = this.savedStartOffset + endPart;
                }
                startOffset = Math.max(startOffset, this.lastStartOffset);
                endOffset = Math.max(endOffset, this.lastStartOffset);
                this.offsetAttribute.setOffset(startOffset, endOffset);
                this.lastStartOffset = startOffset;
                if (termPart == null) {
                    this.termAttribute.copyBuffer(this.savedTermBuffer, startPart, endPart - startPart);
                } else {
                    this.termAttribute.copyBuffer(termPart, 0, termPart.length);
                }
                this.posIncAttribute.setPositionIncrement(this.accumPosInc + startPos - this.wordPos);
                this.accumPosInc = 0;
                this.posLenAttribute.setPositionLength(endPos - startPos);
                this.wordPos = startPos;
                if (this.bufferedLen > 1) {
                    if (this.bufferedPos == 1) {
                        TokenFlags.setFlag(TokenFlags.Flag.WordBgn, this.flagsAttr);
                    } else if (this.bufferedPos == this.bufferedLen) {
                        TokenFlags.setFlag(TokenFlags.Flag.WordEnd, this.flagsAttr);
                    } else {
                        TokenFlags.setFlag(TokenFlags.Flag.WordMid, this.flagsAttr);
                    }
                }
                return true;
            }
            this.savedState = null;
        }
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.accumPosInc = 0;
        this.savedState = null;
        this.lastStartOffset = 0;
    }

    void buffer(int startPos, int endPos, int startPart, int endPart) {
        this.buffer(null, startPos, endPos, startPart, endPart);
    }

    void buffer(char[] termPart, int startPos, int endPos, int startPart, int endPart) {
        assert (endPos > startPos) : "startPos=" + startPos + " endPos=" + endPos;
        assert (endPart > startPart || endPart == 0 && startPart == 0 && this.savedTermLength == 0) : "startPart=" + startPart + " endPart=" + endPart;
        if ((this.bufferedLen + 1) * 4 > this.bufferedParts.length) {
            this.bufferedParts = ArrayUtil.grow(this.bufferedParts, (this.bufferedLen + 1) * 4);
        }
        if (this.bufferedTermParts.length == this.bufferedLen) {
            int newSize = ArrayUtil.oversize(this.bufferedLen + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
            char[][] newArray = new char[newSize][];
            System.arraycopy(this.bufferedTermParts, 0, newArray, 0, this.bufferedTermParts.length);
            this.bufferedTermParts = newArray;
        }
        this.bufferedTermParts[this.bufferedLen] = termPart;
        this.bufferedParts[this.bufferedLen * 4] = startPos;
        this.bufferedParts[this.bufferedLen * 4 + 1] = endPos;
        this.bufferedParts[this.bufferedLen * 4 + 2] = startPart;
        this.bufferedParts[this.bufferedLen * 4 + 3] = endPart;
        ++this.bufferedLen;
    }

    private void saveState() {
        this.savedTermLength = this.termAttribute.length();
        this.savedStartOffset = this.offsetAttribute.startOffset();
        this.savedEndOffset = this.offsetAttribute.endOffset();
        this.savedState = this.captureState();
        if (this.savedTermBuffer.length < this.savedTermLength) {
            this.savedTermBuffer = new char[ArrayUtil.oversize(this.savedTermLength, 2)];
        }
        System.arraycopy(this.termAttribute.buffer(), 0, this.savedTermBuffer, 0, this.savedTermLength);
    }

    private boolean shouldGenerateParts(int wordType) {
        return WordDelimiterIterator.isAlpha(wordType) || WordDelimiterIterator.isDigit(wordType) || WordDelimiterIterator.isWildcard(wordType);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WordDelimiterGraphFilter");
        return b.toString();
    }
}

