/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.analysis.filter.icu;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.lucene.analysis.icu.segmentation.ICUTokenizerConfig;

public class CompositeBreakIterator {
    private Object breaker;
    private Class<?> c;

    CompositeBreakIterator(ICUTokenizerConfig config) {
        try {
            this.c = Class.forName("org.apache.lucene.analysis.icu.segmentation.CompositeBreakIterator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.breaker = this.createBreakIterator(config);
    }

    private Object createBreakIterator(ICUTokenizerConfig config) {
        Object result = null;
        try {
            Class[] cArg = new Class[]{ICUTokenizerConfig.class};
            Constructor<?> constructor = this.c.getDeclaredConstructor(cArg);
            constructor.setAccessible(true);
            result = constructor.newInstance(config);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return result;
    }

    private int invokeNoParamIntResult(String methodName) {
        int ret = 0;
        try {
            Method method = this.c.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            Number retObject = (Number)method.invoke(this.breaker, new Object[0]);
            ret = retObject.intValue();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
            // empty catch block
        }
        return ret;
    }

    int next() {
        return this.invokeNoParamIntResult("next");
    }

    int current() {
        return this.invokeNoParamIntResult("current");
    }

    int getRuleStatus() {
        return this.invokeNoParamIntResult("getRuleStatus");
    }

    int getScriptCode() {
        return this.invokeNoParamIntResult("getScriptCode");
    }

    void setText(char[] text, int start, int length) {
        try {
            Class[] paramList = new Class[]{char[].class, Integer.TYPE, Integer.TYPE};
            Method method = this.c.getDeclaredMethod("setText", paramList);
            method.setAccessible(true);
            Object[] objList = new Object[]{text, start, length};
            method.invoke(this.breaker, objList);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
            // empty catch block
        }
    }
}

