/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.analysis.filter.icu;

import com.ibm.icu.lang.UCharacter;
import de.cadenas.catalogsearch.lucene.analysis.filter.icu.CompositeBreakIterator;
import de.cadenas.catalogsearch.lucene.analysis.helper.TokenFlags;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.icu.segmentation.DefaultICUTokenizerConfig;
import org.apache.lucene.analysis.icu.segmentation.ICUTokenizerConfig;
import org.apache.lucene.analysis.icu.tokenattributes.ScriptAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeFactory;

public final class ICUTokenizer
extends Tokenizer {
    private static final int IOBUFFER = 4096;
    private final char[] buffer = new char[4096];
    private int length = 0;
    private int usableLength = 0;
    private int offset = 0;
    private final boolean inWildcardQuery;
    private final CompositeBreakIterator breaker;
    private final ICUTokenizerConfig config;
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);
    private final ScriptAttribute scriptAtt = this.addAttribute(ScriptAttribute.class);
    private final FlagsAttribute flagsAttr = this.addAttribute(FlagsAttribute.class);

    public ICUTokenizer(boolean inWildcardQuery) {
        this(new DefaultICUTokenizerConfig(true, true), inWildcardQuery);
    }

    public ICUTokenizer(ICUTokenizerConfig config, boolean inWildcardQuery) {
        this(DEFAULT_TOKEN_ATTRIBUTE_FACTORY, config, inWildcardQuery);
    }

    public ICUTokenizer(AttributeFactory factory, ICUTokenizerConfig config, boolean inWildcardQuery) {
        super(factory);
        this.config = config;
        this.inWildcardQuery = inWildcardQuery;
        this.breaker = new CompositeBreakIterator(config);
    }

    @Override
    public boolean incrementToken() throws IOException {
        this.clearAttributes();
        if (this.length == 0) {
            this.refill();
        }
        while (!this.incrementTokenBuffer()) {
            this.refill();
            if (this.length > 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.breaker.setText(this.buffer, 0, 0);
        this.offset = 0;
        this.usableLength = 0;
        this.length = 0;
    }

    @Override
    public void end() throws IOException {
        super.end();
        int finalOffset = this.length < 0 ? this.offset : this.offset + this.length;
        this.offsetAtt.setOffset(this.correctOffset(finalOffset), this.correctOffset(finalOffset));
    }

    private int findSafeEnd() {
        for (int i = this.length - 1; i >= 0; --i) {
            if (!UCharacter.isWhitespace((int)this.buffer[i])) continue;
            return i + 1;
        }
        return -1;
    }

    private void refill() throws IOException {
        this.offset += this.usableLength;
        int leftover = this.length - this.usableLength;
        System.arraycopy(this.buffer, this.usableLength, this.buffer, 0, leftover);
        int requested = this.buffer.length - leftover;
        int returned = ICUTokenizer.read(this.input, this.buffer, leftover, requested);
        this.length = returned + leftover;
        if (returned < requested) {
            this.usableLength = this.length;
        } else {
            this.usableLength = this.findSafeEnd();
            if (this.usableLength < 0) {
                this.usableLength = this.length;
            }
        }
        this.breaker.setText(this.buffer, 0, Math.max(0, this.usableLength));
    }

    private static int read(Reader input, char[] buffer, int offset, int length) throws IOException {
        int location;
        int remaining;
        int count;
        assert (length >= 0) : "length must not be negative: " + length;
        for (remaining = length; remaining > 0 && -1 != (count = input.read(buffer, offset + (location = length - remaining), remaining)); remaining -= count) {
        }
        return length - remaining;
    }

    private boolean incrementTokenBuffer() {
        boolean isEnd;
        int start = this.breaker.current();
        assert (start != -1);
        int end = this.breaker.next();
        while (end != -1 && this.breaker.getRuleStatus() == 0) {
            if (this.inWildcardQuery && this.isWildcard(start, end)) {
                TokenFlags.setFlag(TokenFlags.Flag.WildcardChar, this.flagsAttr);
                break;
            }
            start = end;
            end = this.breaker.next();
        }
        if (end == -1) {
            return false;
        }
        boolean isStart = start == 0 || start <= this.usableLength && Character.isWhitespace(this.buffer[start - 1]);
        boolean bl = isEnd = end == this.usableLength || end + 1 < this.usableLength && Character.isWhitespace(this.buffer[end + 1]);
        if (!isStart || !isEnd) {
            if (isStart) {
                TokenFlags.setFlag(TokenFlags.Flag.WordBgn, this.flagsAttr);
            } else if (isEnd) {
                TokenFlags.setFlag(TokenFlags.Flag.WordEnd, this.flagsAttr);
            } else {
                TokenFlags.setFlag(TokenFlags.Flag.WordMid, this.flagsAttr);
            }
        }
        this.termAtt.copyBuffer(this.buffer, start, end - start);
        this.offsetAtt.setOffset(this.correctOffset(this.offset + start), this.correctOffset(this.offset + end));
        this.typeAtt.setType(this.config.getType(this.breaker.getScriptCode(), this.breaker.getRuleStatus()));
        this.scriptAtt.setCode(this.breaker.getScriptCode());
        return true;
    }

    private boolean isWildcard(int start, int end) {
        for (int i = start; i < end; ++i) {
            if (this.buffer[i] != '?' && this.buffer[i] != '*') continue;
            return true;
        }
        return false;
    }
}

