/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.facet;

import de.cadenas.catalogsearch.api.IIndexManager;
import de.cadenas.catalogsearch.api.ServiceFactory;
import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.facet.IFacetListBuilder;
import de.cadenas.catalogsearch.lucene.search.FacetCountingFilter;
import de.cadenas.util.Containers;
import de.cadenas.util.PDataStream;
import de.cadenas.util.PFacetEvaluator;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.util.BytesRef;

public class MinMaxFacetCounts {
    private final Map<String, IFacetListBuilder.Result.NumericSideway> sideways;
    private final FacetCountingFilter facetFilter;

    private void evaluateMinMax(DocIdSetIterator docs, BinaryDocValues[] binaryValues, MinMaxValue[] minMaxVals, int end) throws IOException {
        int doc = docs.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            for (int m = 0; m < end; ++m) {
                BinaryDocValues bv = binaryValues[m];
                if (!bv.advanceExact(doc)) continue;
                BytesRef data = binaryValues[m].binaryValue();
                PDataStream stream = new PDataStream(data);
                stream.readInt();
                double minValue = stream.readDouble();
                double maxValue = stream.readDouble();
                MinMaxValue minMax = minMaxVals[m];
                if (minValue < minMax.minValue) {
                    minMax.minValue = minValue;
                }
                if (maxValue < minMax.minValue) {
                    minMax.minValue = maxValue;
                }
                if (minValue > minMax.maxValue) {
                    minMax.maxValue = minValue;
                }
                if (!(maxValue > minMax.maxValue)) continue;
                minMax.maxValue = maxValue;
            }
            doc = docs.nextDoc();
        }
    }

    private void awaitAndMergeResults(MinMaxValue[] minMaxValues, List<Future<MinMaxValue[]>> results) {
        boolean first = true;
        for (Future<MinMaxValue[]> result : results) {
            try {
                MinMaxValue[] ret = result.get();
                if (ret != null && ret.length == minMaxValues.length) {
                    for (int f = 0; f < minMaxValues.length; ++f) {
                        if (first) {
                            minMaxValues[f] = ret[f];
                            continue;
                        }
                        minMaxValues[f].minValue = Math.min(minMaxValues[f].minValue, ret[f].minValue);
                        minMaxValues[f].maxValue = Math.max(minMaxValues[f].maxValue, ret[f].maxValue);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            first = false;
        }
    }

    public MinMaxFacetCounts(Map<String, IFacetListBuilder.Result.NumericSideway> sideways, FacetCountingFilter facetFilter) {
        this.sideways = sideways;
        this.facetFilter = facetFilter;
    }

    public MinMaxValue[] getMinMaxValuesConcurrent(List<String> fieldNames, List<FacetsCollector.MatchingDocs> matchingDocs) {
        DoubleValuesSource[] sourceList = new DoubleValuesSource[fieldNames.size()];
        MinMaxValue[] minMaxValues = new MinMaxValue[fieldNames.size()];
        String[] namesArray = fieldNames.toArray(new String[0]);
        for (int s = 0; s < fieldNames.size(); ++s) {
            String fieldName = fieldNames.get(s);
            minMaxValues[s] = new MinMaxValue(fieldName);
        }
        ArrayList<FacetsCollector.MatchingDocs> matchingDocList = new ArrayList<FacetsCollector.MatchingDocs>();
        for (FacetsCollector.MatchingDocs mhits : matchingDocs) {
            if (mhits.totalHits == 0) continue;
            matchingDocList.add(mhits);
        }
        if (!matchingDocList.isEmpty()) {
            MinMaxCollector collector = new MinMaxCollector(matchingDocList, sourceList, namesArray, this.sideways, this.facetFilter);
            try {
                minMaxValues = collector.call();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return minMaxValues;
    }

    public static class MinMaxValue {
        boolean valid = false;
        public String fieldName;
        public int matchCount = 0;
        public boolean useValueList = false;
        public boolean useMinMax = false;
        public double minValue = 2.147483647E9;
        public double maxValue = -2.147483648E9;
        public DoubleArrayList valueList = new DoubleArrayList();
        public IntArrayList matchCountList = new IntArrayList();

        private MinMaxValue(String fieldName) {
            this.fieldName = fieldName;
        }

        private MinMaxValue(String fieldName, boolean useMinMax) {
            this.fieldName = fieldName;
            this.useMinMax = useMinMax;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.fieldName);
            sb.append(":");
            sb.append(this.useValueList);
            sb.append(": ");
            if (this.useValueList) {
                boolean first = true;
                DoubleListIterator doubleListIterator = this.valueList.iterator();
                while (doubleListIterator.hasNext()) {
                    double d = (Double)doubleListIterator.next();
                    if (!first) {
                        sb.append(",");
                    }
                    first = false;
                    sb.append(d);
                }
            } else {
                sb.append(this.minValue);
                sb.append(" - ");
                sb.append(this.maxValue);
                sb.append(this.valueList.size());
            }
            return sb.toString();
        }
    }

    private static class MinMaxCollector
    implements Callable<MinMaxValue[]> {
        List<FacetsCollector.MatchingDocs> matchingDocs;
        DoubleValuesSource[] sourceList;
        String[] fieldNames;
        MinMaxValue[] minMaxValues;
        Map<String, MinMaxValue> sidewaysMinMax = new HashMap<String, MinMaxValue>();
        Map<String, IFacetListBuilder.Result.NumericSideway> sideways;
        FacetCountingFilter facetFilter;

        public MinMaxCollector(List<FacetsCollector.MatchingDocs> matchingDocs, DoubleValuesSource[] sourceList, String[] fieldNames, Map<String, IFacetListBuilder.Result.NumericSideway> sideways, FacetCountingFilter facetFilter) {
            this.matchingDocs = matchingDocs;
            this.sourceList = sourceList;
            this.fieldNames = fieldNames;
            this.sideways = sideways;
            this.facetFilter = facetFilter;
            this.minMaxValues = new MinMaxValue[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                this.minMaxValues[i] = new MinMaxValue(fieldNames[i]);
            }
        }

        @Override
        public MinMaxValue[] call() throws IOException {
            IIndexManager indexManager = ServiceFactory.getIndexManager();
            this.processMatchingDocs(indexManager, this.matchingDocs, null, false);
            if (this.sideways != null) {
                for (Map.Entry<String, IFacetListBuilder.Result.NumericSideway> item : this.sideways.entrySet()) {
                    MinMaxValue drilldownEntry;
                    List<FacetsCollector.MatchingDocs> sidewaysDocs = item.getValue().sidewaysDocs;
                    if (sidewaysDocs != null) {
                        this.processMatchingDocs(indexManager, sidewaysDocs, item.getKey(), true);
                    }
                    if ((drilldownEntry = this.sidewaysMinMax.get(item.getKey())) == null) continue;
                    boolean bl = drilldownEntry.useMinMax = !drilldownEntry.useValueList;
                    List<FacetsCollector.MatchingDocs> specialNumericDocs = item.getValue().specialNumericDocs;
                    if (specialNumericDocs == null || !drilldownEntry.useMinMax) continue;
                    drilldownEntry.valueList.clear();
                    drilldownEntry.matchCountList.clear();
                    drilldownEntry.useValueList = true;
                    this.processMatchingDocs(indexManager, specialNumericDocs, item.getKey(), true);
                }
                for (MinMaxValue minMax : this.minMaxValues) {
                    MinMaxValue drilledDownMinMax;
                    String fieldName = "facet_var_" + minMax.fieldName.toLowerCase();
                    IFacetListBuilder.Result.NumericSideway sideWay = this.sideways.get(fieldName);
                    if (sideWay == null || (drilledDownMinMax = this.sidewaysMinMax.get(fieldName)) == null) continue;
                    minMax.useMinMax = drilledDownMinMax.useMinMax;
                    minMax.minValue = drilledDownMinMax.minValue;
                    minMax.maxValue = drilledDownMinMax.maxValue;
                    if (!drilledDownMinMax.useValueList || sideWay.specialNumericDocs == null && drilledDownMinMax.useMinMax) continue;
                    minMax.valueList = drilledDownMinMax.valueList;
                    minMax.matchCountList = drilledDownMinMax.matchCountList;
                }
            }
            return this.minMaxValues;
        }

        private void processMatchingDocs(IIndexManager indexManager, List<FacetsCollector.MatchingDocs> matchingDocs, String sideWayField, boolean forSideways) throws IOException {
            block0: for (FacetsCollector.MatchingDocs docs : matchingDocs) {
                CompositeReader reader;
                IIndexManager.IIndexReaderData container;
                if (docs.totalHits == 0 || (container = indexManager.findReaderData(reader = docs.context.parent.reader())) == null) continue;
                container.cacheFacets();
                int baseDocId = container.getBaseDocId();
                int parentBase = docs.context.docBaseInParent;
                Containers.IntList idList = this.facetFilter.getFilteredDocIds(container, docs, sideWayField, baseDocId + parentBase);
                int[] idArray = idList.getData();
                for (int m = 0; m < this.minMaxValues.length; ++m) {
                    boolean firstRun;
                    String fieldName = "facet_var_" + this.fieldNames[m].toLowerCase();
                    boolean isSideways = sideWayField != null;
                    MinMaxValue minMax = this.minMaxValues[m];
                    if (isSideways && !sideWayField.equals(fieldName)) continue;
                    if (this.sideways != null && forSideways && this.sideways.containsKey(fieldName)) {
                        minMax = this.sidewaysMinMax.computeIfAbsent(fieldName, k -> new MinMaxValue(fieldName, true));
                    }
                    boolean bl = firstRun = !minMax.valid;
                    if (!minMax.valid) {
                        minMax.useValueList = true;
                        minMax.valid = true;
                    }
                    boolean collectValues = minMax.useValueList && minMax.valueList.size() <= FieldDefinitions.maxDistinctValues;
                    double[] ret = PFacetEvaluator.evaluateMinMax(this.fieldNames[m], baseDocId, idArray, idList.size(), collectValues);
                    if (ret != null) {
                        minMax.matchCount += (int)ret[0];
                        int totalMatches = 0;
                        for (int k2 = 0; k2 < ret.length / 3; ++k2) {
                            double mini = ret[k2 * 3 + 1];
                            double maxi = ret[k2 * 3 + 1 + 1];
                            int matches = (int)ret[k2 * 3 + 2 + 1];
                            totalMatches += matches;
                            if (mini < minMax.minValue) {
                                minMax.minValue = mini;
                            }
                            if (maxi > minMax.maxValue) {
                                minMax.maxValue = maxi;
                            }
                            if (mini == maxi) {
                                boolean found = false;
                                if (!firstRun && minMax.useValueList) {
                                    for (int i = 0; i < minMax.valueList.size(); ++i) {
                                        if (!(Math.abs(minMax.valueList.getDouble(i) - mini) < 1.0E-5)) continue;
                                        minMax.matchCountList.set(i, minMax.matchCountList.getInt(i) + matches);
                                        found = true;
                                        break;
                                    }
                                }
                                if (found || !minMax.useValueList) continue;
                                minMax.valueList.add(mini);
                                minMax.matchCountList.add(matches);
                                continue;
                            }
                            minMax.useValueList = false;
                            if (minMax.matchCountList.isEmpty()) continue;
                            minMax.matchCountList.clear();
                        }
                    }
                    if (sideWayField != null) continue block0;
                }
            }
        }
    }

    private class MinMaxRangeCollector
    implements Callable<MinMaxValue[]> {
        FacetsCollector.MatchingDocs matchingDocs;
        MinMaxValue[] minMaxValues;

        public MinMaxRangeCollector(FacetsCollector.MatchingDocs matchingDocs, List<String> fieldNames) {
            this.matchingDocs = matchingDocs;
            this.minMaxValues = new MinMaxValue[fieldNames.size()];
            int index = 0;
            for (String fieldName : fieldNames) {
                this.minMaxValues[index++] = new MinMaxValue(fieldName);
            }
        }

        @Override
        public MinMaxValue[] call() throws IOException {
            BinaryDocValues[] binaryValues = new BinaryDocValues[this.minMaxValues.length];
            for (int m = 0; m < binaryValues.length; ++m) {
                binaryValues[m] = DocValues.getBinary(this.matchingDocs.context.reader(), "facet_range_" + this.minMaxValues[m].fieldName);
            }
            DocIdSetIterator docs = this.matchingDocs.bits.iterator();
            MinMaxFacetCounts.this.evaluateMinMax(docs, binaryValues, this.minMaxValues, binaryValues.length);
            return this.minMaxValues;
        }
    }
}

