/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.facet;

import de.cadenas.catalogsearch.api.IIndexManager;
import de.cadenas.catalogsearch.api.ServiceFactory;
import de.cadenas.catalogsearch.lucene.index.VirtualFacetMapper;
import de.cadenas.catalogsearch.lucene.search.FacetCountingFilter;
import de.cadenas.util.Containers;
import de.cadenas.util.PFacetEvaluator;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.TopOrdAndIntQueue;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.UnicodeUtil;

public class PFacetCounts
extends Facets {
    private static final char DELIM_CHAR = '\u001f';
    private static final char ESCAPE_CHAR = '\u001e';
    final ExecutorService exec;
    final SortedSetDocValuesReaderState state;
    final FacetCountingFilter facetFilter;
    final SortedSetDocValues dv;
    final String field;
    final String fieldName;
    int[] counts;
    final boolean optimized;
    final String sidewayDim;
    final Object2IntMap<String> dimCounts;
    final Int2IntMap virtualOrds = new Int2IntOpenHashMap();
    private int virtualDimCount = 0;

    public PFacetCounts(SortedSetDocValuesReaderState state, List<FacetsCollector.MatchingDocs> matchingDocs, FacetCountingFilter facetFilter, boolean optimized, String sidewayDim, ExecutorService exec) throws IOException, InterruptedException {
        this.state = state;
        this.fieldName = this.field = state.getField();
        this.exec = exec;
        this.facetFilter = facetFilter;
        this.optimized = optimized;
        this.sidewayDim = sidewayDim;
        this.counts = new int[state.getSize()];
        this.dimCounts = new Object2IntOpenHashMap<String>();
        SortedSetDocValues docValues = null;
        try {
            docValues = state.getDocValues();
        }
        catch (AlreadyClosedException ignored) {
            ServiceFactory.getIndexManager().clearReaderStateCache();
        }
        this.dv = docValues;
        if (this.dv == null) {
            return;
        }
        if (matchingDocs == null) {
            this.countAll();
        } else {
            this.count(matchingDocs);
        }
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        if (topN <= 0) {
            throw new IllegalArgumentException("topN must be > 0 (got: " + topN + ")");
        }
        if (path.length > 0) {
            throw new IllegalArgumentException("path should be 0 length");
        }
        SortedSetDocValuesReaderState.OrdRange ordRange = this.state.getOrdRange(dim);
        if (ordRange == null) {
            if (dim.equals("facet_categories")) {
                return this.getVirtualDim();
            }
            return null;
        }
        return this.getDim(dim, ordRange, topN);
    }

    private FacetResult getVirtualDim() {
        VirtualFacetMapper mapper = VirtualFacetMapper.getInstance();
        ArrayList<LabelAndValue> values = new ArrayList<LabelAndValue>();
        for (Int2IntMap.Entry entry : this.virtualOrds.int2IntEntrySet()) {
            String facet = mapper.getFacetName(entry.getIntKey());
            if (facet == null || facet.isEmpty()) continue;
            values.add(new LabelAndValue(facet, entry.getIntValue()));
        }
        if (!values.isEmpty()) {
            LabelAndValue[] valueArray = values.toArray(new LabelAndValue[0]);
            FacetResult fr = new FacetResult("facet_categories", new String[0], this.virtualDimCount, valueArray, this.virtualDimCount);
            return fr;
        }
        return null;
    }

    private String getFacetValue(byte[] utf8, int offset, int length) {
        if (length == 0) {
            return "";
        }
        boolean lastEscape = false;
        int limit = offset + length;
        while (offset < limit) {
            int b;
            if ((b = utf8[offset++] & 0xFF) >= 192) {
                if (b < 224) {
                    ++offset;
                    continue;
                }
                if (b < 240) {
                    offset += 2;
                    continue;
                }
                offset += 3;
                continue;
            }
            char ch = (char)b;
            if (ch == '\u001e') {
                lastEscape = !lastEscape;
                continue;
            }
            if (ch == '\u001f') {
                if (!lastEscape) break;
                lastEscape = false;
                continue;
            }
            lastEscape = false;
        }
        char[] ref = new char[limit - offset];
        int len = UnicodeUtil.UTF8toUTF16(utf8, offset, limit - offset, ref);
        return new String(ref, 0, len);
    }

    private FacetResult getDim(String dim, SortedSetDocValuesReaderState.OrdRange ordRange, int topN) throws IOException {
        PriorityQueue q = null;
        int bottomCount = 0;
        int dimCount = 0;
        int childCount = 0;
        TopOrdAndIntQueue.OrdAndValue reuse = null;
        for (int ord = ordRange.start; ord <= ordRange.end; ++ord) {
            if (this.counts[ord] <= 0) continue;
            dimCount += this.counts[ord];
            ++childCount;
            if (this.counts[ord] <= bottomCount) continue;
            if (reuse == null) {
                reuse = new TopOrdAndIntQueue.OrdAndValue();
            }
            reuse.ord = ord;
            reuse.value = this.counts[ord];
            if (q == null) {
                q = new TopOrdAndIntQueue(topN);
            }
            reuse = q.insertWithOverflow(reuse);
            if (q.size() != topN) continue;
            bottomCount = ((TopOrdAndIntQueue.OrdAndValue)q.top()).value;
        }
        if (q == null) {
            return null;
        }
        LabelAndValue[] labelValues = new LabelAndValue[q.size()];
        for (int i = labelValues.length - 1; i >= 0; --i) {
            TopOrdAndIntQueue.OrdAndValue ordAndValue = (TopOrdAndIntQueue.OrdAndValue)q.pop();
            BytesRef term = this.dv.lookupOrd(ordAndValue.ord);
            String value = this.getFacetValue(term.bytes, term.offset, term.length);
            labelValues[i] = new LabelAndValue(value, ordAndValue.value);
        }
        childCount = this.dimCounts.getOrDefault((Object)dim, 0);
        return new FacetResult(dim, new String[0], dimCount, labelValues, childCount);
    }

    private void count(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException, InterruptedException {
        OrdinalMap ordinalMap = this.dv instanceof MultiDocValues.MultiSortedSetDocValues ? ((MultiDocValues.MultiSortedSetDocValues)this.dv).mapping : null;
        ArrayList<Future<Void>> results = new ArrayList<Future<Void>>();
        if (!this.optimized) {
            this.countDirectly(matchingDocs, ordinalMap);
            return;
        }
        for (FacetsCollector.MatchingDocs matchingDocs2 : matchingDocs) {
            if (matchingDocs2.totalHits <= 0) continue;
            results.add(this.exec.submit(new CountOneSegment(matchingDocs2.context.reader(), matchingDocs2, ordinalMap, this.facetFilter, matchingDocs2.context.ord)));
        }
        for (Future future : results) {
            try {
                future.get();
            }
            catch (ExecutionException ee) {
                Throwable cause = ee.getCause();
                throw IOUtils.rethrowAlways(cause != null ? cause : ee);
            }
        }
    }

    private void countDirectly(List<FacetsCollector.MatchingDocs> matchingDocs, OrdinalMap ordinalMap) throws IOException {
        CompositeReader indexReader;
        IIndexManager indexManager = ServiceFactory.getIndexManager();
        IIndexManager.IIndexReaderData readerData = indexManager.findReaderData(indexReader = matchingDocs.get((int)0).context.parent.reader());
        if (readerData == null) {
            return;
        }
        Map<String, SortedSetDocValuesReaderState.OrdRange> groupMap = this.state.getPrefixToOrdRange();
        int index = 0;
        Int2ObjectOpenHashMap<String> groupNames = new Int2ObjectOpenHashMap<String>(groupMap.size());
        int[] groupLookup = new int[this.state.getSize()];
        for (Map.Entry<String, SortedSetDocValuesReaderState.OrdRange> entry : groupMap.entrySet()) {
            groupNames.put(index, entry.getKey());
            SortedSetDocValuesReaderState.OrdRange r = entry.getValue();
            for (int i = r.start; i <= r.end; ++i) {
                groupLookup[i] = index;
            }
            ++index;
        }
        IntSet docIdFilter = null;
        if (this.facetFilter != null) {
            docIdFilter = this.facetFilter.createDocIdFilter(readerData, this.sidewayDim);
        }
        Int2IntMap groupCounts = null;
        if (matchingDocs.size() == 1) {
            FacetsCollector.MatchingDocs md = matchingDocs.get(0);
            CountLeafReader counter = new CountLeafReader(ordinalMap, md.context.reader(), md, docIdFilter, groupLookup, md.context.ordInParent);
            CountResult countResult = counter.call();
            if (countResult != null) {
                this.counts = countResult.segCounts;
                groupCounts = countResult.groupCounts;
            }
        } else {
            groupCounts = new Int2IntOpenHashMap();
            ArrayList<Future<CountResult>> results = new ArrayList<Future<CountResult>>();
            for (FacetsCollector.MatchingDocs matchingDocs2 : matchingDocs) {
                if (matchingDocs2.totalHits <= 0) continue;
                results.add(this.exec.submit(new CountLeafReader(ordinalMap, matchingDocs2.context.reader(), matchingDocs2, docIdFilter, groupLookup, matchingDocs2.context.ordInParent)));
            }
            for (Future future : results) {
                try {
                    CountResult result = (CountResult)future.get();
                    if (result == null) continue;
                    for (int i = 0; i < result.segCounts.length; ++i) {
                        int n = i;
                        this.counts[n] = this.counts[n] + result.segCounts[i];
                    }
                    for (Int2IntMap.Entry kv : result.groupCounts.int2IntEntrySet()) {
                        groupCounts.merge(kv.getIntKey(), kv.getIntValue(), (BiFunction<? super Integer, ? super Integer, ? extends Integer>)((BiFunction<Integer, Integer, Integer>)Integer::sum));
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        if (groupCounts != null) {
            for (Int2IntMap.Entry entry : groupCounts.int2IntEntrySet()) {
                String string;
                if (entry.getIntValue() == 0 || (string = (String)groupNames.get(entry.getIntKey())) == null || string.isEmpty()) continue;
                this.dimCounts.put(string, entry.getIntValue());
            }
        }
    }

    private void countAll() throws IOException, InterruptedException {
        OrdinalMap ordinalMap = this.dv instanceof MultiDocValues.MultiSortedSetDocValues ? ((MultiDocValues.MultiSortedSetDocValues)this.dv).mapping : null;
        ArrayList<Future<Void>> results = new ArrayList<Future<Void>>();
        for (LeafReaderContext leafReaderContext : this.state.getReader().leaves()) {
            results.add(this.exec.submit(new CountOneSegment(leafReaderContext.reader(), null, ordinalMap, this.facetFilter, leafReaderContext.ord)));
        }
        for (Future future : results) {
            try {
                future.get();
            }
            catch (ExecutionException ee) {
                Throwable cause = ee.getCause();
                throw IOUtils.rethrowAlways(cause != null ? cause : ee);
            }
        }
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        if (path.length != 1) {
            throw new IllegalArgumentException("path must be length=1");
        }
        int ord = (int)this.dv.lookupTerm(new BytesRef(FacetsConfig.pathToString(dim, path)));
        if (ord < 0) {
            return -1;
        }
        return this.counts[ord];
    }

    @Override
    public List<FacetResult> getAllDims(int topN) throws IOException {
        FacetResult fr;
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        for (Map.Entry<String, SortedSetDocValuesReaderState.OrdRange> ent : this.state.getPrefixToOrdRange().entrySet()) {
            FacetResult fr2 = this.getDim(ent.getKey(), ent.getValue(), topN);
            if (fr2 == null) continue;
            results.add(fr2);
        }
        if (!this.virtualOrds.isEmpty() && (fr = this.getVirtualDim()) != null) {
            results.add(fr);
        }
        results.sort((a, b) -> {
            if (a.value.intValue() > b.value.intValue()) {
                return -1;
            }
            if (b.value.intValue() > a.value.intValue()) {
                return 1;
            }
            return a.dim.compareTo(b.dim);
        });
        return results;
    }

    private class CountOneSegment
    implements Callable<Void> {
        final LeafReader leafReader;
        final FacetsCollector.MatchingDocs hits;
        final OrdinalMap ordinalMap;
        final FacetCountingFilter facetFilter;
        final int segOrd;

        public CountOneSegment(LeafReader leafReader, FacetsCollector.MatchingDocs hits, OrdinalMap ordinalMap, FacetCountingFilter facetFilter, int segOrd) {
            this.leafReader = leafReader;
            this.hits = hits;
            this.ordinalMap = ordinalMap;
            this.facetFilter = facetFilter;
            this.segOrd = segOrd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Void call() throws IOException {
            CompositeReader reader;
            SortedSetDocValues segValues = this.leafReader.getSortedSetDocValues(PFacetCounts.this.field);
            if (segValues == null) {
                return null;
            }
            IIndexManager indexManager = ServiceFactory.getIndexManager();
            IIndexManager.IIndexReaderData readerData = indexManager.findReaderData(reader = this.hits.context.parent.reader());
            if (readerData == null) {
                return null;
            }
            readerData.cacheOrds();
            int baseDocId = readerData.getBaseDocId();
            int segmentId = readerData.getLeafId(this.leafReader);
            int parentBase = this.hits.context.docBaseInParent;
            Containers.IntList docIdList = this.facetFilter.getFilteredDocIds(readerData, this.hits, PFacetCounts.this.sidewayDim, 0);
            if (docIdList.isEmpty()) return null;
            int numSegOrds = (int)segValues.getValueCount();
            int[] segCounts = this.ordinalMap == null ? PFacetCounts.this.counts : new int[numSegOrds];
            int[] groupCounts = PFacetEvaluator.evaluateOrds(PFacetCounts.this.fieldName, baseDocId, segmentId, docIdList.getData(), docIdList.size(), segCounts, segCounts.length);
            if (groupCounts != null) {
                int groupsCount = groupCounts[0];
                for (int i = 0; i < groupsCount; ++i) {
                    int group = groupCounts[i * 2 + 1];
                    String groupName = readerData.getDimName(group, segmentId);
                    if (groupName.isEmpty()) continue;
                    int count = groupCounts[i * 2 + 2];
                    Object2IntMap<String> object2IntMap = PFacetCounts.this.dimCounts;
                    synchronized (object2IntMap) {
                        PFacetCounts.this.dimCounts.mergeInt(groupName, count, Integer::sum);
                        continue;
                    }
                }
                int localVirtualDimCount = groupCounts[groupsCount * 2 + 1];
                if (groupsCount * 2 + 2 < groupCounts.length) {
                    Int2IntMap group = PFacetCounts.this.virtualOrds;
                    synchronized (group) {
                        for (int i = groupsCount * 2 + 2; i < groupCounts.length; i += 2) {
                            int ord = groupCounts[i];
                            int count = groupCounts[i + 1];
                            PFacetCounts.this.virtualOrds.merge(ord, count, (BiFunction<? super Integer, ? super Integer, ? extends Integer>)((BiFunction<Integer, Integer, Integer>)Integer::sum));
                        }
                        PFacetCounts.this.virtualDimCount += localVirtualDimCount;
                    }
                }
            }
            if (this.ordinalMap == null) return null;
            LongValues ordMap = this.ordinalMap.getGlobalOrds(this.segOrd);
            int[] nArray = PFacetCounts.this.counts;
            synchronized (PFacetCounts.this.counts) {
                for (int ord = 0; ord < numSegOrds; ++ord) {
                    int count = segCounts[ord];
                    if (count == 0) continue;
                    int n = (int)ordMap.get(ord);
                    PFacetCounts.this.counts[n] = PFacetCounts.this.counts[n] + count;
                }
                // ** MonitorExit[var13_15] (shouldn't be in output)
                return null;
            }
        }
    }

    private class CountLeafReader
    implements Callable<CountResult> {
        private final OrdinalMap ordinalMap;
        private final LeafReader reader;
        private final FacetsCollector.MatchingDocs hits;
        private final IntSet docIdFilter;
        private final int[] groupLookup;
        private final int segOrd;

        public CountLeafReader(OrdinalMap ordinalMap, LeafReader leafReader, FacetsCollector.MatchingDocs hits, IntSet docIdFilter, int[] groupLookup, int segOrd) {
            this.ordinalMap = ordinalMap;
            this.reader = leafReader;
            this.hits = hits;
            this.docIdFilter = docIdFilter;
            this.groupLookup = groupLookup;
            this.segOrd = segOrd;
        }

        @Override
        public CountResult call() throws IOException {
            SortedSetDocValues segValues = this.reader.getSortedSetDocValues(PFacetCounts.this.field);
            if (segValues == null) {
                return null;
            }
            LongValues ordMap = null;
            if (this.ordinalMap != null) {
                ordMap = this.ordinalMap.getGlobalOrds(this.segOrd);
            }
            DocIdSetIterator it = ConjunctionUtils.intersectIterators(Arrays.asList(this.hits.bits.iterator(), segValues));
            Int2IntOpenHashMap groupCounts = new Int2IntOpenHashMap(this.groupLookup.length);
            IntOpenHashSet groupsPerDoc = new IntOpenHashSet();
            int[] segCounts = new int[PFacetCounts.this.counts.length];
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (this.docIdFilter == null || !this.docIdFilter.contains(doc)) {
                    groupsPerDoc.clear();
                    int term = (int)segValues.nextOrd();
                    while ((long)term != -1L) {
                        int group;
                        if (ordMap != null) {
                            term = (int)ordMap.get(term);
                        }
                        if (groupsPerDoc.add(group = this.groupLookup[term])) {
                            groupCounts.merge(group, 1, (BiFunction<? super Integer, ? super Integer, ? extends Integer>)((BiFunction<Integer, Integer, Integer>)Integer::sum));
                        }
                        int n = term;
                        segCounts[n] = segCounts[n] + 1;
                        term = (int)segValues.nextOrd();
                    }
                }
                doc = it.nextDoc();
            }
            CountResult ret = new CountResult();
            ret.segCounts = segCounts;
            ret.groupCounts = groupCounts;
            return ret;
        }
    }

    private static class CountResult {
        int[] segCounts;
        Int2IntMap groupCounts;

        private CountResult() {
        }
    }
}

