/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.facet;

import de.cadenas.util.Containers;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;

public class PFacetMap {
    private static PFacetMap instance = null;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Object2LongMap<BytesRef> facetMap = new Object2LongOpenHashMap<BytesRef>();
    private int lastOrd = 0;

    private PFacetMap() {
    }

    public static synchronized PFacetMap getInstance() {
        if (instance == null) {
            instance = new PFacetMap();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] createIndexMapping(TermsEnum termsEnum) throws IOException {
        this.lock.writeLock().lock();
        Containers.IntList ordMap = new Containers.IntList();
        try {
            BytesRef term = termsEnum.next();
            while (term != null) {
                int id;
                long v = this.facetMap.getOrDefault((Object)term, 0L);
                if (v == 0L) {
                    ++this.lastOrd;
                    v = 0x100000000L;
                    v &= (long)id;
                } else {
                    id = (int)((v += 0x100000000L) >> 32);
                }
                this.facetMap.put(term, v);
                int ord = (int)termsEnum.ord();
                ordMap.ensureCapacity(ord);
                ordMap.set(ord, id);
                term = termsEnum.next();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return ordMap.toIntArray();
    }
}

