/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.fields;

public class PSolFieldName {
    private final char Separator = (char)58;
    private String fieldType;
    private String varName;
    private String language;
    private boolean isErp = false;
    private boolean isNumeric = false;
    private boolean isRange = false;

    private boolean parse(String fullName) {
        int sep1 = fullName.indexOf(58);
        if (sep1 == -1) {
            return false;
        }
        int sep2 = fullName.indexOf(58, sep1 + 1);
        if (sep2 == -1) {
            return false;
        }
        int sep3 = fullName.indexOf(58, sep2 + 1);
        if (sep3 == -1) {
            return false;
        }
        int index = fullName.indexOf(58, sep3 + 1);
        if (index != -1) {
            return false;
        }
        this.fieldType = fullName.substring(0, sep1);
        String flagSection = fullName.substring(sep1 + 1, sep2);
        this.isErp = flagSection.contains("e");
        this.isNumeric = flagSection.contains("n");
        this.isRange = flagSection.contains("r");
        this.language = fullName.substring(sep2 + 1, sep3);
        this.varName = fullName.substring(sep3 + 1);
        return true;
    }

    public PSolFieldName(String fullName) {
        this.parse(fullName);
    }

    public PSolFieldName(String fieldType, String varName, boolean numeric) {
        this.fieldType = fieldType;
        this.varName = varName;
        this.isNumeric = numeric;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean isErp() {
        return this.isErp;
    }

    public void setErp(boolean erp) {
        this.isErp = erp;
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public void setNumeric(boolean numeric) {
        this.isNumeric = numeric;
    }

    public boolean isRange() {
        return this.isRange;
    }

    public void setRange(boolean range) {
        this.isRange = range;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fieldType);
        sb.append(':');
        if (this.isErp) {
            sb.append('e');
        }
        if (this.isNumeric) {
            sb.append('n');
        } else {
            sb.append('t');
        }
        if (this.isRange) {
            sb.append('r');
        }
        sb.append(':');
        sb.append(this.language);
        sb.append(':');
        sb.append(this.varName);
        return sb.toString();
    }
}

