/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.highlighting;

import de.cadenas.catalogsearch.lucene.highlighting.HighlightTokenContainer;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightUtils;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightingNode;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemAutomaton;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemPrefix;
import java.util.List;

public class AutomatonHighlightingNode
extends HighlightingNode {
    private boolean valuePrefix = false;

    public AutomatonHighlightingNode(PSolQueryItemAutomaton automatonItem, HighlightingNode parent) {
        super(automatonItem.getTerm().field(), automatonItem.getTerm().text(), parent);
        if (automatonItem instanceof PSolQueryItemPrefix) {
            this.valuePrefix = true;
            this.value = this.value + "*";
        } else if (this.field.startsWith("col_text_")) {
            this.field = HighlightUtils.removeLanguageGroup(this.field.replace("col_text_", "col_number_"));
            this.valuePrefix = true;
        }
        this.addFieldValue(this.field, this.value);
    }

    @Override
    public void analyseFragmentStream(HighlightTokenContainer fragmentTokenContainer, HighlightTokenContainer stemmedSearchTerms, int[] previousIndexBuffer) {
        List<HighlightTokenContainer.HighlightToken> fragmentTokens = fragmentTokenContainer.tokens;
        boolean matchFound = false;
        int lastEndOffset = -1;
        int lastStartOffset = -1;
        for (HighlightTokenContainer.HighlightToken fragmentToken : fragmentTokens) {
            if (matchFound && lastStartOffset != -1 && fragmentToken.startOffset() <= lastEndOffset) {
                previousIndexBuffer[lastStartOffset] = fragmentToken.endOffset();
                continue;
            }
            matchFound = false;
            lastEndOffset = -1;
            lastStartOffset = -1;
            if (!HighlightUtils.matchGlob(fragmentToken.term(), this.value, this.valuePrefix) || previousIndexBuffer[fragmentToken.startOffset()] >= fragmentToken.endOffset()) continue;
            previousIndexBuffer[fragmentToken.startOffset()] = fragmentToken.endOffset();
            lastStartOffset = fragmentToken.startOffset();
            lastEndOffset = fragmentToken.endOffset();
            matchFound = true;
        }
    }
}

