/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.highlighting;

import de.cadenas.catalogsearch.lucene.highlighting.HighlightUtils;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.IHighlightingInfoReceiver;
import de.cadenas.catalogsearch.lucene.highlighting.QueryDecomposerFactory;
import de.cadenas.util.PIntPair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;

public class BooleanHighlightingNode
extends HighlightingNode {
    private final BooleanQuery booleanQuery;

    public BooleanHighlightingNode(BooleanQuery bq, HighlightingNode parent) {
        super("", "", parent);
        this.booleanQuery = bq;
    }

    @Override
    public void transmitNodes(IHighlightingInfoReceiver receiver) {
        for (BooleanClause clause : this.booleanQuery.clauses()) {
            QueryDecomposerFactory.decompose(clause.getQuery(), receiver, (HighlightingNode)this);
            receiver.setLastNodeOccur(clause.getOccur());
        }
        HighlightUtils.collectMisplacedHighlighting(this);
        this.highlightPositions = this.getBoolLogicPositions(receiver.isBoolLogicActivated());
        receiver.receiveNode(this);
        this.highlighted = this.children.stream().allMatch(HighlightingNode::isHighlighted);
    }

    Int2ObjectMap<List<PIntPair>> getBoolLogicPositions(boolean activateBoolLogic) {
        ArrayList<Int2ObjectMap.Entry<List<PIntPair>>> objectList = new ArrayList<Int2ObjectMap.Entry<List<PIntPair>>>();
        if (this.children.size() == 1) {
            return ((HighlightingNode)this.children.get((int)0)).highlightPositions;
        }
        if (!activateBoolLogic) {
            this.children.forEach(child -> objectList.addAll(child.highlightPositions.int2ObjectEntrySet()));
        } else {
            this.applyBoolLogicAndGatherEntries(objectList);
        }
        return this.removeDuplicated(objectList);
    }

    private void initLogicNodeLists(Collection<HighlightingNode> andNotNodes, Collection<Int2ObjectMap.Entry<List<PIntPair>>> objectList) {
        for (HighlightingNode child : this.children) {
            if (BooleanClause.Occur.MUST == child.occur || BooleanClause.Occur.MUST_NOT == child.occur) {
                andNotNodes.add(child);
                continue;
            }
            if (BooleanClause.Occur.SHOULD != child.occur) continue;
            objectList.addAll(child.highlightPositions.int2ObjectEntrySet());
        }
    }

    private boolean incorrectANDNOTNode(HighlightingNode node, boolean notNode) {
        return (node.highlightPositions == null || node.highlightPositions.isEmpty()) && !notNode || node.highlightPositions != null && !node.highlightPositions.isEmpty() && notNode;
    }

    private Collection<Int2ObjectMap.Entry<List<PIntPair>>> analyseAndNotNodesAndGetResult(Collection<HighlightingNode> andNotNodes) {
        ArrayList<Int2ObjectMap.Entry<List<PIntPair>>> tempObjectList = new ArrayList<Int2ObjectMap.Entry<List<PIntPair>>>();
        for (HighlightingNode node : andNotNodes) {
            boolean notNode;
            boolean bl = notNode = BooleanClause.Occur.MUST_NOT == node.occur;
            if (this.incorrectANDNOTNode(node, notNode)) {
                andNotNodes.clear();
                tempObjectList.clear();
                break;
            }
            tempObjectList.addAll(node.highlightPositions.int2ObjectEntrySet());
        }
        return tempObjectList;
    }

    private void applyBoolLogicAndGatherEntries(Collection<Int2ObjectMap.Entry<List<PIntPair>>> objectList) {
        ArrayList<HighlightingNode> andNotNodes = new ArrayList<HighlightingNode>();
        this.initLogicNodeLists(andNotNodes, objectList);
        objectList.addAll(this.analyseAndNotNodesAndGetResult(andNotNodes));
    }

    private Int2ObjectMap<List<PIntPair>> removeDuplicated(Iterable<Int2ObjectMap.Entry<List<PIntPair>>> objectList) {
        Int2ObjectOpenHashMap<List<PIntPair>> returnValue = new Int2ObjectOpenHashMap<List<PIntPair>>();
        for (Int2ObjectMap.Entry<List<PIntPair>> entry : objectList) {
            List list = returnValue.computeIfAbsent(entry.getIntKey(), f -> new ArrayList());
            for (PIntPair pair : (List)entry.getValue()) {
                HighlightUtils.updateExistingHighlightMapping(list, pair);
            }
        }
        return returnValue;
    }

    @Override
    public void onChildDetached(HighlightingNode child) {
        this.children.remove(child);
    }
}

