/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.highlighting;

import de.cadenas.catalogsearch.lucene.highlighting.HighlightTokenContainer;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.IHighlightingInfoReceiver;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemExact;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemTerm;
import org.apache.lucene.index.Term;

public class ExactHighlightingNode
extends HighlightingNode {
    public ExactHighlightingNode(PSolQueryItemExact exactItem, HighlightingNode parent) {
        PSolQueryItemTerm termQuery = exactItem.getTermQuery();
        Term term = termQuery.getTerm();
        this.field = term.field();
        this.value = term.text();
        this.setParent(parent);
        parent.setQueryLength(this.value.length());
        this.addFieldValue(this.field, this.value);
    }

    protected boolean matchHighlightCriteria(String searchToken, HighlightTokenContainer.HighlightToken fragmentToken) {
        return searchToken.equalsIgnoreCase(fragmentToken.term()) && this.value.length() == fragmentToken.endOffset() - fragmentToken.startOffset();
    }

    @Override
    public void standardHighlight(HighlightTokenContainer fragmentTokenContainer, HighlightTokenContainer stemmedSearchTerms, int[] highlightingBuffer) {
        for (HighlightTokenContainer.HighlightToken fragmentToken : fragmentTokenContainer.tokens) {
            if (!this.matchHighlightCriteria(this.value, fragmentToken)) continue;
            highlightingBuffer[fragmentToken.startOffset()] = fragmentToken.endOffset();
            break;
        }
    }

    @Override
    public void transmitNodes(IHighlightingInfoReceiver receiver) {
        receiver.receiveNode(this);
    }
}

