/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.highlighting;

import de.cadenas.catalogsearch.lucene.analysis.FieldAwareAnalyzer;
import de.cadenas.catalogsearch.lucene.analysis.helper.TokenFlags;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightingAddressBook;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

public class HighlightTokenContainer {
    private static final Pattern pattern = Pattern.compile("-?\\d+(\\.\\d+)?");
    public List<HighlightToken> tokens = new ArrayList<HighlightToken>();

    private HighlightTokenContainer(TokenStream stream) {
        this.parseTokenStream(stream);
    }

    private void parseTokenStream(TokenStream stream) {
        CharTermAttribute termAttribute = stream.addAttribute(CharTermAttribute.class);
        OffsetAttribute offsetAttribute = stream.addAttribute(OffsetAttribute.class);
        FlagsAttribute flagsAttribute = stream.addAttribute(FlagsAttribute.class);
        try {
            stream.reset();
            while (stream.incrementToken()) {
                this.tokens.add(new HighlightToken(termAttribute.toString(), offsetAttribute.startOffset(), offsetAttribute.endOffset(), TokenFlags.isSet(TokenFlags.Flag.CompleteWord, flagsAttribute)));
            }
            stream.close();
        }
        catch (Exception e) {
            this.tokens.clear();
        }
    }

    public static HighlightTokenContainer build(String buildingString, String field, HighlightingAddressBook storage) {
        String cacheKey = buildingString.concat(field);
        HighlightTokenContainer container = storage.tokenCache.get(cacheKey);
        if (container != null) {
            return container;
        }
        try (FieldAwareAnalyzer searchTermAnalyzer = new FieldAwareAnalyzer(false);){
            TokenStream stream = searchTermAnalyzer.tokenStream(field, buildingString);
            container = new HighlightTokenContainer(stream);
            storage.tokenCache.put(cacheKey, container);
        }
        return container;
    }

    public static HighlightTokenContainer build(TokenStream stream) throws IOException {
        return new HighlightTokenContainer(stream);
    }

    public static class HighlightToken {
        private final String term;
        private final int startOffset;
        private final int endOffset;
        private boolean numericAnalysed = false;
        private boolean isNumeric = false;
        private boolean isCompleteWord = false;

        public HighlightToken(String term, int startOffset, int endOffset, boolean isCompleteWord) {
            this.term = term;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.isCompleteWord = isCompleteWord;
        }

        public boolean termIsNumeric() {
            if (!this.numericAnalysed) {
                this.isNumeric = pattern.matcher(this.term).matches();
                this.numericAnalysed = true;
            }
            return this.isNumeric;
        }

        public String term() {
            return this.term;
        }

        public int startOffset() {
            return this.startOffset;
        }

        public int endOffset() {
            return this.endOffset;
        }

        public int length() {
            return this.endOffset - this.startOffset;
        }

        public boolean completeWord() {
            return this.isCompleteWord;
        }

        public String toString() {
            return this.term + " " + this.startOffset + " : " + this.endOffset;
        }
    }
}

