/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.highlighting;

import de.cadenas.catalogsearch.lucene.highlighting.BooleanHighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightTokenContainer;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.PositionSpanSearcher;
import de.cadenas.util.PIntPair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;

public final class HighlightUtils {
    private HighlightUtils() {
    }

    public static void mergeHighlightTokenPositions(int[] previousIndexBuffer, List<HighlightTokenContainer.HighlightToken> adjacentFragments) {
        Arrays.fill(previousIndexBuffer, -1);
        int firstStartOffset = -1;
        for (HighlightTokenContainer.HighlightToken fragment : adjacentFragments) {
            if (firstStartOffset == -1) {
                firstStartOffset = fragment.startOffset();
            }
            if (previousIndexBuffer[firstStartOffset] >= fragment.endOffset()) continue;
            previousIndexBuffer[firstStartOffset] = fragment.endOffset();
        }
    }

    public static void mergeAdjacentSearchSpans(int[] previousBuffer, int stemmedSearchTermsSize, HighlightingNode node) {
        PositionSpanSearcher pSpan = new PositionSpanSearcher();
        for (int i = 0; i < previousBuffer.length; ++i) {
            if (previousBuffer[i] == -1) continue;
            pSpan.doSpanSearch(i, previousBuffer);
            if (!pSpan.foundSpan(node.getQueryLength(), stemmedSearchTermsSize)) continue;
            pSpan.addSpanToBuffer(previousBuffer);
        }
    }

    public static void collectMisplacedHighlighting(HighlightingNode parent) {
        HashMap nodesForField = new HashMap();
        for (HighlightingNode highlightingNode : parent.children) {
            if (highlightingNode.occur != BooleanClause.Occur.MUST) continue;
            HighlightUtils.putIntoListMap(nodesForField, highlightingNode.field, highlightingNode);
        }
        for (Map.Entry entry : nodesForField.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            BooleanHighlightingNode joinerNode = new BooleanHighlightingNode(null, parent);
            for (HighlightingNode repeatedNode : (List)entry.getValue()) {
                repeatedNode.occur = BooleanClause.Occur.SHOULD;
                joinerNode.children.add(repeatedNode);
                parent.children.remove(repeatedNode);
            }
            joinerNode.highlightPositions = joinerNode.getBoolLogicPositions(false);
            if (!joinerNode.highlightPositions.isEmpty()) {
                joinerNode.highlighted = true;
            }
            joinerNode.occur = BooleanClause.Occur.MUST;
        }
        parent.organizePeers();
    }

    public static boolean doesIntersect(PIntPair firstPair, PIntPair secondPair) {
        return secondPair.first >= firstPair.first && secondPair.first <= firstPair.second || secondPair.second >= firstPair.first && secondPair.second <= firstPair.second || secondPair.first <= firstPair.first && secondPair.second >= firstPair.second;
    }

    public static String removeLanguageGroup(String lField) {
        if (lField.endsWith("_lang")) {
            int lastUnderScoreIndex = lField.length() - "_lang".length();
            int underScoreBeforeLanguageGroup = lField.lastIndexOf(95, lastUnderScoreIndex - 1);
            return lField.substring(0, underScoreBeforeLanguageGroup);
        }
        return lField;
    }

    public static void mergeIntersectingPositions(PIntPair newPair, Collection<PIntPair> currentPositionValues) {
        PIntPair pair = newPair;
        ArrayList<PIntPair> positionsToRemove = new ArrayList<PIntPair>();
        for (PIntPair currentPosition : currentPositionValues) {
            if (!HighlightUtils.doesIntersect(currentPosition, pair)) continue;
            pair = new PIntPair(Math.min(currentPosition.first, pair.first), Math.max(currentPosition.second, pair.second));
            positionsToRemove.add(currentPosition);
        }
        currentPositionValues.removeAll(positionsToRemove);
        currentPositionValues.add(pair);
    }

    public static String replaceUmlaut(String input) {
        String output = input.replace("\u00fc", "u").replace("\u00f6", "o").replace("\u00e4", "a").replace("\u00df", "ss");
        output = output.replaceAll("\u00dc(?=[a-z\u00e4\u00f6\u00fc\u00df ])", "U").replaceAll("\u00d6(?=[a-z\u00e4\u00f6\u00fc\u00df ])", "O").replaceAll("\u00c4(?=[a-z\u00e4\u00f6\u00fc\u00df ])", "A");
        output = output.replace("\u00dc", "U").replace("\u00d6", "O").replace("\u00c4", "A");
        return output;
    }

    public static void mergeHighlightingPositions(Int2ObjectMap<List<PIntPair>> parentMap, Int2ObjectMap<List<PIntPair>> childMap) {
        for (Int2ObjectMap.Entry entry : childMap.int2ObjectEntrySet()) {
            if (parentMap.containsKey(entry.getIntKey())) {
                List entryCopy = (List)entry.getValue();
                for (int i = 0; i < entryCopy.size(); ++i) {
                    PIntPair value = (PIntPair)((List)entry.getValue()).get(i);
                    List<PIntPair> replacement = HighlightUtils.updateExistingHighlightMapping((List)parentMap.get(entry.getIntKey()), value);
                    if (!replacement.isEmpty()) {
                        parentMap.replace(entry.getIntKey(), replacement);
                        continue;
                    }
                    parentMap.remove(entry.getIntKey());
                }
                continue;
            }
            parentMap.put(entry.getIntKey(), (List<PIntPair>)((List)entry.getValue()));
        }
    }

    public static List<PIntPair> updateExistingHighlightMapping(List<PIntPair> currentPositionValues, PIntPair newPositionValue) {
        if (currentPositionValues.stream().anyMatch(pIntPair -> HighlightUtils.doesIntersect(pIntPair, newPositionValue))) {
            HighlightUtils.mergeIntersectingPositions(newPositionValue, currentPositionValues);
        } else {
            currentPositionValues.add(newPositionValue);
        }
        return currentPositionValues.isEmpty() ? Collections.emptyList() : currentPositionValues;
    }

    public static void addNotPresentPositions(Iterable<Int2ObjectMap.Entry<List<PIntPair>>> objectList, Int2ObjectMap<List<PIntPair>> highlightPositions) {
        for (Int2ObjectMap.Entry<List<PIntPair>> entry : objectList) {
            int key = entry.getIntKey();
            highlightPositions.computeIfAbsent(key, v -> (List)entry.getValue());
            HighlightUtils.addNonIntersectingPositions(highlightPositions, entry, key);
        }
    }

    private static void addNonIntersectingPositions(Int2ObjectMap<List<PIntPair>> highlightPositions, Int2ObjectMap.Entry<List<PIntPair>> entry, int key) {
        List currentValue = (List)highlightPositions.get(key);
        List<PIntPair> addableValues = ((List)entry.getValue()).stream().filter(entryPair -> currentValue.stream().noneMatch(currentPair -> HighlightUtils.doesIntersect(currentPair, entryPair))).toList();
        currentValue.addAll(addableValues);
        highlightPositions.replace(key, (List<PIntPair>)currentValue);
    }

    public static <S, T> void putIntoListMap(Map<S, List<T>> map, S key, T object) {
        List list = map.computeIfAbsent(key, k -> new ArrayList());
        if (!list.contains(object)) {
            list.add(object);
        }
    }

    public static void updateHighlightMap(Int2ObjectMap<List<PIntPair>> highlightMap, int fragIndex, int[] highlightPositions, int index) {
        if (highlightMap.containsKey(fragIndex)) {
            List<PIntPair> replacement = HighlightUtils.updateExistingHighlightMapping((List)highlightMap.get(fragIndex), new PIntPair(index, highlightPositions[index]));
            if (replacement.isEmpty()) {
                highlightMap.remove(fragIndex);
            } else {
                highlightMap.replace(fragIndex, replacement);
            }
        } else {
            highlightMap.put(fragIndex, HighlightUtils.createNewHighlightMapping(index, highlightPositions[index]));
        }
    }

    private static List<PIntPair> createNewHighlightMapping(int start, int end) {
        ArrayList<PIntPair> intList = new ArrayList<PIntPair>();
        intList.add(new PIntPair(start, end));
        return intList;
    }

    public static boolean matchGlob(CharSequence text, CharSequence glob, boolean valuePrefix) {
        int textBackup = -1;
        int globBackup = -1;
        int textIndex = 0;
        int globIndex = 0;
        block4: while (textIndex != text.length() && globIndex != glob.length()) {
            switch (glob.charAt(globIndex)) {
                case '*': {
                    textBackup = textIndex;
                    globBackup = ++globIndex;
                    continue block4;
                }
                case '?': {
                    ++textIndex;
                    ++globIndex;
                    continue block4;
                }
            }
            if (glob.charAt(globIndex) == text.charAt(textIndex)) {
                ++textIndex;
                ++globIndex;
                continue;
            }
            if (globBackup == -1) {
                return false;
            }
            textIndex = ++textBackup;
            globIndex = globBackup;
        }
        while (globIndex != glob.length() && glob.charAt(globIndex) == '*') {
            ++globIndex;
        }
        if (!valuePrefix && globIndex != text.length()) {
            return false;
        }
        return glob.length() == globIndex;
    }
}

