/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.highlighting;

import de.cadenas.catalogsearch.HighlightingRequest;
import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightTokenContainer;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class HighlightingAddressBook {
    public Map<String, HighlightTokenContainer> tokenCache = new HashMap<String, HighlightTokenContainer>();
    Int2ObjectMap<Map<String, IntList>> fragmentsForLanguage = new Int2ObjectOpenHashMap<Map<String, IntList>>();
    Map<String, IntList> nonLanguageFragments = new HashMap<String, IntList>();
    private final Int2ObjectMap<IntList> languageIndices = new Int2ObjectOpenHashMap<IntList>();
    private final Int2ObjectMap<GenerationState> languageGenerationNeedStates = new Int2ObjectOpenHashMap<GenerationState>();
    private boolean nonLanguageFragmentsGenerated = false;
    final HighlightingRequest request;

    public HighlightingAddressBook(HighlightingRequest request) {
        this.request = request;
        for (int index = 0; index < request.fragments.size(); ++index) {
            HighlightingRequest.Fragment fragment = request.fragments.get(index);
            for (String field : fragment.fieldNames) {
                if (!field.endsWith("_lang")) continue;
                FieldDefinitions.LanguageGroup lang = FieldDefinitions.getLanguageGroup(FieldDefinitions.getLanguageOfField(field));
                this.languageIndices.computeIfAbsent(lang.ordinal(), k -> new IntArrayList()).add(index);
            }
        }
        for (String lang : request.languageList) {
            FieldDefinitions.LanguageGroup langGroup = FieldDefinitions.getLanguageGroup(lang);
            this.languageGenerationNeedStates.putIfAbsent(langGroup.ordinal(), GenerationState.NOT_GENERATED);
        }
    }

    public IntList getFragmentIndicesForLangField(String field) {
        FieldDefinitions.LanguageGroup lang = FieldDefinitions.getLanguageGroup(FieldDefinitions.getLanguageOfField(field));
        return this.getFragmentIndicesForLangField(lang, field);
    }

    public IntList getFragmentIndicesForLangField(FieldDefinitions.LanguageGroup lang, String field) {
        if (this.languageGenerationNeedStates.get(lang.ordinal()) == GenerationState.NOT_GENERATED) {
            this.generateValuesForLang(lang);
        }
        IntList result = null;
        Map fragmentMap = (Map)this.fragmentsForLanguage.get(lang.ordinal());
        if (fragmentMap != null) {
            result = (IntList)fragmentMap.get(field);
        }
        if (result == null && (field.startsWith("col_text_tags_") || field.contains("cls_standards"))) {
            IntList additionalDataFragments;
            result = new IntArrayList();
            String textLang = lang.toString().toLowerCase();
            String langPostFix = "_" + textLang + "_lang";
            ArrayList<String> listOfFields = new ArrayList<String>(Arrays.asList("nb", "nn", "nt"));
            if (!field.contains("cls_standards")) {
                listOfFields.add("textvalues");
            }
            for (String value : listOfFields) {
                IntList tempList;
                Map fragments = (Map)this.fragmentsForLanguage.get(lang.ordinal());
                if (fragments == null || (tempList = (IntList)fragments.get(value + langPostFix)) == null) continue;
                result.addAll(tempList);
            }
            if (field.contains("cls_standards") && (additionalDataFragments = this.getFragmentIndicesForNonLangField(field)) != null) {
                result.addAll(additionalDataFragments);
            }
        }
        if (result == null && field.startsWith("textvalues")) {
            result = this.nonLanguageFragments.get("textvalues_exact");
        }
        if (result == null && field.startsWith("col_text_")) {
            String newField = HighlightUtils.removeLanguageGroup(field.replace("col_text_", "col_number_"));
            Map fragments = (Map)this.fragmentsForLanguage.get(lang.ordinal());
            if (fragments != null) {
                result = (IntList)fragments.get(newField);
            }
            if (result == null) {
                result = this.getFragmentIndicesForNonLangField("col_text_");
            }
        }
        return result;
    }

    public IntList getFragmentIndicesForNonLangField(String field) {
        if (!this.nonLanguageFragmentsGenerated) {
            this.generateNonLangValues();
        }
        return this.nonLanguageFragments.get(field);
    }

    private void generateValuesForLang(FieldDefinitions.LanguageGroup lang) {
        IntList langValueIndices = (IntList)this.languageIndices.get(lang.ordinal());
        if (langValueIndices == null) {
            return;
        }
        HashMap<String, IntList> fragmentsForLang = new HashMap<String, IntList>();
        String stringLang = lang.toString().toLowerCase();
        IntListIterator intListIterator = langValueIndices.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            HighlightingRequest.Fragment fragment = this.request.fragments.get(index);
            for (String field : fragment.fieldNames) {
                if (!field.endsWith(stringLang + "_lang")) continue;
                fragmentsForLang.computeIfAbsent(field, k -> new IntArrayList()).add(index);
            }
        }
        this.fragmentsForLanguage.put(lang.ordinal(), (Map<String, IntList>)fragmentsForLang);
        this.languageGenerationNeedStates.put(lang.ordinal(), GenerationState.GENERATED);
    }

    private void generateNonLangValues() {
        for (int index = 0; index < this.request.fragments.size(); ++index) {
            HighlightingRequest.Fragment fragment = this.request.fragments.get(index);
            if (fragment == null) continue;
            for (String field : fragment.fieldNames) {
                if (field.endsWith("_lang")) continue;
                this.nonLanguageFragments.computeIfAbsent(field, k -> new IntArrayList()).add(index);
            }
        }
        this.nonLanguageFragmentsGenerated = true;
    }

    private static enum GenerationState {
        NOT_GENERATED,
        GENERATED;

    }
}

