/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.highlighting;

import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQuery;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeight;
import de.cadenas.catalogsearch.lucene.search.ValueRangeQuery;
import de.cadenas.util.NumUtils;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.search.highlight.WeightedSpanTerm;
import org.apache.lucene.search.highlight.WeightedSpanTermExtractor;
import org.apache.lucene.util.NumericUtils;

public class HighlightingScorer
extends QueryScorer {
    private final String fieldName;
    private DoubleArrayList rangeList;
    private CharTermAttribute termAttr;
    private float rangeScore = 0.0f;

    public HighlightingScorer(Query query, String field) {
        super(query, field);
        this.fieldName = field;
    }

    private void addRange(double from, double to) {
        if (this.rangeList == null) {
            this.rangeList = new DoubleArrayList();
        }
        this.rangeList.add(from - 1.0E-5);
        this.rangeList.add(to + 1.0E-5);
    }

    @Override
    public TokenStream init(TokenStream tokenStream) throws IOException {
        TokenStream stream = super.init(tokenStream);
        this.termAttr = tokenStream.getAttribute(CharTermAttribute.class);
        return stream;
    }

    @Override
    public float getFragmentScore() {
        float baseScore = super.getFragmentScore();
        return baseScore + this.rangeScore;
    }

    @Override
    public void startFragment(TextFragment newFragment) {
        super.startFragment(newFragment);
        this.rangeScore = 0.0f;
    }

    @Override
    protected WeightedSpanTermExtractor newTermExtractor(String defaultField) {
        return new WeightedSpanTermExtractor(defaultField){

            @Override
            protected void extract(Query query, float boost, Map<String, WeightedSpanTerm> terms) throws IOException {
                if (query instanceof PSolQuery) {
                    LeafReaderContext context = this.getLeafContext();
                    IndexSearcher searcher = new IndexSearcher(context);
                    searcher.setQueryCache(null);
                    PSolWeight w = (PSolWeight)searcher.createWeight(query, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                    w.extractWeightedSpanTerms(context, HighlightingScorer.this.fieldName, terms, q -> {
                        try {
                            this.extract((Query)q, boost, terms);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                } else if (query.getClass().getName().contains("DoubleRange")) {
                    int sep;
                    int start;
                    String substr;
                    String field;
                    String data = query.toString();
                    int index = data.indexOf(58);
                    if (index > 0 && (field = data.substring(0, index)).equals(HighlightingScorer.this.fieldName) && (substr = data.substring(index + 1)).startsWith("<") && (start = substr.indexOf(91)) != -1 && (sep = substr.indexOf(58, start + 1)) != -1) {
                        String sLow = substr.substring(start + 1, sep);
                        double low = NumUtils.getNumeric(sLow);
                        double high = Double.POSITIVE_INFINITY;
                        int end = substr.indexOf(93, sep + 1);
                        if (end != -1) {
                            String sHigh = substr.substring(sep + 1, end);
                            high = NumUtils.getNumeric(sHigh);
                        }
                        HighlightingScorer.this.addRange(low, high);
                    }
                } else if (query instanceof ValueRangeQuery) {
                    ValueRangeQuery vrQuery = (ValueRangeQuery)query;
                    boolean fieldMatches = false;
                    int idx = vrQuery.field.indexOf(HighlightingScorer.this.fieldName);
                    if (idx == 0) {
                        if (vrQuery.field.length() == HighlightingScorer.this.fieldName.length()) {
                            fieldMatches = true;
                        } else if (vrQuery.field.charAt(HighlightingScorer.this.fieldName.length()) == '@') {
                            fieldMatches = true;
                        }
                    }
                    if (fieldMatches) {
                        HighlightingScorer.this.addRange(vrQuery.getMin(), vrQuery.getMax());
                    }
                } else if (query instanceof PointRangeQuery) {
                    PointRangeQuery rq = (PointRangeQuery)query;
                    if (rq.getField().equals(HighlightingScorer.this.fieldName) || rq.getField().equals("numbervalues")) {
                        byte[] lp = rq.getLowerPoint();
                        byte[] up = rq.getUpperPoint();
                        double low = NumericUtils.sortableLongToDouble(NumericUtils.sortableBytesToLong(lp, 0));
                        double high = NumericUtils.sortableLongToDouble(NumericUtils.sortableBytesToLong(up, 0));
                        HighlightingScorer.this.addRange(low, high);
                    }
                } else {
                    super.extract(query, boost, terms);
                }
            }
        };
    }

    @Override
    public float getTokenScore() {
        float score = super.getTokenScore();
        if (score == 0.0f && this.rangeList != null && !this.rangeList.isEmpty() && this.termAttr != null) {
            String termText = this.termAttr.toString();
            double value = NumUtils.getNumeric(termText);
            if (Double.isNaN(value)) {
                value = NumUtils.parseInch(termText);
            }
            if (!Double.isNaN(value)) {
                for (int i = 0; i < this.rangeList.size(); i += 2) {
                    if (!(value >= this.rangeList.getDouble(i)) || !(value <= this.rangeList.getDouble(i + 1))) continue;
                    score = 1.0f;
                    this.rangeScore += 1.0f;
                    break;
                }
            }
        }
        return score;
    }
}

