/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.highlighting;

import de.cadenas.catalogsearch.lucene.highlighting.HighlightTokenContainer;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightUtils;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.IHighlightingInfoReceiver;
import de.cadenas.catalogsearch.lucene.highlighting.QueryDecomposerFactory;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemOr;
import java.util.Arrays;
import java.util.List;

public class OrHighlightingNode
extends HighlightingNode {
    private final PSolQueryItemOr orItem;
    boolean hasPhraseHighlightingNode = false;
    boolean hasStrictHighlightingNode = false;
    boolean hasNumericalPhraseQuery = false;
    private static final double MAX_LENGTH_FACTOR = 1.5;

    public OrHighlightingNode(PSolQueryItemOr orItem, HighlightingNode parent) {
        super(orItem.getSearchField(), "", parent);
        this.orItem = orItem;
    }

    @Override
    public void transmitNodes(IHighlightingInfoReceiver receiver) {
        if (this.parent == null) {
            return;
        }
        for (PSolQueryItem pSolQueryItem : this.orItem.getItemList()) {
            QueryDecomposerFactory.decompose(pSolQueryItem, receiver, (HighlightingNode)this);
        }
        if (this.children.stream().anyMatch(node -> node.highlightPositions != null && !node.highlightPositions.isEmpty())) {
            for (HighlightingNode child : this.children) {
                if (child.highlightPositions == null || child.highlightPositions.isEmpty()) continue;
                HighlightUtils.mergeHighlightingPositions(this.highlightPositions, child.highlightPositions);
            }
        }
        receiver.receiveNode(this);
    }

    @Override
    public boolean equals(HighlightingNode other) {
        if (other instanceof OrHighlightingNode) {
            OrHighlightingNode orOther = (OrHighlightingNode)other;
            return this.orItem.toString().equals(orOther.orItem.toString());
        }
        return false;
    }

    @Override
    public void resolveHighlightPositions() {
        super.resolveHighlightPositions();
        this.highlighted = !this.highlightPositions.isEmpty();
    }

    @Override
    public void analyseFragmentStream(HighlightTokenContainer toolBox, HighlightTokenContainer stemmedSearchTerms, int[] previousIndexBuffer) {
        if (this.hasNumericalPhraseQuery && this.hasPhraseHighlightingNode && this.getQueryLength() == -1) {
            this.specialCaseHighlighting(toolBox, stemmedSearchTerms, previousIndexBuffer);
        } else {
            this.standardHighlight(toolBox, stemmedSearchTerms, previousIndexBuffer);
        }
    }

    private void specialCaseHighlighting(HighlightTokenContainer fragmentTokenContainer, HighlightTokenContainer stemmedSearchTerms, int[] previousIndexBuffer) {
        for (HighlightTokenContainer.HighlightToken fragmentToken : fragmentTokenContainer.tokens) {
            String termWord = fragmentToken.term();
            boolean wordIsContainedInAll = true;
            for (HighlightTokenContainer.HighlightToken searchToken : stemmedSearchTerms.tokens) {
                String searchTerm = searchToken.term();
                wordIsContainedInAll = searchTerm.contains(termWord) && wordIsContainedInAll;
            }
            if (!wordIsContainedInAll) continue;
            previousIndexBuffer[0] = termWord.length();
            this.setQueryLength(termWord.length());
            return;
        }
    }

    @Override
    public void standardHighlight(HighlightTokenContainer fragmentTokenContainer, HighlightTokenContainer stemmedSearchTerms, int[] highlightingBuffer) {
        List<HighlightTokenContainer.HighlightToken> fragmentTokens = fragmentTokenContainer.tokens;
        List<HighlightTokenContainer.HighlightToken> searchTokens = stemmedSearchTerms.tokens;
        for (HighlightTokenContainer.HighlightToken fragmentToken : fragmentTokens) {
            boolean isFirstToken = fragmentToken.startOffset() == 0;
            String currentTerm = fragmentToken.term();
            if (fragmentToken.termIsNumeric()) continue;
            for (HighlightTokenContainer.HighlightToken searchToken : searchTokens) {
                String term = searchToken.term();
                if (this.getQueryLength() - 2 > term.length() && !this.hasPhraseHighlightingNode || !term.equals(currentTerm) || highlightingBuffer[fragmentToken.startOffset()] >= fragmentToken.endOffset()) continue;
                highlightingBuffer[fragmentToken.startOffset()] = fragmentToken.endOffset();
                break;
            }
            if (!this.hasStrictHighlightingNode || isFirstToken) continue;
            Arrays.fill(highlightingBuffer, -1);
            return;
        }
        if (this.queryLength < 4 && Arrays.stream(highlightingBuffer).anyMatch(k -> k != -1)) {
            for (int i = 0; i < highlightingBuffer.length; ++i) {
                if (!((double)(highlightingBuffer[i] - i) > (double)this.queryLength * 1.5)) continue;
                highlightingBuffer[i] = -1;
            }
        }
    }

    @Override
    public int[] findHighlightPositions(HighlightTokenContainer searchTerms, String field, String fragmentValue, int fragmentValueLength) {
        int[] highlightingBuffer = super.findHighlightPositions(searchTerms, field, fragmentValue, fragmentValueLength);
        int stemmedSearchTermsSize = searchTerms.tokens.size();
        if (this.hasPhraseHighlightingNode) {
            HighlightUtils.mergeAdjacentSearchSpans(highlightingBuffer, stemmedSearchTermsSize, this);
            this.adjustHighlightingBuffer(stemmedSearchTermsSize, highlightingBuffer);
        }
        return highlightingBuffer;
    }

    private void adjustHighlightingBuffer(int stemmedSearchTermsSize, int[] previousBuffer) {
        if (this.getQueryLength() != -1) {
            for (int i = 0; i < previousBuffer.length; ++i) {
                if (previousBuffer[i] == -1) continue;
                int termLength = previousBuffer[i] - i;
                int minLength = this.getQueryLength();
                int maxLength = this.getQueryLength() + stemmedSearchTermsSize;
                if (termLength >= minLength && termLength <= maxLength) continue;
                previousBuffer[i] = -1;
            }
        }
    }
}

