/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.highlighting;

import de.cadenas.catalogsearch.lucene.highlighting.HighlightUtils;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.IHighlightingInfoReceiver;
import de.cadenas.catalogsearch.lucene.highlighting.OrHighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.QueryDecomposerFactory;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQuery;

public class PSolHighlightingNode
extends HighlightingNode {
    private final PSolQuery pSolQuery;
    private boolean useBoolLogic = false;

    public PSolHighlightingNode(PSolQuery psolQuery, HighlightingNode parent) {
        this.setParent(parent);
        this.pSolQuery = psolQuery;
    }

    @Override
    public void transmitNodes(IHighlightingInfoReceiver receiver) {
        this.pSolQuery.getQueryItems().forEach(pSolQueryItem -> QueryDecomposerFactory.decompose(pSolQueryItem, receiver, (HighlightingNode)this));
        if (this.parent == null) {
            return;
        }
        HighlightUtils.collectMisplacedHighlighting(this);
        this.useBoolLogic = receiver.isBoolLogicActivated();
        for (HighlightingNode child : this.children) {
            HighlightUtils.mergeHighlightingPositions(this.highlightPositions, child.highlightPositions);
        }
        receiver.receiveNode(this);
    }

    @Override
    public void resolveHighlightPositions() {
        super.resolveHighlightPositions();
        boolean bl = !this.children.isEmpty() && (this.useBoolLogic && !this.children.stream().allMatch(child -> child instanceof OrHighlightingNode) && this.children.size() > 1 ? this.children.stream().allMatch(HighlightingNode::isHighlighted) : !this.highlightPositions.isEmpty()) ? true : (this.highlighted = false);
        if (!this.highlighted) {
            this.highlightPositions.clear();
        }
    }
}

