/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.highlighting;

import de.cadenas.catalogsearch.lucene.highlighting.AutomatonHighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.BooleanHighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.DocValuesFieldExistsHighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.ExactHighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.IHighlightingInfoReceiver;
import de.cadenas.catalogsearch.lucene.highlighting.ItemDocHighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.OrHighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.PSolHighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.PhraseHighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.StrictHighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.TermHighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.TermItemHighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.TermItemListHighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.ValueRangeHighlightingNode;
import de.cadenas.catalogsearch.lucene.queryparser.QueryWrapper;
import de.cadenas.catalogsearch.lucene.queryparser.TraceQuery;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQuery;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemAutomaton;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemBoost;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemDoc;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemExact;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemOr;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemPhrase;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemTerm;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemTermList;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemWrapper;
import de.cadenas.catalogsearch.lucene.search.CatalogBoostQuery;
import de.cadenas.catalogsearch.lucene.search.ValueRangeQuery;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public final class QueryDecomposerFactory {
    public static void decompose(Query query, IHighlightingInfoReceiver receiver, HighlightingNode parent) {
        if (query instanceof BooleanQuery) {
            BooleanQuery bq = (BooleanQuery)query;
            new BooleanHighlightingNode(bq, parent).transmitNodes(receiver);
        } else if (query instanceof PSolQuery) {
            PSolQuery pq = (PSolQuery)query;
            new PSolHighlightingNode(pq, parent).transmitNodes(receiver);
        } else if (query instanceof ValueRangeQuery) {
            ValueRangeQuery vq = (ValueRangeQuery)query;
            new ValueRangeHighlightingNode(vq, parent).transmitNodes(receiver);
        } else if (query instanceof TermQuery) {
            TermQuery tq = (TermQuery)query;
            new TermHighlightingNode(tq, parent).transmitNodes(receiver);
        } else if (query instanceof BoostQuery) {
            BoostQuery bq = (BoostQuery)query;
            QueryDecomposerFactory.decompose(bq.getQuery(), receiver, parent);
        } else if (query instanceof CatalogBoostQuery) {
            CatalogBoostQuery cbq = (CatalogBoostQuery)query;
            QueryDecomposerFactory.decompose(cbq.getQuery(), receiver, parent);
        } else if (query instanceof QueryWrapper) {
            QueryWrapper qw = (QueryWrapper)query;
            QueryDecomposerFactory.decompose(qw.getQuery(), receiver, parent);
        } else if (query instanceof TraceQuery) {
            TraceQuery tq = (TraceQuery)query;
            QueryDecomposerFactory.decompose(tq.getQuery(), receiver, parent);
        } else if (query instanceof DocValuesFieldExistsQuery) {
            DocValuesFieldExistsQuery dvq = (DocValuesFieldExistsQuery)query;
            new DocValuesFieldExistsHighlightingNode(dvq, parent).transmitNodes(receiver);
        } else {
            throw new NotImplementedException();
        }
    }

    public static void decompose(PSolQueryItem queryItem, IHighlightingInfoReceiver receiver, HighlightingNode parent) {
        if (queryItem instanceof PSolQueryItemBoost) {
            PSolQueryItemBoost bItem = (PSolQueryItemBoost)queryItem;
            QueryDecomposerFactory.decompose(bItem.getChildItem(), receiver, parent);
        } else if (queryItem instanceof PSolQueryItemWrapper) {
            PSolQueryItemWrapper itemWrapper = (PSolQueryItemWrapper)queryItem;
            QueryDecomposerFactory.decompose(itemWrapper.getQuery(), receiver, parent);
        } else if (queryItem instanceof PSolQueryItemAutomaton) {
            PSolQueryItemAutomaton item = (PSolQueryItemAutomaton)queryItem;
            new AutomatonHighlightingNode(item, parent).transmitNodes(receiver);
        } else if (queryItem instanceof PSolQueryItemDoc) {
            PSolQueryItemDoc docItem = (PSolQueryItemDoc)queryItem;
            new ItemDocHighlightingNode(docItem, parent).transmitNodes(receiver);
        } else if (queryItem instanceof PSolQueryItemExact) {
            PSolQueryItemExact exactItem = (PSolQueryItemExact)queryItem;
            new ExactHighlightingNode(exactItem, parent).transmitNodes(receiver);
        } else if (queryItem instanceof PSolQueryItemOr) {
            PSolQueryItemOr orItem = (PSolQueryItemOr)queryItem;
            new OrHighlightingNode(orItem, parent).transmitNodes(receiver);
        } else if (queryItem instanceof PSolQueryItemPhrase) {
            PSolQueryItemPhrase itemPhrase = (PSolQueryItemPhrase)queryItem;
            if (itemPhrase.isStrict()) {
                new StrictHighlightingNode(itemPhrase, parent).transmitNodes(receiver);
            } else {
                new PhraseHighlightingNode(itemPhrase, parent).transmitNodes(receiver);
            }
        } else if (queryItem instanceof PSolQueryItemTerm) {
            PSolQueryItemTerm itemTerm = (PSolQueryItemTerm)queryItem;
            new TermItemHighlightingNode(itemTerm, parent).transmitNodes(receiver);
        } else if (queryItem instanceof PSolQueryItemTermList) {
            PSolQueryItemTermList itemTermList = (PSolQueryItemTermList)queryItem;
            new TermItemListHighlightingNode(itemTermList, parent).transmitNodes(receiver);
        } else {
            throw new NotImplementedException();
        }
    }
}

