/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.highlighting;

import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.TokenGroup;

public class TermCountHTMLFormatter
implements Formatter {
    private int numTerms = 0;
    private final String preTag;
    private final String postTag;
    private String reversePreTag = null;
    private String reversePostTag = null;
    private boolean reverseMode = false;

    private String getPreTag() {
        if (!this.reverseMode) {
            return this.preTag;
        }
        if (this.reversePreTag == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.preTag);
            this.reversePreTag = sb.reverse().toString();
        }
        return this.reversePreTag;
    }

    private String getPostTag() {
        if (!this.reverseMode) {
            return this.postTag;
        }
        if (this.reversePostTag == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.postTag);
            this.reversePostTag = sb.reverse().toString();
        }
        return this.reversePostTag;
    }

    public TermCountHTMLFormatter(String preTag, String postTag) {
        this.preTag = preTag;
        this.postTag = postTag;
    }

    public void setReverseMode(boolean reverse) {
        this.reverseMode = reverse;
    }

    @Override
    public String highlightTerm(String originalText, TokenGroup tokenGroup) {
        if (tokenGroup.getTotalScore() > 0.0f) {
            ++this.numTerms;
        } else {
            return originalText;
        }
        String pre = this.getPreTag();
        String post = this.getPostTag();
        StringBuilder sb = new StringBuilder(pre.length() + originalText.length() + post.length());
        sb.append(this.reverseMode ? post : pre);
        sb.append(originalText);
        sb.append(this.reverseMode ? pre : post);
        return sb.toString();
    }

    public void reset() {
        this.numTerms = 0;
        this.reverseMode = false;
    }

    public int getNumTerms() {
        return this.numTerms;
    }
}

