/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.highlighting;

import de.cadenas.catalogsearch.lucene.highlighting.HighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.IHighlightingInfoReceiver;
import de.cadenas.catalogsearch.lucene.highlighting.OrHighlightingNode;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.TermQuery;

public class TermHighlightingNode
extends HighlightingNode {
    private final OrHighlightingNode parentRef;

    public TermHighlightingNode(Term term, HighlightingNode parent) {
        super(term.field(), term.text(), parent);
        OrHighlightingNode pRef;
        this.queryLength = term.text().length();
        this.parentRef = parent instanceof OrHighlightingNode ? (pRef = (OrHighlightingNode)parent) : null;
    }

    public TermHighlightingNode(TermQuery termQuery, HighlightingNode parent) {
        super(termQuery.getTerm().field(), termQuery.getTerm().text(), parent);
        OrHighlightingNode pRef;
        this.queryLength = termQuery.getTerm().text().length();
        this.parentRef = parent instanceof OrHighlightingNode ? (pRef = (OrHighlightingNode)parent) : null;
    }

    public void setup() {
        if (this.field.startsWith("col_text_tags")) {
            if (this.parentRef != null) {
                this.parentRef.hasStrictHighlightingNode = false;
            }
            this.parent.occur = BooleanClause.Occur.SHOULD;
            this.isTagCloud = true;
            this.parent.field = this.field;
        }
        this.parent.addFieldValue(this.field, this.value);
    }

    @Override
    public void transmitNodes(IHighlightingInfoReceiver receiver) {
        this.setup();
        super.transmitNodes(receiver);
    }
}

