/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.index;

import com.google.flatbuffers.StringVector;
import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.analysis.FieldAwareAnalyzer;
import de.cadenas.catalogsearch.lucene.fields.PSolTextField;
import de.cadenas.catalogsearch.lucene.index.ErpConfiguration;
import de.cadenas.catalogsearch.lucene.index.OcrConfig;
import de.cadenas.catalogsearch.lucene.index.PSolMergePolicy;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.DocumentData;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.FacetDataItem;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.KeyAndTableRowColumnData;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.NumericData;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.NumericValueRangeData;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.NumericValueRangeDataItem;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.ProjectData;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.StringData;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.TableRowColumnData;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.TableRowData;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.TextValueData;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.TextValueDataHashItem;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.TextValueRangeData;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.TranslatedValueRangeData;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.TranslatedValueRangeDataItem;
import de.cadenas.catalogsearch.lucene.index.valuerange.ValueRangeData;
import de.cadenas.catalogsearch.lucene.io.DocIdIndexBuilder;
import de.cadenas.catalogsearch.lucene.io.TreePathIndexBuilder;
import de.cadenas.util.NumUtils;
import de.cadenas.util.PDataStream;
import de.cadenas.util.PFile;
import de.cadenas.util.PLogger;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.DoubleRange;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetField;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.compress.LZ4;
import org.apache.tika.Tika;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.WriteOutContentHandler;
import org.xml.sax.ContentHandler;

public class CatalogIndexer {
    private static final PLogger logger = new PLogger(CatalogIndexer.class.getSimpleName());
    private final Path _indexPath;
    private final FieldDefinitions.IndexType _indexType;
    private final IndexWriterConfig.OpenMode _openMode;
    private final int _maxDocsPerSegment;
    private final int _maxDeletedDocsPerIndex;
    private IndexWriter _indexWriter;
    private DocIdIndexBuilder _docIdIndex;
    private TreePathIndexBuilder _treePathIndex;
    private final FacetsConfig _facetsConfig;
    private final String _fieldNameTextValuesDefault;
    private final String _defaultLanguageName;
    private final String _defaultLanguageFieldExtension;
    private final FieldNameProvider _nameProvider;

    public CatalogIndexer(String absolutePath, FieldDefinitions.IndexType indexType, IndexWriterConfig.OpenMode openMode, int maxDocsPerSegment, int maxDeletedDocsPerIndex) throws Exception {
        this._indexPath = Paths.get(absolutePath, new String[0]);
        this._indexType = indexType;
        this._openMode = openMode;
        this._maxDocsPerSegment = maxDocsPerSegment;
        this._maxDeletedDocsPerIndex = maxDeletedDocsPerIndex;
        this._facetsConfig = FieldDefinitions.getFacetsConfig();
        this._defaultLanguageName = "_english";
        this._defaultLanguageFieldExtension = "_english_lang";
        this._fieldNameTextValuesDefault = "textvalues" + this._defaultLanguageName + "_lang";
        ErpConfiguration _erpConfig = ErpConfiguration.getInstance();
        this._nameProvider = new FieldNameProvider(_erpConfig);
        this.init();
    }

    public void addData(ProjectData data, TableRowData row) throws Exception {
        Document doc = new Document();
        try {
            this.fillDocument(doc, data, row);
            doc = this.removeDuplicates(doc);
            doc = this.fillDocumentDocValues(doc, data, row);
            this.evaluateAppendMode(doc);
            this._indexWriter.addDocument(doc);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            doc = null;
        }
    }

    Document removeDuplicates(Document doc) {
        Document result = new Document();
        HashSet<PSolTextField> textSet = new HashSet<PSolTextField>();
        HashSet<PSolNumberField> numSet = new HashSet<PSolNumberField>();
        for (IndexableField field : doc) {
            if (field instanceof PSolTextField) {
                PSolTextField textField = (PSolTextField)field;
                if (!textSet.add(textField)) continue;
                result.add(textField);
                continue;
            }
            if (field instanceof PSolNumberField) {
                PSolNumberField numField = (PSolNumberField)field;
                if (!numSet.add(numField)) continue;
                result.add(numField);
                continue;
            }
            result.add(field);
        }
        return result;
    }

    private void evaluateAppendMode(Document doc) {
        HashSet<String> nameList = new HashSet<String>();
        for (IndexableField field : doc) {
            if (!(field instanceof PSolTextField)) continue;
            PSolTextField textField = (PSolTextField)field;
            String fieldName = textField.name();
            if (nameList.contains(fieldName)) {
                textField.setAppendMode(true);
                continue;
            }
            nameList.add(fieldName);
        }
    }

    public void removeData(String catalogName, String path, int lineId) throws Exception {
        Query delQuery;
        Query pathQuery = path.indexOf(42) != -1 ? new WildcardQuery(new Term("path", catalogName + "/" + path)) : new TermQuery(new Term("path", catalogName + "/" + path));
        if (lineId == -1) {
            delQuery = pathQuery;
        } else {
            Query lineIdQuery = IntPoint.newExactQuery("lineid", lineId);
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(pathQuery, BooleanClause.Occur.MUST);
            builder.add(lineIdQuery, BooleanClause.Occur.MUST);
            delQuery = builder.build();
        }
        this._indexWriter.deleteDocuments(delQuery);
        this._docIdIndex.removeData(catalogName, path, lineId);
    }

    public void commit() throws Exception {
        this._indexWriter.commit();
    }

    public int numDocs() {
        return this._indexWriter.getDocStats().numDocs;
    }

    public synchronized void close() throws Exception {
        if (this._indexWriter.isOpen()) {
            this._docIdIndex.storeValueRangeData(this._indexWriter);
            int numDocs = this._indexWriter.getDocStats().numDocs;
            if (numDocs < this._maxDocsPerSegment) {
                this._indexWriter.forceMerge(1, true);
            } else if (this._openMode != IndexWriterConfig.OpenMode.CREATE) {
                this._indexWriter.forceMergeDeletes(true);
            }
        }
        this._indexWriter.close();
        FSDirectory indexDirectory = FSDirectory.open(this._indexPath);
        try (DirectoryReader reader = DirectoryReader.open(indexDirectory);){
            Path path = Paths.get(this._indexPath.toString(), "docids.idx");
            this._docIdIndex.buildIndex(reader, path.toString());
            Path treepath = Paths.get(this._indexPath.toString(), "treepath.idx");
            this._treePathIndex.buildIndex(reader, treepath.toString());
        }
    }

    private void init() throws Exception {
        boolean updateMode;
        FSDirectory directory = FSDirectory.open(this._indexPath);
        FieldAwareAnalyzer analyzer = new FieldAwareAnalyzer(true);
        IndexWriterConfig config = new IndexWriterConfig(analyzer);
        config.setOpenMode(this._openMode);
        this._treePathIndex = new TreePathIndexBuilder();
        boolean bl = updateMode = this._openMode != IndexWriterConfig.OpenMode.CREATE;
        if (updateMode) {
            Path path = Paths.get(this._indexPath.toString(), "docids.idx");
            this._docIdIndex = new DocIdIndexBuilder(this._indexType == FieldDefinitions.IndexType.LinkDb, path.toString());
            try (DirectoryReader reader = DirectoryReader.open(directory);){
                this._docIdIndex.initBuilder4Update(reader);
            }
            catch (Exception ignored) {
                this._docIdIndex = new DocIdIndexBuilder(this._indexType == FieldDefinitions.IndexType.LinkDb);
            }
            Path treepath = Paths.get(this._indexPath.toString(), "treepath.idx");
            int maxPersistentId = this._treePathIndex.readTreepathIndex(treepath.toString());
            this._docIdIndex.setMinimumLastId(maxPersistentId + 1);
        } else {
            this._docIdIndex = new DocIdIndexBuilder(this._indexType == FieldDefinitions.IndexType.LinkDb);
        }
        ConcurrentMergeScheduler scheduler = new ConcurrentMergeScheduler();
        scheduler.setDefaultMaxMergesAndThreads(false);
        config.setMergeScheduler(scheduler);
        config.setUseCompoundFile(false);
        config.setRAMBufferSizeMB(48.0);
        PSolMergePolicy mergePolicy = new PSolMergePolicy();
        mergePolicy.setMaxNumDeleteDocuments(this._maxDeletedDocsPerIndex);
        mergePolicy.setMaxMergeDocs(this._maxDocsPerSegment);
        config.setMergePolicy(mergePolicy);
        this._indexWriter = new IndexWriter(directory, config);
    }

    private void handleValueRangeData(String fieldName, String columnName, TableRowColumnData column, Document doc, int numRangeLength, Function<Integer, NumericValueRangeDataItem> listFunc, FieldDefinitions.NumberFlag f, int physicalQuantity) {
        for (int n = 0; n < numRangeLength; ++n) {
            NumericValueRangeDataItem numItem = listFunc.apply(n);
            int mask = 0;
            if (numItem.step() == 0.0) {
                mask = 16;
            }
            double[] min = new double[]{numItem.min(), NumUtils.combine(numItem.step(), f.ordinal() | mask, physicalQuantity)};
            double[] max = new double[]{numItem.max(), NumUtils.combine(numItem.step(), f.ordinal() | mask, physicalQuantity)};
            if ((column.flags() & 1) != 0) {
                doc.add(new PSolNumberField(fieldName, min, max));
            }
            if ((column.flags() & 2) == 0) continue;
            this._nameProvider.createNumericFields(columnName, name -> doc.add(new PSolNumberField((String)name, min, max)));
        }
    }

    private void addDoubleField(Document doc, String fieldName, double value, double convertedValue, int physicalQuantity) {
        FieldDefinitions.NumberFlag flag = value == convertedValue ? FieldDefinitions.NumberFlag.OriginalMatching : FieldDefinitions.NumberFlag.Original;
        double[] val = new double[]{value, NumUtils.combine(0.0f, flag.ordinal(), physicalQuantity)};
        doc.add(new PSolNumberField(fieldName, val, val));
        if (flag != FieldDefinitions.NumberFlag.OriginalMatching) {
            double[] convertedVal = new double[]{convertedValue, NumUtils.combine(0.0f, FieldDefinitions.NumberFlag.Converted.ordinal(), physicalQuantity)};
            doc.add(new PSolNumberField(fieldName, convertedVal, convertedVal));
        }
    }

    private void fillDocument(Document doc, ProjectData data, TableRowData row) throws Exception {
        String assType;
        String prjType;
        if (data == null || data.catalogName() == null || data.catalogPath() == null || data.path() == null) {
            throw new Exception("Missing required value");
        }
        int persistentId = -1;
        if (row != null) {
            int lineId = row.lineId();
            doc.add(new IntPoint("lineid", lineId));
            int lineSubId = row.lineSubId();
            doc.add(new IntPoint("linesubid", lineSubId));
            String varset = row.varset();
            persistentId = this._docIdIndex.addLineData(data.catalogPath(), data.path(), lineId, lineSubId, varset);
            doc.add(new StoredField("persid", persistentId));
        }
        boolean hasVisiblePath = this.indexPathData(data, row, doc, persistentId);
        doc.add(new StringField("catalog", data.catalogName(), Field.Store.NO));
        String type = hasVisiblePath ? "psol-row" : "psol-hidden-row";
        doc.add(new StringField("type", type, Field.Store.NO));
        this.fillDocumentWithTextValueDataField(doc, "nn", data.nn(), 33);
        this.fillDocumentWithTextValueDataField(doc, "nt", data.nt(), 33);
        this.fillDocumentWithTextValueDataField(doc, "keywords", data.keywords(), 33);
        String prjDate = data.prjDate();
        if (prjDate != null && !prjDate.isEmpty()) {
            doc.add(new StringField("prjdate", prjDate, Field.Store.NO));
        }
        if ((prjType = data.prjType()) != null && !prjType.isEmpty()) {
            doc.add(new StringField("prjtype", prjType.toLowerCase(), Field.Store.NO));
        }
        if ((assType = data.assType()) != null && !assType.isEmpty()) {
            doc.add(new StringField("asstype", assType.toLowerCase(), Field.Store.NO));
        }
        this.fillDocumentWithTextValueDataField(doc, "pathtranslated", data.pathTranslated(), 33);
        if (row != null) {
            int c;
            long prio;
            String typeCode;
            this.fillDocumentWithTextValueDataField(doc, "nb", row.nb(), 33);
            this.fillDocumentWithTextValueDataField(doc, "keywords", row.keywords(), 33);
            String orderNumber = row.orderNumber();
            if (orderNumber != null && !orderNumber.isEmpty()) {
                doc.add(new PSolTextField("ordernumber", orderNumber, Field.Store.NO));
            }
            if ((typeCode = row.typeCode()) != null && !typeCode.isEmpty()) {
                doc.add(new PSolTextField("typecode", typeCode, Field.Store.NO));
            }
            if ((prio = row.prio()) != 0L) {
                doc.add(new NumericDocValuesField("prio", prio));
            }
            int percentU = row.percentU();
            int percentO = row.percentO();
            if (percentU != -1 && percentO > 0) {
                doc.add(new IntPoint("lic_low", percentU));
                doc.add(new IntPoint("lic_up", percentO));
            }
            int topoAnyValuesLength = row.topoAnyValuesLength();
            for (int i = 0; i < topoAnyValuesLength; ++i) {
                double d = row.topoAnyValues(i);
                if (Double.isNaN(d)) continue;
                double[] val = new double[]{d};
                doc.add(new PSolNumberField("topoanyvalue", val, val));
            }
            ErpConfiguration erpConfig = ErpConfiguration.getInstance();
            if (erpConfig.isValid()) {
                int erpVisibleGroupsLength = row.erpVisibleGroupsLength();
                for (int r = 0; r < erpVisibleGroupsLength; ++r) {
                    String erpGroup = row.erpVisibleGroups(r);
                    String fieldName = erpGroup + "_erp_flag";
                    doc.add(new StringField(fieldName, "visible", Field.Store.NO));
                }
                int erpPreferredLineGroupsLength = row.erpPreferredLineGroupsLength();
                for (int r = 0; r < erpPreferredLineGroupsLength; ++r) {
                    String erpGroup = row.erpPreferredLineGroups(r);
                    String fieldName = erpGroup + "_erp_flag";
                    doc.add(new StringField(fieldName, "preferred", Field.Store.NO));
                }
                int erpStateLength = row.erpStatesLength();
                for (int r = 0; r < erpStateLength; ++r) {
                    String state = row.erpStates(r);
                    doc.add(new StringField("erp_state", state, Field.Store.NO));
                    doc.add(new SortedSetDocValuesFacetField("facet_erpstate", state));
                }
            }
            HashMap<String, de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.ValueRangeData> prjVrData = new HashMap<String, de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.ValueRangeData>();
            int columnsLength = row.columnsLength();
            block22: for (int c2 = 0; c2 < columnsLength; ++c2) {
                TableRowColumnData column = row.columns(c2);
                String columnName = column.name();
                byte dataType = column.dataType();
                switch (dataType) {
                    case 3: {
                        String fieldName = FieldDefinitions.getIndexFieldNameForVariable(columnName, false);
                        this.fillDocumentWithTextValueDataField(doc, fieldName, (TextValueData)column.data(new TextValueData()), column.flags());
                        continue block22;
                    }
                    case 1: {
                        String fieldName = FieldDefinitions.getIndexFieldNameForVariable(columnName, false);
                        this.fillDocumentWithTextValue(doc, fieldName, ((StringData)column.data(new StringData())).value(), column.flags());
                        continue block22;
                    }
                    case 2: {
                        NumericData numericData;
                        if ((column.flags() & 3) == 0 || (numericData = (NumericData)column.data(new NumericData())) == null) continue block22;
                        String fieldName = FieldDefinitions.getIndexFieldNameForVariable(columnName, true);
                        double val = numericData.value();
                        double convertedVal = numericData.convertedValue();
                        if ((column.flags() & 1) != 0) {
                            this.addDoubleField(doc, fieldName, val, convertedVal, numericData.physicalQuantity());
                        }
                        if ((column.flags() & 2) == 0) continue block22;
                        this._nameProvider.createNumericFields(columnName, name -> this.addDoubleField(doc, (String)name, val, convertedVal, numericData.physicalQuantity()));
                        continue block22;
                    }
                    case 4: {
                        String fieldName;
                        de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.ValueRangeData vrData = (de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.ValueRangeData)column.data(new de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.ValueRangeData());
                        if (vrData == null) continue block22;
                        prjVrData.put(columnName, vrData);
                        switch (vrData.dataType()) {
                            case 1: {
                                fieldName = FieldDefinitions.getIndexFieldNameForVariable(columnName, false);
                                this.fillDocumentWithValueRangeData(doc, fieldName, ((TextValueRangeData)vrData.data(new TextValueRangeData())).valueVector(), column.flags());
                                break;
                            }
                            case 2: {
                                fieldName = FieldDefinitions.getIndexFieldNameForVariable(columnName, false);
                                this.fillDocumentWithValueRangeData(doc, fieldName, (TranslatedValueRangeData)vrData.data(new TranslatedValueRangeData()), column.flags());
                                break;
                            }
                            case 3: {
                                fieldName = FieldDefinitions.getIndexFieldNameForVariable(columnName, true);
                                NumericValueRangeData numRange = (NumericValueRangeData)vrData.data(new NumericValueRangeData());
                                int convLength = numRange.convertedValueLength();
                                FieldDefinitions.NumberFlag flag = convLength > 0 ? FieldDefinitions.NumberFlag.Original : FieldDefinitions.NumberFlag.OriginalMatching;
                                this.handleValueRangeData(fieldName, columnName, column, doc, numRange.valueLength(), numRange::value, flag, numRange.physicalQuantity());
                                if (convLength <= 0) break;
                                this.handleValueRangeData(fieldName, columnName, column, doc, convLength, numRange::convertedValue, FieldDefinitions.NumberFlag.Converted, numRange.physicalQuantity());
                            }
                        }
                        continue block22;
                    }
                }
            }
            if (!prjVrData.isEmpty()) {
                ByteBuffersDataOutput stream = new ByteBuffersDataOutput();
                try {
                    stream.writeInt(prjVrData.size());
                    for (Map.Entry item : prjVrData.entrySet()) {
                        stream.writeString((String)item.getKey());
                        ValueRangeData.storeToStream(stream, (de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.ValueRangeData)item.getValue());
                    }
                    byte[] rawData = stream.toArrayCopy();
                    stream = new ByteBuffersDataOutput();
                    stream.writeVInt(rawData.length);
                    LZ4.compress(rawData, 0, rawData.length, stream, new LZ4.FastCompressionHashTable());
                    rawData = stream.toArrayCopy();
                    this._docIdIndex.setValueRangeData(persistentId, rawData);
                }
                catch (IOException rawData) {
                    // empty catch block
                }
            }
            int classIdsLength = row.classIdsLength();
            for (c = 0; c < classIdsLength; ++c) {
                String s = row.classIds(c);
                doc.add(new PSolTextField("classid", s, Field.Store.NO));
            }
            for (c = 0; c < row.clsSystemShortDescLength(); ++c) {
                this.fillDocumentWithTextValueDataField(doc, "textvalues", row.clsSystemShortDesc(c), 34);
            }
            for (c = 0; c < row.clsSystemDescLength(); ++c) {
                this.fillDocumentWithTextValueDataField(doc, "textvalues", row.clsSystemDesc(c), 34);
            }
            int clsSysLen = row.clsSystemColumnsLength();
            for (int c3 = 0; c3 < clsSysLen; ++c3) {
                KeyAndTableRowColumnData kdata = row.clsSystemColumns(c3);
                String eClass = kdata.key();
                int valueLen = kdata.valueLength();
                block28: for (int v = 0; v < valueLen; ++v) {
                    TableRowColumnData column = kdata.value(v);
                    byte dataType = column.dataType();
                    switch (dataType) {
                        case 3: {
                            String fieldName = FieldDefinitions.getIndexFieldNameForEClassVariable(eClass, column.name(), false);
                            this.fillDocumentWithTextValueDataField(doc, fieldName, (TextValueData)column.data(new TextValueData()), 1);
                            continue block28;
                        }
                        case 1: {
                            String fieldName = FieldDefinitions.getIndexFieldNameForEClassVariable(eClass, column.name(), false);
                            this.fillDocumentWithTextValue(doc, fieldName, ((StringData)column.data(new StringData())).value(), 3);
                            continue block28;
                        }
                        case 2: {
                            String fieldName = FieldDefinitions.getIndexFieldNameForEClassVariable(eClass, column.name(), true);
                            NumericData numData = (NumericData)column.data(new NumericData());
                            if (numData == null) continue block28;
                            double val = numData.value();
                            double convertedVal = numData.convertedValue();
                            this.addDoubleField(doc, fieldName, val, convertedVal, numData.physicalQuantity());
                            this.addDoubleField(doc, "numbervalues", val, convertedVal, numData.physicalQuantity());
                        }
                    }
                }
            }
        }
    }

    public void fillDocumentsDoc(ProjectData data) throws Exception {
        int length = data.projectDocumentsLength();
        for (int i = 0; i < length; ++i) {
            int lineIdListLength;
            String relBasePath;
            Document docDoc = new Document();
            DocumentData dd = data.projectDocuments(i);
            if (!this.indexDocument(docDoc, dd)) continue;
            String columnName = dd.columnName();
            if (columnName != null && !columnName.isEmpty()) {
                docDoc.add(new StoredField("column", columnName));
            }
            if ((relBasePath = dd.relBasePath()) != null && !relBasePath.isEmpty()) {
                docDoc.add(new StoredField("docbasepath", relBasePath));
                docDoc.add(new StoredField("docrelpath", dd.documentRelPath()));
            }
            if ((lineIdListLength = dd.lineIdListLength()) > 0) {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                PDataStream stream = new PDataStream(outStream);
                stream.write(data.catalogPath());
                stream.write(data.path());
                stream.write(lineIdListLength);
                for (int l = 0; l < lineIdListLength; ++l) {
                    stream.write(dd.lineIdList(l));
                }
                docDoc.add(new BinaryDocValuesField("facet_document_id", new BytesRef(outStream.toByteArray())));
            }
            this._indexWriter.addDocument(docDoc);
        }
    }

    private boolean indexPathData(ProjectData data, TableRowData row, Document doc, int persistentId) {
        boolean hasVisiblePath = false;
        doc.add(new StringField("path", data.catalogPath() + "/" + data.path(), Field.Store.NO));
        int treepathLength = data.treepathLength();
        int linkActiveLength = 0;
        if (row != null) {
            linkActiveLength = row.linkActiveLength();
        }
        for (int t = 0; t < treepathLength; ++t) {
            String treepath;
            if (t < linkActiveLength && !row.linkActive(t)) continue;
            this.addElementsOfPathField(doc, "treepath", data.treepath(t), Field.Store.NO);
            if (persistentId != -1 && (treepath = data.treepath(t)).startsWith("cat")) {
                this._treePathIndex.addLineData(treepath, persistentId);
            }
            hasVisiblePath = true;
        }
        return hasVisiblePath;
    }

    private boolean isNumericRange(TableRowColumnData column) {
        de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.ValueRangeData data;
        return column.dataType() == 4 && (data = (de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.ValueRangeData)column.data(new de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.ValueRangeData())).dataType() == 3;
    }

    private void addToFacetDocument(Document doc, String fieldFacet, TextValueData textValue) {
        int vlength = textValue.valuesLength();
        for (int v = 0; v < vlength; ++v) {
            TextValueDataHashItem entry = textValue.values(v);
            String entryValue = entry.value();
            if (entryValue.isEmpty()) continue;
            StringBuilder langDependentField = new StringBuilder();
            langDependentField.append(fieldFacet);
            langDependentField.append('_');
            langDependentField.append(entry.key());
            langDependentField.append("_lang");
            if (langDependentField.length() + entryValue.length() >= 8191) continue;
            doc.add(new SortedSetDocValuesFacetField(langDependentField.toString(), entryValue));
        }
    }

    private void processFacetData(Document doc, int facetLen, Function<Integer, FacetDataItem> listFunc) {
        for (int f = 0; f < facetLen; ++f) {
            FacetDataItem facetValue = listFunc.apply(f);
            String facetKey = facetValue.first();
            String facetVal = facetValue.second();
            if ("facet_".length() + facetKey.length() + facetVal.length() >= 8191) continue;
            doc.add(new SortedSetDocValuesFacetField("facet_" + facetKey, facetVal));
        }
    }

    private Document fillDocumentDocValues(Document doc, ProjectData data, TableRowData row) throws Exception {
        int fieldCountBefore = doc.getFields().size();
        this.processFacetData(doc, data.facetDataLength(), data::facetData);
        if (row != null) {
            int columnLength = row.columnsLength();
            for (int ci = 0; ci < columnLength; ++ci) {
                TableRowColumnData c = row.columns(ci);
                this.fillDocumentDocValuesForColumnData(doc, c);
            }
            this.processFacetData(doc, row.facetDataLength(), row::facetData);
            int clsSysLen = row.clsSystemColumnsLength();
            for (int c = 0; c < clsSysLen; ++c) {
                KeyAndTableRowColumnData kdata = row.clsSystemColumns(c);
                int valueLen = kdata.valueLength();
                for (int v = 0; v < valueLen; ++v) {
                    TableRowColumnData column = kdata.value(v);
                    this.fillDocumentDocValuesForColumnData(doc, column);
                }
            }
        }
        if (fieldCountBefore < doc.getFields().size()) {
            return this._facetsConfig.build(doc);
        }
        return doc;
    }

    private void fillDocumentDocValuesForColumnData(Document doc, TableRowColumnData c) {
        if ((c.flags() & 8) != 0) {
            String fieldFacet = c.type() == 3 && this.isNumericRange(c) ? "facet_range_" + c.name() : (c.type() == 2 ? "facet_var_" + c.name() : ((c.flags() & 0x10) != 0 ? "facet_erp_" + c.name() : "facet_text_" + c.name()));
            block0 : switch (c.dataType()) {
                case 1: {
                    StringData textValue = (StringData)c.data(new StringData());
                    String facetValue = textValue.value();
                    if (fieldFacet.length() + this._defaultLanguageFieldExtension.length() + facetValue.length() >= 8191) break;
                    doc.add(new SortedSetDocValuesFacetField(fieldFacet + this._defaultLanguageFieldExtension, textValue.value()));
                    break;
                }
                case 3: {
                    TextValueData textValue = (TextValueData)c.data(new TextValueData());
                    this.addToFacetDocument(doc, fieldFacet, textValue);
                    break;
                }
                case 4: {
                    de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.ValueRangeData vrData = (de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.ValueRangeData)c.data(new de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.ValueRangeData());
                    switch (vrData.dataType()) {
                        case 3: {
                            byte[] rawData;
                            NumericValueRangeData numRange = (NumericValueRangeData)vrData.data(new NumericValueRangeData());
                            NumericRange nRange = new NumericRange();
                            nRange.fromSerializedData(numRange);
                            if (nRange.isEmpty() || (rawData = nRange.toByteArray()) == null) break block0;
                            String facetFieldName = (c.flags() & 0x10) != 0 ? "facet_erp_rangevar" : "facet_rangevar";
                            Object facetColName = c.name();
                            int pq = numRange.physicalQuantity();
                            if (pq > 0) {
                                facetColName = (String)facetColName + "@" + pq;
                                fieldFacet = fieldFacet + "@" + pq;
                            }
                            doc.add(new SortedSetDocValuesFacetField(facetFieldName, (String)facetColName));
                            doc.add(new BinaryDocValuesField(fieldFacet, new BytesRef(rawData)));
                            break;
                        }
                        case 1: {
                            String indexFieldName = fieldFacet + this._defaultLanguageFieldExtension;
                            TextValueRangeData textRange = (TextValueRangeData)vrData.data(new TextValueRangeData());
                            int length = textRange.valueLength();
                            for (int l = 0; l < length; ++l) {
                                String facetValue = textRange.value(l);
                                if (indexFieldName.length() + facetValue.length() >= 8191) continue;
                                doc.add(new SortedSetDocValuesFacetField(indexFieldName, facetValue));
                            }
                            break block0;
                        }
                        case 2: {
                            TranslatedValueRangeData translatedRange = (TranslatedValueRangeData)vrData.data(new TranslatedValueRangeData());
                            int tlength = translatedRange.valueLength();
                            for (int t = 0; t < tlength; ++t) {
                                TranslatedValueRangeDataItem titem = translatedRange.value(t);
                                TextValueData textValue = titem.second();
                                this.addToFacetDocument(doc, fieldFacet, textValue);
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    NumericData numValue = (NumericData)c.data(new NumericData());
                    String facetFieldName = (c.flags() & 0x10) != 0 ? "facet_erp_numvar" : "facet_numvar";
                    Object facetColName = c.name();
                    int pq = numValue.physicalQuantity();
                    if (pq > 0) {
                        facetColName = (String)facetColName + "@" + pq;
                        fieldFacet = fieldFacet + "@" + pq;
                    }
                    doc.add(new SortedSetDocValuesFacetField(facetFieldName, (String)facetColName));
                    doc.add(new DoubleDocValuesField(fieldFacet, numValue.convertedValue()));
                }
            }
        }
    }

    private void fillDocumentWithTextValueDataField(Document doc, String fieldName, TextValueData data, int flags) {
        if (data == null) {
            return;
        }
        int valuesLength = data.valuesLength();
        for (int v = 0; v < valuesLength; ++v) {
            String langFieldName;
            TextValueDataHashItem valueItem = data.values(v);
            if (valueItem == null) continue;
            if ((flags & 1) != 0) {
                langFieldName = fieldName + "_" + valueItem.key() + "_lang";
                doc.add(new PSolTextField(langFieldName, valueItem.value(), Field.Store.NO));
                if ((flags & 0x20) != 0) {
                    String exactFieldName = fieldName + "_exact";
                    doc.add(new PSolTextField(exactFieldName, valueItem.value(), Field.Store.NO));
                }
            }
            if ((flags & 2) == 0) continue;
            langFieldName = "textvalues_" + valueItem.key() + "_lang";
            this._nameProvider.createTextualFields(null, langFieldName, name -> doc.add(new PSolTextField((String)name, valueItem.value(), Field.Store.NO)));
            if ((flags & 0x20) == 0) continue;
            doc.add(new PSolTextField("exactdata", valueItem.value(), Field.Store.NO));
        }
    }

    private void fillDocumentWithTextValue(Document doc, String fieldName, String textValue, int flags) {
        if (textValue != null) {
            if ((flags & 1) != 0) {
                String langFieldName = fieldName + this._defaultLanguageName + "_lang";
                doc.add(new PSolTextField(langFieldName, textValue, Field.Store.NO));
                if ((flags & 0x20) != 0) {
                    doc.add(new PSolTextField(langFieldName + "_exact", textValue, Field.Store.NO));
                }
            }
            if ((flags & 2) != 0) {
                doc.add(new PSolTextField(this._fieldNameTextValuesDefault, textValue, Field.Store.NO));
                if ((flags & 0x20) != 0) {
                    doc.add(new PSolTextField("exactdata", textValue, Field.Store.NO));
                }
            }
        }
    }

    private void fillDocumentWithValueRangeData(Document doc, String fieldName, StringVector data, int flags) {
        for (int i = 0; i < data.length(); ++i) {
            this.fillDocumentWithTextValue(doc, fieldName, data.get(i), flags);
        }
    }

    private void fillDocumentWithValueRangeData(Document doc, String fieldName, TranslatedValueRangeData data, int flags) {
        int length = data.valueLength();
        for (int i = 0; i < length; ++i) {
            this.fillDocumentWithTextValueDataField(doc, fieldName, data.value(i).second(), flags);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean indexDocument(Document doc, DocumentData documentData) throws Exception {
        Tika tika = new Tika();
        String documentPath = PFile.buildAbsolutePath(documentData.relBasePath(), documentData.documentRelPath());
        try (FileInputStream stream = new FileInputStream(documentPath);){
            ParseContext context = new ParseContext();
            OcrConfig.getInstance().configureContext(context);
            WriteOutContentHandler handler = new WriteOutContentHandler();
            Parser parser = tika.getParser();
            context.set(Parser.class, (Object)parser);
            parser.parse((InputStream)stream, (ContentHandler)new BodyContentHandler((ContentHandler)handler), new Metadata(), context);
            String parsedData = handler.toString();
            if (parsedData != null) {
                parsedData = parsedData.trim();
            }
            if (parsedData == null) return false;
            if (parsedData.isEmpty()) return false;
            String fieldName = "document_" + documentData.language() + "_lang";
            doc.add(new PSolTextField(fieldName, parsedData, Field.Store.NO));
            doc.add(new StoredField("document", parsedData));
            doc.add(new StoredField("document_language", documentData.language()));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("Failed to parse: " + documentPath);
            logger.error(e);
        }
        return false;
    }

    private void addElementsOfPathField(Document doc, String fieldName, String path, Field.Store store) {
        Set<String> pathElements = this.getElementsFromPath(path);
        if (pathElements != null) {
            for (String s : pathElements) {
                doc.add(new StringField(fieldName, s, store));
            }
        }
    }

    private Set<String> getElementsFromPath(String path) {
        HashSet<String> categories = new HashSet<String>();
        String[] parts = path.split("/");
        for (int i = 0; i < parts.length; ++i) {
            StringBuilder category = new StringBuilder();
            for (int k = 0; k < i + 1; ++k) {
                if (k > 0) {
                    category.append("/");
                }
                category.append(parts[k]);
            }
            categories.add(category.toString());
        }
        return categories;
    }

    private static class FieldNameProvider {
        private final ErpConfiguration erpConfig;

        public FieldNameProvider(ErpConfiguration erpConfig) {
            this.erpConfig = erpConfig;
        }

        void createNumericFields(String varName, Consumer<String> creator) {
            Set<String> groupNames;
            if (this.erpConfig.isValid() && varName != null && (groupNames = this.erpConfig.getGroupsForVarName(varName)) != null) {
                for (String groupName : groupNames) {
                    creator.accept(groupName + "_numbervalues");
                }
                return;
            }
            creator.accept("numbervalues");
        }

        void createTextualFields(String varName, String fieldName, Consumer<String> creator) {
            Set<String> groupNames;
            if (this.erpConfig.isValid() && varName != null && (groupNames = this.erpConfig.getGroupsForVarName(varName)) != null) {
                for (String groupName : groupNames) {
                    creator.accept(groupName + "_" + fieldName);
                }
                return;
            }
            creator.accept(fieldName);
        }
    }

    private static class PSolNumberField
    extends DoubleRange {
        PSolNumberField(String name, double[] min, double[] max) {
            super(name, min, max);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof PSolNumberField) {
                PSolNumberField otherField = (PSolNumberField)other;
                return this.name().equals(otherField.name()) && this.binaryValue().equals(otherField.binaryValue());
            }
            return false;
        }

        public int hashCode() {
            return this.name().hashCode() * 32 + this.binaryValue().hashCode();
        }
    }

    public static class NumericRange
    extends ArrayList<Range> {
        public double min = Double.POSITIVE_INFINITY;
        public double max = Double.NEGATIVE_INFINITY;

        public void fromSerializedData(NumericValueRangeData data) {
            if (data.convertedValueLength() > 0) {
                for (int v = 0; v < data.convertedValueLength(); ++v) {
                    NumericValueRangeDataItem item = data.convertedValue(v);
                    this.add(new Range(item.min(), item.max()));
                }
            } else {
                for (int v = 0; v < data.valueLength(); ++v) {
                    NumericValueRangeDataItem item = data.value(v);
                    this.add(new Range(item.min(), item.max()));
                }
            }
        }

        public byte[] toByteArray() {
            try {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                PDataStream stream = new PDataStream(outStream);
                stream.write(this.size());
                stream.write(this.min);
                stream.write(this.max);
                for (Range range : this) {
                    stream.write(range.min);
                    stream.write(range.max);
                }
                return outStream.toByteArray();
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public boolean add(Range item) {
            if (item.min < this.min) {
                this.min = item.min;
            }
            if (item.max > this.max) {
                this.max = item.max;
            }
            return super.add(item);
        }
    }

    public static class Range {
        public double min;
        public double max;

        public Range(double min, double max) {
            this.min = min;
            this.max = max;
        }
    }
}

