/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.index;

import de.cadenas.catalogsearch.CADENAS;
import de.cadenas.util.PConfig;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class ErpConfiguration {
    private static ErpConfiguration instance = null;
    private Map<String, Group> erpGroups = new HashMap<String, Group>();
    private final Map<String, Set<String>> groupsByVarName = new HashMap<String, Set<String>>();
    private final Map<String, String> erpGroupToCombinedGroup = new HashMap<String, String>();
    private boolean modified = false;
    private String configPath = "";

    private void buildGroupConfig() {
        HashMap<Set, String> groupLookup = new HashMap<Set, String>();
        this.erpGroupToCombinedGroup.clear();
        this.groupsByVarName.clear();
        this.erpGroups.forEach((groupName, group) -> {
            String combinedGroup = groupLookup.computeIfAbsent(group.varList, k -> "group" + groupLookup.size());
            this.erpGroupToCombinedGroup.put((String)groupName, combinedGroup);
        });
        groupLookup.forEach((varList, groupName) -> {
            for (String varName : varList) {
                varName = varName.toUpperCase();
                Set groups = this.groupsByVarName.computeIfAbsent(varName, k -> new HashSet());
                groups.add(groupName);
            }
        });
    }

    private Map<String, Group> parseFromJson(JSONObject jConfig) {
        HashMap<String, Group> groups = new HashMap<String, Group>();
        JSONObject jGroups = jConfig.getJSONObject("groups");
        for (String groupName : jGroups.keySet()) {
            JSONObject jGroup = jGroups.getJSONObject(groupName);
            Group group = new Group();
            JSONArray jVarList = jGroup.optJSONArray("varList");
            if (jVarList != null) {
                for (int i = 0; i < jVarList.length(); ++i) {
                    group.varList.add(jVarList.getString(i));
                }
            }
            groups.put(groupName, group);
        }
        return groups;
    }

    private boolean compareErpGroups(Map<String, Group> oldConfig, Map<String, Group> newConfig) {
        for (Map.Entry<String, Group> entry : newConfig.entrySet()) {
            Group oldGroup = oldConfig.get(entry.getKey());
            if (oldGroup == null) {
                return true;
            }
            if (entry.getValue().varList.equals(oldGroup.varList)) continue;
            return true;
        }
        return false;
    }

    private ErpConfiguration() {
    }

    public static synchronized ErpConfiguration getInstance() {
        if (instance == null) {
            instance = new ErpConfiguration();
            String configPath = Paths.get(CADENAS.CADENAS_INDEX, "erp.cfg").toString();
            instance.loadFromConfig(configPath);
        }
        return instance;
    }

    public synchronized boolean isValid() {
        return !this.groupsByVarName.isEmpty();
    }

    public synchronized void buildFromJson(JSONObject jConfig) {
        Map<String, Group> newConfig = this.parseFromJson(jConfig);
        if (newConfig.isEmpty()) {
            return;
        }
        if (this.isValid() && !this.compareErpGroups(this.erpGroups, newConfig)) {
            return;
        }
        this.erpGroups = newConfig;
        this.modified = true;
        this.buildGroupConfig();
        this.saveToConfig(this.configPath);
    }

    public synchronized void saveToConfig(String configPath) {
        if (!this.modified) {
            return;
        }
        this.modified = false;
        try (PConfig config = new PConfig(configPath);){
            config.clearConfig();
            this.erpGroups.forEach((name, group) -> {
                config.writeString("Variables", (String)name, String.join((CharSequence)",", group.varList));
                config.writeString((String)name, "CombinedGroups", this.erpGroupToCombinedGroup.getOrDefault(name, ""));
            });
            this.groupsByVarName.forEach((varName, groups) -> config.writeString((String)varName, "VarsToGroups", String.join((CharSequence)",", groups)));
            config.write();
        }
    }

    private void loadFromConfig(String configPath) {
        this.configPath = configPath;
        try (PConfig config = new PConfig(configPath);){
            String[] blocks;
            String[] erpGroups;
            String[] varNames = config.getKeys("VarsToGroups");
            if (varNames != null) {
                for (String varName : varNames) {
                    String[] groupNames = config.getStringArray(varName, "VarsToGroups");
                    this.groupsByVarName.put(varName.toUpperCase(), new HashSet<String>(Arrays.asList(groupNames)));
                }
            }
            if ((erpGroups = config.getKeys("CombinedGroups")) != null) {
                for (String erpGroup : erpGroups) {
                    String combinedGroup = config.getValue(erpGroup, "CombinedGroups");
                    if (combinedGroup == null || combinedGroup.isEmpty()) continue;
                    this.erpGroupToCombinedGroup.put(erpGroup, combinedGroup);
                }
            }
            if ((blocks = config.getBlocks()) != null && blocks.length > 0) {
                for (String block : blocks) {
                    String[] variables = config.getStringArray("Variables", block);
                    if (variables == null || variables.length == 0) continue;
                    Group group = new Group();
                    group.varList = new HashSet<String>(Arrays.asList(variables));
                    this.erpGroups.put(block, group);
                }
            }
        }
    }

    public synchronized Set<String> getGroupsForVarName(String varName) {
        return this.groupsByVarName.get(varName.toUpperCase());
    }

    public synchronized String getCombinedGroup(String erpGroup) {
        return this.erpGroupToCombinedGroup.get(erpGroup);
    }

    public synchronized boolean isErpVariable(String variable) {
        return this.groupsByVarName.containsKey(variable.toUpperCase());
    }

    public synchronized boolean isVariableVisible(String variable, String groupName) {
        String combinedGroup;
        Set<String> groups = this.groupsByVarName.get(variable.toUpperCase());
        if (groups != null && (combinedGroup = this.erpGroupToCombinedGroup.get(groupName)) != null) {
            return groups.contains(combinedGroup);
        }
        return false;
    }

    private static class Group {
        Set<String> varList = new HashSet<String>();

        private Group() {
        }
    }
}

