/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.index;

import de.cadenas.util.PFile;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class GlobalTagMapper {
    private final Object2ObjectMap<String, Object2ObjectMap<String, String>> languages = new Object2ObjectOpenHashMap<String, Object2ObjectMap<String, String>>();
    private static GlobalTagMapper instance = null;

    public static synchronized GlobalTagMapper getInstance() {
        if (instance == null) {
            instance = new GlobalTagMapper();
        }
        return instance;
    }

    private GlobalTagMapper() {
    }

    public synchronized String getSynonymForTag(String tag, String language) {
        Object2ObjectMap mapping = this.languages.computeIfAbsent(language, k -> {
            Object2ObjectOpenHashMap<String, String> tag2syn = new Object2ObjectOpenHashMap<String, String>();
            String path = "$CADENAS_DATA/datasetup/taglist/taglist_" + language + ".csv";
            byte[] fileData = PFile.readFileContents(path);
            if (fileData != null && fileData.length > 0) {
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(fileData);){
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
                    while ((line = reader.readLine()) != null) {
                        String[] lineParts = line.split(";");
                        if (lineParts.length < 5) continue;
                        tag2syn.computeIfAbsent(lineParts[0].toLowerCase(), m -> lineParts[4]);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return tag2syn;
        });
        return (String)mapping.get(tag);
    }
}

