/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.index;

import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.index.ErpConfiguration;
import java.util.Optional;
import org.apache.lucene.index.IndexWriterConfig;
import org.json.JSONObject;

public class OpenIndexRequest {
    public String catalogName;
    public String indexPath;
    public FieldDefinitions.IndexType type;
    public Optional<IndexWriterConfig.OpenMode> openMode = Optional.empty();
    public boolean useRamDirectory = false;

    public static OpenIndexRequest fromJson(JSONObject json) {
        JSONObject jErpConfig;
        OpenIndexRequest request = new OpenIndexRequest();
        request.catalogName = json.getString("catalog");
        request.indexPath = json.optString("indexPath");
        String indexType = json.optString("type");
        request.type = !indexType.isEmpty() ? FieldDefinitions.IndexType.fromString(indexType) : FieldDefinitions.IndexType.Fulltext;
        request.useRamDirectory = json.optBoolean("ramDirectory");
        String openMode = json.optString("openMode");
        if (openMode != null && !openMode.isEmpty()) {
            if (openMode.equals("create")) {
                request.openMode = Optional.of(IndexWriterConfig.OpenMode.CREATE);
            } else if (openMode.equals("append")) {
                request.openMode = Optional.of(IndexWriterConfig.OpenMode.APPEND);
            } else if (openMode.equals("create_or_append")) {
                request.openMode = Optional.of(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            }
        }
        if ((jErpConfig = json.optJSONObject("erpConfiguration")) != null) {
            ErpConfiguration erpConfiguration = ErpConfiguration.getInstance();
            erpConfiguration.buildFromJson(jErpConfig);
        }
        return request;
    }
}

