/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.index;

import de.cadenas.util.PDataStream;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.util.BytesRef;

public class PMemoryIndexWriter {
    private final PDataStream byteStream;

    public PMemoryIndexWriter(PDataStream stream) {
        this.byteStream = stream;
    }

    public void addField(String fieldName, String text, Analyzer analyzer) {
        try {
            TokenStream stream = analyzer.tokenStream(fieldName, text);
            TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
            PositionIncrementAttribute posIncrAttribute = stream.addAttribute(PositionIncrementAttribute.class);
            stream.reset();
            while (stream.incrementToken()) {
                int posIncr = posIncrAttribute.getPositionIncrement();
                this.byteStream.writeVInt(posIncr);
                BytesRef data = termAtt.getBytesRef();
                this.byteStream.write(data);
            }
            stream.end();
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

