/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.index.valuerange;

import com.google.flatbuffers.StringVector;
import de.cadenas.catalogsearch.lucene.analysis.FieldAwareAnalyzer;
import de.cadenas.catalogsearch.lucene.index.PMemoryIndexWriter;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.NumericValueRangeData;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.NumericValueRangeDataItem;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.TextValueData;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.TextValueDataHashItem;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.TextValueRangeData;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.TranslatedValueRangeData;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.TranslatedValueRangeDataItem;
import de.cadenas.util.PDataStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;

public class ValueRangeData {
    public boolean isTranslated = false;
    public boolean isRange = false;
    public boolean isFm = false;
    public List<Item> values = null;
    public NumericRange numRange = null;
    public double conversionFactor = 1.0;

    public boolean loadFromStream(DataInput stream) throws IOException {
        block8: {
            block7: {
                int version = stream.readInt();
                if (version != 6) {
                    return false;
                }
                this.isFm = stream.readByte() == 1;
                boolean bl = this.isRange = stream.readByte() == 1;
                if (!this.isRange) break block7;
                this.conversionFactor = Double.longBitsToDouble(stream.readLong());
                int size = stream.readVInt();
                if (size <= 0) break block8;
                this.numRange = new NumericRange();
                for (int i = 0; i < size; ++i) {
                    double min = Double.longBitsToDouble(stream.readLong());
                    double max = Double.longBitsToDouble(stream.readLong());
                    Range range = new Range(min, max);
                    range.step = Double.longBitsToDouble(stream.readLong());
                    this.numRange.add(range);
                }
                break block8;
            }
            this.isTranslated = stream.readByte() == 1;
            this.values = new ArrayList<Item>();
            int length = stream.readVInt();
            if (!this.isTranslated) {
                for (int i = 0; i < length; ++i) {
                    Item item = new Item();
                    item.internalValue = stream.readString();
                    int len = stream.readVInt();
                    byte[] value = new byte[len];
                    stream.readBytes(value, 0, len);
                    item.tokenizedValue = value;
                    this.values.add(item);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    Item item = new Item();
                    item.internalValue = stream.readString();
                    item.translatedValues = new HashMap<String, byte[]>();
                    int vlength = stream.readVInt();
                    for (int v = 0; v < vlength; ++v) {
                        String language = stream.readString();
                        int len = stream.readVInt();
                        byte[] value = new byte[len];
                        stream.readBytes(value, 0, len);
                        item.translatedValues.put(language, value);
                    }
                    this.values.add(item);
                }
            }
        }
        return true;
    }

    public static void tokenizeAndStore(de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.ValueRangeData vrData, DataOutput stream) throws IOException {
        FieldAwareAnalyzer analyzer = new FieldAwareAnalyzer(true);
        byte type = vrData.dataType();
        if (type == 1) {
            stream.writeByte((byte)0);
            TextValueRangeData textVrData = (TextValueRangeData)vrData.data(new TextValueRangeData());
            if (textVrData != null) {
                String fieldName = "col_text_x_english_lang";
                StringVector list = textVrData.valueVector();
                int length = list.length();
                stream.writeVInt(length);
                for (int n = 0; n < length; ++n) {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    PDataStream valueStream = new PDataStream(outputStream);
                    PMemoryIndexWriter writer = new PMemoryIndexWriter(valueStream);
                    String value = list.get(n);
                    writer.addField(fieldName, value, analyzer);
                    stream.writeString(value);
                    byte[] data = outputStream.toByteArray();
                    stream.writeVInt(data.length);
                    stream.writeBytes(data, data.length);
                }
            }
        } else {
            stream.writeByte((byte)1);
            TranslatedValueRangeData trData = (TranslatedValueRangeData)vrData.data(new TranslatedValueRangeData());
            if (trData != null) {
                int length = trData.valueLength();
                stream.writeVInt(length);
                for (int n = 0; n < length; ++n) {
                    TranslatedValueRangeDataItem item = trData.value(n);
                    stream.writeString(item.first());
                    TextValueData values = item.second();
                    if (values == null) continue;
                    int vlength = values.valuesLength();
                    stream.writeVInt(vlength);
                    for (int v = 0; v < vlength; ++v) {
                        TextValueDataHashItem hitem = values.values(v);
                        String language = hitem.key();
                        String fieldName = "col_text_x_" + language + "_lang";
                        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                        PDataStream valueStream = new PDataStream(outputStream);
                        PMemoryIndexWriter writer = new PMemoryIndexWriter(valueStream);
                        writer.addField(fieldName, hitem.value(), analyzer);
                        stream.writeString(language);
                        byte[] data = outputStream.toByteArray();
                        stream.writeVInt(data.length);
                        stream.writeBytes(data, data.length);
                    }
                }
            } else {
                stream.writeVInt(0);
            }
        }
    }

    public static void storeToStream(DataOutput stream, de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.ValueRangeData vrData) throws IOException {
        stream.writeInt(6);
        stream.writeByte((byte)(vrData.IsFm() ? 1 : 0));
        byte type = vrData.dataType();
        if (type == 3) {
            stream.writeByte((byte)1);
            NumericValueRangeData numRange = (NumericValueRangeData)vrData.data(new NumericValueRangeData());
            if (numRange != null) {
                stream.writeLong(Double.doubleToLongBits(numRange.conversionFactor()));
                int numRangeLength = numRange.valueLength();
                stream.writeVInt(numRangeLength);
                for (int n = 0; n < numRangeLength; ++n) {
                    NumericValueRangeDataItem numItem = numRange.value(n);
                    stream.writeLong(Double.doubleToLongBits(numItem.min()));
                    stream.writeLong(Double.doubleToLongBits(numItem.max()));
                    stream.writeLong(Double.doubleToLongBits(numItem.step()));
                }
            } else {
                stream.writeLong(Double.doubleToLongBits(1.0));
                stream.writeVInt(0);
            }
        } else {
            stream.writeByte((byte)0);
            ValueRangeData.tokenizeAndStore(vrData, stream);
        }
    }

    public static class NumericRange
    extends ArrayList<Range> {
        public double min = Double.POSITIVE_INFINITY;
        public double max = Double.NEGATIVE_INFINITY;

        @Override
        public boolean add(Range item) {
            if (item.min < this.min) {
                this.min = item.min;
            }
            if (item.max > this.max) {
                this.max = item.max;
            }
            return super.add(item);
        }
    }

    public static class Range {
        public double min;
        public double max;
        public double step = 0.0;

        public Range(double min, double max) {
            this.min = min;
            this.max = max;
        }
    }

    public static class Item {
        public String internalValue = "";
        public byte[] tokenizedValue = null;
        public Map<String, byte[]> translatedValues = null;
    }
}

