/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.io;

import de.cadenas.catalogsearch.api.IDocIdIndex;
import de.cadenas.util.PDataStream;
import de.cadenas.util.PIntPair;
import de.cadenas.util.PLogger;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DocIdIndex
implements IDocIdIndex {
    private static final PLogger logger = new PLogger(DocIdIndex.class.getSimpleName());
    private final String defaultCatalogPath;
    private final Map<String, long[]> indexData = new HashMap<String, long[]>();
    private int[] reverseLineIdData = null;
    private int[] reverseLineSubIdData = null;
    private Int2ObjectMap<String> reverseVarsetData = null;
    private Int2ObjectMap<String> reverseCatalogPathData = null;
    private final Int2IntMap valueRangeLookupData = new Int2IntOpenHashMap();
    private String[] reversePathData = null;
    private boolean isSorted = false;
    private boolean checkOverwrites = false;

    private synchronized void sort() {
        if (!this.isSorted) {
            for (Map.Entry<String, long[]> entry : this.indexData.entrySet()) {
                Arrays.sort(entry.getValue());
            }
            this.isSorted = true;
        }
    }

    private boolean loadV3(PDataStream stream, String filePath) {
        boolean linkDbIndex = stream.readBool();
        Int2IntOpenHashMap lineIdLookup = new Int2IntOpenHashMap();
        Int2IntOpenHashMap lineSubIdLookup = new Int2IntOpenHashMap();
        Int2ObjectOpenHashMap<String> pathLookup = new Int2ObjectOpenHashMap<String>();
        int maxDocId = 0;
        int catalogSize = stream.readInt();
        for (int c = 0; c < catalogSize; ++c) {
            String catalog = stream.readString();
            boolean nonDefCatalog = catalog != null && !catalog.equals(this.defaultCatalogPath);
            int dataSize = stream.readInt();
            for (int i = 0; i < dataSize; ++i) {
                String path = stream.readVString();
                int valueCount = stream.readVInt();
                long[] valueList = new long[valueCount];
                for (int j = 0; j < valueCount; ++j) {
                    int vrDoc;
                    String varset;
                    int lineSubId;
                    long val;
                    stream.readInt();
                    int docId = stream.readInt();
                    int lineId = stream.readVInt();
                    valueList[j] = val = (long)lineId << 32 | (long)docId & 0xFFFFFFFFL;
                    if (linkDbIndex && (lineSubId = stream.readVInt()) != -1) {
                        lineSubIdLookup.put(docId, lineSubId);
                    }
                    if ((varset = stream.readVString()) != null) {
                        if (this.reverseVarsetData == null) {
                            this.reverseVarsetData = new Int2ObjectOpenHashMap<String>();
                        }
                        this.reverseVarsetData.put(docId, varset);
                    }
                    if ((vrDoc = stream.readVInt()) > 0) {
                        this.valueRangeLookupData.put(docId, vrDoc - 1);
                    }
                    if (docId > maxDocId) {
                        maxDocId = docId;
                    }
                    lineIdLookup.put(docId, lineId);
                    pathLookup.put(docId, path);
                    if (!nonDefCatalog) continue;
                    if (this.reverseCatalogPathData == null) {
                        this.reverseCatalogPathData = new Int2ObjectOpenHashMap<String>();
                    }
                    this.reverseCatalogPathData.put(docId, catalog);
                }
                this.indexData.put(path, valueList);
            }
        }
        if (maxDocId > 50000000) {
            logger.error("max docId in " + filePath + " is " + maxDocId + ". The index might be broken");
        }
        this.reverseLineIdData = new int[maxDocId + 1];
        this.reversePathData = new String[maxDocId + 1];
        if (linkDbIndex) {
            this.reverseLineSubIdData = new int[maxDocId + 1];
        }
        for (int d = 0; d <= maxDocId; ++d) {
            int lineSubId;
            String path;
            int lineId;
            this.reverseLineIdData[d] = lineId = lineIdLookup.getOrDefault(d, -1);
            this.reversePathData[d] = path = (String)pathLookup.get(d);
            if (!linkDbIndex) continue;
            this.reverseLineSubIdData[d] = lineSubId = lineSubIdLookup.getOrDefault(d, -1);
        }
        this.sort();
        return true;
    }

    public DocIdIndex(String catalogName) {
        this.defaultCatalogPath = catalogName;
    }

    public boolean load(String filePath) {
        boolean ret = false;
        File file = new File(filePath);
        try (FileInputStream inputStream = new FileInputStream(file);){
            byte[] data = new byte[(int)file.length()];
            if (inputStream.read(data) > 0) {
                PDataStream stream = new PDataStream(data, 0, data.length);
                int version = stream.readInt();
                if (version == 2) {
                    logger.error("V2 index not supported: " + filePath);
                } else if ((version == 3 || version == 4) && version == 4) {
                    this.checkOverwrites = true;
                }
                ret = this.loadV3(stream, filePath);
            }
        }
        catch (IOException e) {
            return false;
        }
        if (this.reversePathData == null) {
            this.reversePathData = new String[0];
        }
        this.isSorted = true;
        return ret;
    }

    @Override
    public IntSet createDocIdFilter(Map<String, List<PIntPair>> filter) {
        if (this.indexData.isEmpty()) {
            return null;
        }
        IntOpenHashSet idFilter = new IntOpenHashSet();
        for (Map.Entry<String, List<PIntPair>> entry : filter.entrySet()) {
            long[] indexValues = this.indexData.get(entry.getKey());
            if (indexValues == null) continue;
            block1: for (PIntPair idTuple : entry.getValue()) {
                long searchValue = (long)idTuple.first << 32;
                int pos = Arrays.binarySearch(indexValues, searchValue);
                if (pos < 0) {
                    pos = -1 - pos;
                }
                while (pos < indexValues.length) {
                    long iv = indexValues[pos];
                    int lineId = (int)(iv >> 32);
                    if (lineId < idTuple.first) {
                        ++pos;
                        continue;
                    }
                    if (lineId > idTuple.second) continue block1;
                    int docId = (int)iv;
                    idFilter.add(docId);
                    ++pos;
                }
            }
        }
        return idFilter;
    }

    @Override
    public IntList getDocIds(String path, int lineId) {
        IntArrayList idList = new IntArrayList();
        long[] indexValues = this.indexData.get(path);
        if (indexValues != null) {
            for (long indexValue : indexValues) {
                int indexLineId = (int)(indexValue >> 32);
                if (indexLineId != lineId) continue;
                int docId = (int)indexValue;
                idList.add(docId);
            }
        }
        return idList;
    }

    @Override
    public void collectDocIds(String path, int lineId, int lineSubId, IntList idList, boolean onlyFirst) {
        long[] indexValues = this.indexData.get(path);
        if (indexValues != null) {
            for (long indexValue : indexValues) {
                int indexLineId = (int)(indexValue >> 32);
                if (indexLineId != lineId) continue;
                int docId = (int)indexValue;
                if (this.reverseLineSubIdData == null) {
                    if (lineSubId != -1) continue;
                    idList.add(docId);
                    if (!onlyFirst) continue;
                    return;
                }
                int indexSubId = this.reverseLineSubIdData[docId];
                if (this.checkOverwrites) {
                    indexSubId >>= 1;
                }
                if (indexSubId != lineSubId) continue;
                idList.add(docId);
                if (!onlyFirst) continue;
                return;
            }
        }
    }

    @Override
    public void collectDocIds(String path, IntSet filter) {
        long[] indexValues = this.indexData.get(path);
        if (indexValues != null) {
            for (long indexValue : indexValues) {
                int docId = (int)indexValue;
                filter.add(docId);
            }
        }
    }

    @Override
    public IDocIdIndex.PrjIdentifier findByDocId(int docId) {
        int val;
        if (this.reverseLineIdData == null) {
            return null;
        }
        if (docId < 0 || docId >= this.reverseLineIdData.length) {
            return null;
        }
        if (this.checkOverwrites && this.reverseLineSubIdData != null && docId < this.reverseLineSubIdData.length && (val = this.reverseLineSubIdData[docId] & 1) > 0) {
            return null;
        }
        int lineId = this.reverseLineIdData[docId];
        if (lineId == -1) {
            return null;
        }
        String path = this.reversePathData[docId];
        if (path == null) {
            return null;
        }
        return new IDocIdIndex.PrjIdentifier(path, lineId);
    }

    @Override
    public String getDocPath(int docId) {
        if (docId < 0 || docId >= this.reversePathData.length) {
            return null;
        }
        return this.reversePathData[docId];
    }

    @Override
    public IDocIdIndex.LineData findLineData(int docId) {
        if (this.reverseLineIdData == null) {
            return null;
        }
        if (docId < 0 || docId >= this.reverseLineIdData.length) {
            return null;
        }
        int lineId = this.reverseLineIdData[docId];
        if (lineId == -1) {
            return null;
        }
        String path = this.reversePathData[docId];
        if (path == null) {
            return null;
        }
        IDocIdIndex.LineData data = new IDocIdIndex.LineData();
        data.path = path;
        data.lineId = lineId;
        data.catalogPath = this.reverseCatalogPathData != null ? this.reverseCatalogPathData.getOrDefault(docId, this.defaultCatalogPath) : this.defaultCatalogPath;
        if (this.reverseLineSubIdData != null) {
            int val = this.reverseLineSubIdData[docId];
            if (this.checkOverwrites) {
                if ((val & 1) > 0) {
                    data.hidesOriginalLine = false;
                }
                data.lineSubId = val >> 1;
            } else {
                data.lineSubId = val;
            }
        }
        if (this.reverseVarsetData != null) {
            data.varset = (String)this.reverseVarsetData.get(docId);
        }
        data.valueRangeDoc = this.valueRangeLookupData.getOrDefault(docId, -1);
        return data;
    }

    @Override
    public void collectDocIds(Map<String, IntSet> idsByProject, IntSet filter) {
        if (this.indexData.isEmpty()) {
            return;
        }
        for (Map.Entry<String, IntSet> entry : idsByProject.entrySet()) {
            long[] indexValues = this.indexData.get(entry.getKey());
            if (indexValues == null) continue;
            IntSet lineIds = entry.getValue();
            for (long indexValue : indexValues) {
                int indexLineId = (int)(indexValue >> 32);
                if (!lineIds.contains(indexLineId)) continue;
                int docId = (int)indexValue;
                filter.add(docId);
            }
        }
    }

    @Override
    public Set<String> getUsedCatalogNames() {
        HashSet<String> catalogNames = new HashSet<String>();
        catalogNames.add(this.defaultCatalogPath);
        if (this.reverseCatalogPathData != null) {
            catalogNames.addAll(this.reverseCatalogPathData.values());
        }
        return catalogNames;
    }
}

