/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.io;

import de.cadenas.catalogsearch.lucene.index.CatalogIndexer;
import de.cadenas.util.PDataStream;
import de.cadenas.util.PLogger;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MultiBits;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public class DocIdIndexBuilder {
    private static final PLogger logger = new PLogger(CatalogIndexer.class.getSimpleName());
    private int vrDataIndex = 0;
    private int lastId = 0;
    private final boolean linkDbIndex;
    private final Int2ObjectOpenHashMap<LineData> dataMap = new Int2ObjectOpenHashMap();
    private final Map<String, Map<String, List<LineData>>> dataByCatalog = new HashMap<String, Map<String, List<LineData>>>();
    private final Int2ObjectOpenHashMap<VrData> vrData = new Int2ObjectOpenHashMap();
    private final Object2IntMap<BytesRef> vrLookup = new Object2IntOpenHashMap<BytesRef>();
    private final boolean updateMode;

    public void setMinimumLastId(int minLastId) {
        if (this.lastId < minLastId) {
            this.lastId = minLastId;
        }
    }

    private void readDocIdIndex(String indexPath) {
        File file = new File(indexPath);
        try (FileInputStream inputStream = new FileInputStream(file);){
            byte[] data = new byte[(int)file.length()];
            inputStream.read(data);
            PDataStream stream = new PDataStream(data, 0, data.length);
            int version = stream.readInt();
            if (version == 3 || version == 4) {
                stream.readBool();
                int catalogSize = stream.readInt();
                for (int i = 0; i < catalogSize; ++i) {
                    String catalog = stream.readString();
                    this.readPathData(stream, catalog);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readPathData(PDataStream stream, String catalog) {
        int dataSize = stream.readInt();
        for (int i = 0; i < dataSize; ++i) {
            String path = stream.readVString();
            int valueCount = stream.readVInt();
            for (int j = 0; j < valueCount; ++j) {
                LineData item = new LineData();
                int persistentId = stream.readInt();
                if (persistentId + 1 > this.lastId) {
                    this.lastId = persistentId + 1;
                }
                item.persistentId = persistentId;
                item.docId = stream.readInt();
                item.lineId = stream.readVInt();
                if (this.linkDbIndex) {
                    item.lineSubId = stream.readVInt();
                }
                item.varset = stream.readVString();
                item.vrDocId = stream.readVInt() - 1;
                this.dataMap.put(persistentId, item);
                Map dataByPath = this.dataByCatalog.computeIfAbsent(catalog, k -> new HashMap());
                List dataList = dataByPath.computeIfAbsent(path, k -> new ArrayList());
                dataList.add(item);
            }
        }
    }

    public void initBuilder4Update(IndexReader reader) {
        Int2IntOpenHashMap vrDocId2Index = new Int2IntOpenHashMap();
        int count = reader.maxDoc();
        Bits bits = MultiBits.getLiveDocs(reader);
        for (int i = 0; i < count; ++i) {
            try {
                BytesRef br;
                String persIdValue;
                Document doc;
                if (bits != null && !bits.get(i) || (doc = reader.document(i)) == null || (persIdValue = doc.get("persid")) == null || !persIdValue.startsWith("v")) continue;
                int valueRangeId = Integer.parseInt(persIdValue = persIdValue.substring(1));
                if (valueRangeId > this.vrDataIndex) {
                    this.vrDataIndex = valueRangeId;
                }
                if ((br = doc.getBinaryValue("valuerangedef")) == null) continue;
                vrDocId2Index.put(i, this.vrLookup.computeIntIfAbsent(br, k -> {
                    this.vrData.put(valueRangeId, new VrData(br, true, false));
                    return valueRangeId;
                }));
                continue;
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
        this.dataMap.int2ObjectEntrySet().fastForEach(entry -> {
            LineData data = (LineData)entry.getValue();
            if (data.vrDocId != -1) {
                data.valueRangeIndex = vrDocId2Index.getOrDefault(data.vrDocId, -1);
            }
        });
    }

    public DocIdIndexBuilder(boolean linkDbIndex) {
        this.linkDbIndex = linkDbIndex;
        this.updateMode = false;
        this.vrLookup.defaultReturnValue(-1);
    }

    public DocIdIndexBuilder(boolean linkDbIndex, String indexPath) {
        this.linkDbIndex = linkDbIndex;
        this.updateMode = true;
        this.vrLookup.defaultReturnValue(-1);
        this.readDocIdIndex(indexPath);
    }

    public synchronized int addLineData(String catalog, String prjPath, int lineId, int lineSubId, String varset) {
        LineData data = new LineData();
        data.lineId = lineId;
        data.lineSubId = lineSubId;
        data.varset = varset;
        this.dataMap.put(this.lastId, data);
        Map dataByPath = this.dataByCatalog.computeIfAbsent(catalog, k -> new HashMap());
        List dataList = dataByPath.computeIfAbsent(prjPath, k -> new ArrayList());
        dataList.add(data);
        return this.lastId++;
    }

    public synchronized void setValueRangeData(int persistentId, byte[] data) {
        LineData lineData = this.dataMap.get(persistentId);
        if (lineData != null) {
            BytesRef br = new BytesRef(data);
            lineData.valueRangeIndex = this.vrLookup.getInt(br);
            if (lineData.valueRangeIndex == this.vrLookup.defaultReturnValue()) {
                ++this.vrDataIndex;
                this.vrData.put(this.vrDataIndex, new VrData(br, false, true));
                lineData.valueRangeIndex = this.vrDataIndex;
            } else {
                this.vrData.get((int)lineData.valueRangeIndex).used = true;
            }
        }
    }

    public void storeValueRangeData(IndexWriter indexWriter) {
        if (this.updateMode) {
            for (Map.Entry<String, Map<String, List<LineData>>> catalogData : this.dataByCatalog.entrySet()) {
                for (Map.Entry<String, List<LineData>> prjData : catalogData.getValue().entrySet()) {
                    List<LineData> lineList = prjData.getValue();
                    if (lineList == null) continue;
                    for (LineData lineData : lineList) {
                        VrData data;
                        int valueRangeIndex = lineData.valueRangeIndex;
                        if (valueRangeIndex == -1 || (data = this.vrData.get(lineData.valueRangeIndex)) == null) continue;
                        data.used = true;
                    }
                }
            }
        }
        this.vrData.int2ObjectEntrySet().fastForEach(entry -> {
            int index = entry.getIntKey();
            VrData data = (VrData)entry.getValue();
            try {
                if (data.used && !data.loaded) {
                    Document doc = new Document();
                    doc.add(new StoredField("valuerangedef", data.data));
                    String id = "v" + index;
                    doc.add(new StoredField("persid", id));
                    doc.add(new StringField("persidx", id, Field.Store.NO));
                    indexWriter.addDocument(doc);
                } else if (data.loaded && !data.used) {
                    String id = "v" + index;
                    TermQuery vrDelQuery = new TermQuery(new Term("persidx", id));
                    indexWriter.deleteDocuments(vrDelQuery);
                }
            }
            catch (IOException e) {
                logger.error(e);
            }
        });
    }

    public synchronized void buildIndex(IndexReader reader, String outPath) {
        try (FileOutputStream outputStream = new FileOutputStream(outPath);){
            PDataStream stream = new PDataStream(outputStream);
            Int2IntOpenHashMap vrIndexToDocId = new Int2IntOpenHashMap();
            int count = reader.maxDoc();
            Bits bits = MultiBits.getLiveDocs(reader);
            for (int i = 0; i < count; ++i) {
                try {
                    Document doc;
                    if (bits != null && !bits.get(i) || (doc = reader.document(i)) == null) continue;
                    int persistentId = -1;
                    String persIdValue = doc.get("persid");
                    if (persIdValue == null) continue;
                    try {
                        if (persIdValue.startsWith("v")) {
                            persIdValue = persIdValue.substring(1);
                            persistentId = Integer.parseInt(persIdValue);
                            vrIndexToDocId.put(persistentId, i + 1);
                            continue;
                        }
                        persistentId = Integer.parseInt(persIdValue);
                    }
                    catch (NumberFormatException nfe) {
                        continue;
                    }
                    LineData lineData = this.dataMap.get(persistentId);
                    if (lineData == null) continue;
                    lineData.persistentId = persistentId;
                    lineData.docId = i;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int version = 4;
            stream.write(version);
            stream.write(this.linkDbIndex);
            stream.write(this.dataByCatalog.size());
            for (Map.Entry<String, Map<String, List<LineData>>> catalogData : this.dataByCatalog.entrySet()) {
                stream.write(catalogData.getKey());
                Map<String, List<LineData>> dataByPath = catalogData.getValue();
                stream.write(dataByPath.size());
                for (Map.Entry<String, List<LineData>> prjData : dataByPath.entrySet()) {
                    String path = prjData.getKey();
                    stream.writeVString(path);
                    List<LineData> lineList = prjData.getValue();
                    if (lineList != null) {
                        stream.writeVInt(lineList.size());
                        for (LineData lineData : lineList) {
                            stream.write(lineData.persistentId);
                            stream.write(lineData.docId);
                            stream.writeVInt(lineData.lineId);
                            if (this.linkDbIndex) {
                                stream.writeVInt(lineData.lineSubId);
                            }
                            stream.writeVString(lineData.varset);
                            int vrDoc = vrIndexToDocId.getOrDefault(lineData.valueRangeIndex, 0);
                            stream.writeVInt(vrDoc);
                        }
                        continue;
                    }
                    stream.writeVInt(0);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void removeData(String catalog, String prjPath, int lineId) {
        List<LineData> lineList;
        Map<String, List<LineData>> dataByPath = this.dataByCatalog.get(catalog);
        if (dataByPath != null && (lineList = dataByPath.get(prjPath)) != null) {
            Iterator<LineData> i = lineList.iterator();
            while (i.hasNext()) {
                LineData ldata = i.next();
                if (lineId != -1 && lineId != ldata.lineId) continue;
                i.remove();
            }
        }
    }

    private static class LineData {
        String varset;
        int valueRangeIndex = -1;
        int vrDocId = -1;
        int lineId;
        int lineSubId;
        int persistentId = -1;
        int docId = -1;

        private LineData() {
        }
    }

    private static class VrData {
        final BytesRef data;
        final boolean loaded;
        boolean used;

        VrData(BytesRef d, boolean l, boolean u) {
            this.data = d;
            this.loaded = l;
            this.used = u;
        }
    }
}

