/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.io;

import de.cadenas.catalogsearch.api.IIndexManager;
import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.index.CatalogMappingIndexReader;
import de.cadenas.catalogsearch.lucene.io.IndexManager;
import de.cadenas.catalogsearch.lucene.io.IndexReaderContainer;
import de.cadenas.catalogsearch.lucene.io.IndexReaderData;
import de.cadenas.catalogsearch.lucene.search.PSolIndexSearcher;
import de.cadenas.util.PLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.facet.sortedset.DefaultSortedSetDocValuesReaderState;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.similarities.BooleanSimilarity;
import org.jetbrains.annotations.Nullable;

class IndexTypeContainer {
    private final Map<String, IndexReaderContainer> indexReaders = new HashMap<String, IndexReaderContainer>();
    private final Map<IndexReader, IndexReaderData> dataByReader = new HashMap<IndexReader, IndexReaderData>();
    private final ReadWriteLock readersLock = new ReentrantReadWriteLock();
    private final Map<List<String>, IIndexManager.IndexSearcherContainer> indexSearchers = new HashMap<List<String>, IIndexManager.IndexSearcherContainer>();
    private final LruCache readerStates = new LruCache(FieldDefinitions.readerStateCacheSize);
    private final Map<String, Set<String>> catalogToContainingCatalogs = new HashMap<String, Set<String>>();
    private final Map<List<String>, IndexSearcher> spellSearchers = new HashMap<List<String>, IndexSearcher>();
    private final Map<List<String>, IndexSearcher> relatedSearchers = new HashMap<List<String>, IndexSearcher>();
    private static final PLogger logger = new PLogger(IndexManager.class.getSimpleName());

    IndexTypeContainer() {
    }

    IndexReaderContainer createIndexReaderContainer(String catalogName, boolean create) {
        this.readersLock.readLock().lock();
        IndexReaderContainer result = this.indexReaders.get(catalogName);
        this.readersLock.readLock().unlock();
        if (result == null && create) {
            this.readersLock.writeLock().lock();
            result = this.indexReaders.get(catalogName);
            if (result == null) {
                result = new IndexReaderContainer(catalogName);
                this.indexReaders.put(catalogName, result);
            }
            this.readersLock.writeLock().unlock();
        }
        return result;
    }

    void removeIndexReaderContainer(String catalogName) {
        this.readersLock.writeLock().lock();
        this.indexReaders.remove(catalogName);
        this.readersLock.writeLock().unlock();
    }

    IndexReaderContainer getIndexReaderContainer(String catalogName) {
        this.readersLock.readLock().lock();
        IndexReaderContainer result = this.indexReaders.get(catalogName);
        this.readersLock.readLock().unlock();
        return result;
    }

    private Collection<IndexReaderContainer> getIndexReaderContainer(Collection<String> catalogNames) {
        ArrayList<IndexReaderContainer> result = new ArrayList<IndexReaderContainer>();
        this.readersLock.readLock().lock();
        for (String catalogName : catalogNames) {
            IndexReaderContainer container = this.indexReaders.get(catalogName);
            if (container == null) continue;
            result.add(container);
        }
        this.readersLock.readLock().unlock();
        return result;
    }

    IndexReaderData getIndexReaderData(IndexReader indexReader) {
        this.readersLock.readLock().lock();
        IndexReaderData result = this.dataByReader.get(indexReader);
        this.readersLock.readLock().unlock();
        return result;
    }

    Collection<IndexReader> getAllIndexReaders() {
        ArrayList<IndexReader> readers = new ArrayList<IndexReader>();
        this.readersLock.readLock().lock();
        for (IndexReaderContainer readerContainer : this.indexReaders.values()) {
            IndexReader reader = readerContainer.getIndexReader();
            if (reader == null) continue;
            readers.add(reader);
        }
        this.readersLock.readLock().unlock();
        return readers;
    }

    Collection<String> getAllLoadedCatalogs() {
        ArrayList<String> catalogs = new ArrayList<String>();
        this.readersLock.readLock().lock();
        this.indexReaders.forEach((k, v) -> catalogs.add((String)k));
        this.readersLock.readLock().unlock();
        return catalogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IIndexManager.IndexSearcherContainerLocked createIndexSearcher(List<String> catalogList, FieldDefinitions.IndexType indexType, ExecutorService executor) throws IOException {
        ArrayList<IndexReader> col = new ArrayList<IndexReader>();
        ArrayList<String> catalogCol = new ArrayList<String>();
        Collection<IndexReaderContainer> containerList = this.getIndexReaderContainer(catalogList);
        for (IndexReaderContainer indexReaderContainer : containerList) {
            IndexReader reader;
            if (indexReaderContainer == null || (reader = indexReaderContainer.getIndexReader()) == null) continue;
            col.add(reader);
            catalogCol.add(indexReaderContainer.getCatalogName());
        }
        if (catalogCol.isEmpty()) {
            return null;
        }
        IIndexManager.IndexSearcherContainerLocked lockedContainer = null;
        try {
            Map<List<String>, IIndexManager.IndexSearcherContainer> map = this.indexSearchers;
            synchronized (map) {
                IIndexManager.IndexSearcherContainer searcherContainer = this.indexSearchers.get(catalogCol);
                if (searcherContainer == null) {
                    List<String> catalogs = Collections.unmodifiableList(catalogCol);
                    IndexReader[] readers = col.toArray(new IndexReader[0]);
                    try (IndexReader multiReader = null;){
                        multiReader = new CatalogMappingIndexReader(readers, catalogs, false);
                        searcherContainer = new IndexSearcherContainer();
                        searcherContainer.multiReader = multiReader;
                        searcherContainer.hasCatalogBoosts = ((IndexSearcherContainer)searcherContainer).hasCatalogBoosts();
                        searcherContainer.indexType = indexType;
                        this.indexSearchers.put(catalogs, searcherContainer);
                        multiReader = null;
                    }
                }
                lockedContainer = new IIndexManager.IndexSearcherContainerLocked(searcherContainer);
            }
            PSolIndexSearcher pSolIndexSearcher = new PSolIndexSearcher(lockedContainer.getContainer().getIndexReader().getContext(), executor);
            pSolIndexSearcher.setSimilarity(new BooleanSimilarity());
            lockedContainer.setIndexSearcher(pSolIndexSearcher);
        }
        catch (Exception exception) {
            if (lockedContainer != null) {
                lockedContainer.close();
            }
            throw exception;
        }
        return lockedContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SortedSetDocValuesReaderState createReaderState(IndexReader reader, FieldDefinitions.FacetType facetType) throws IOException {
        SortedSetDocValuesReaderState[] readerStateList;
        Object readerData;
        if (reader == null) {
            return null;
        }
        if (facetType == FieldDefinitions.FacetType.FacetVariable) {
            try {
                if (reader.numDocs() > 0) {
                    DefaultSortedSetDocValuesReaderState readerState = new DefaultSortedSetDocValuesReaderState(reader, FieldDefinitions.FacetType.toIndexName(facetType));
                    return readerState;
                }
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        SortedSetDocValuesReaderState readerState = null;
        List<String> catalogs = null;
        if (reader instanceof CatalogMappingIndexReader) {
            catalogs = ((CatalogMappingIndexReader)reader).getCatalogList();
        } else {
            readerData = this.getIndexReaderData(reader);
            if (readerData != null) {
                catalogs = Collections.singletonList(((IndexReaderData)readerData).getCatalogName());
            }
        }
        if (catalogs == null || catalogs.isEmpty()) {
            return null;
        }
        readerData = this.readerStates;
        synchronized (readerData) {
            readerStateList = (SortedSetDocValuesReaderState[])this.readerStates.get(catalogs);
            if (readerStateList != null) {
                readerState = readerStateList[facetType.ordinal()];
            }
        }
        if (readerState == null) {
            try {
                if (reader.numDocs() > 0) {
                    readerState = new DefaultSortedSetDocValuesReaderState(reader, FieldDefinitions.FacetType.toIndexName(facetType));
                }
            }
            catch (IllegalArgumentException e) {
                logger.error("Failed to create reader state for " + String.join((CharSequence)",", catalogs));
                logger.error(e);
            }
            LruCache lruCache = this.readerStates;
            synchronized (lruCache) {
                readerStateList = this.readerStates.computeIfAbsent(catalogs, k -> new SortedSetDocValuesReaderState[3]);
                readerStateList[facetType.ordinal()] = readerState;
            }
        }
        return readerState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearReaderStateCache() {
        LruCache lruCache = this.readerStates;
        synchronized (lruCache) {
            this.readerStates.clear();
        }
    }

    IndexSearcher createSpellSearcher(List<String> catalogList, ExecutorService executor) throws IOException {
        if (catalogList == null || catalogList.isEmpty()) {
            return null;
        }
        ArrayList<IndexReader> spellReaders = new ArrayList<IndexReader>();
        ArrayList<String> catalogCol = new ArrayList<String>();
        Collection<IndexReaderContainer> containerList = this.getIndexReaderContainer(catalogList);
        for (IndexReaderContainer readerContainer : containerList) {
            IndexReader reader = readerContainer.getSpellReader();
            if (reader == null) continue;
            spellReaders.add(reader);
            catalogCol.add(readerContainer.getCatalogName());
        }
        return this.getIndexSearcher(executor, spellReaders, catalogCol, this.spellSearchers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private IndexSearcher getIndexSearcher(ExecutorService executor, Collection<IndexReader> spellReaders, List<String> catalogCol, Map<List<String>, IndexSearcher> spellSearchers) throws IOException {
        if (catalogCol.isEmpty()) {
            return null;
        }
        List<String> catalogs = Collections.unmodifiableList(catalogCol);
        Map<List<String>, IndexSearcher> map = spellSearchers;
        synchronized (map) {
            IndexSearcher spellSearcher = spellSearchers.get(catalogs);
            if (spellSearcher == null) {
                IndexReader[] readers = spellReaders.toArray(new IndexReader[0]);
                MultiReader multiReader = new MultiReader(readers, false);
                spellSearcher = new IndexSearcher(multiReader, (Executor)executor);
                spellSearcher.setSimilarity(new BooleanSimilarity());
                spellSearchers.put(catalogs, spellSearcher);
            }
            return spellSearcher;
        }
    }

    IndexSearcher createRelatedWordsSearcher(List<String> catalogList, ExecutorService executor) throws IOException {
        if (catalogList == null || catalogList.isEmpty()) {
            return null;
        }
        ArrayList<IndexReader> relatedReaders = new ArrayList<IndexReader>();
        ArrayList<String> catalogCol = new ArrayList<String>();
        Collection<IndexReaderContainer> containerList = this.getIndexReaderContainer(catalogList);
        for (IndexReaderContainer readerContainer : containerList) {
            IndexReader reader = readerContainer.getRelatedReader();
            if (reader == null) continue;
            relatedReaders.add(reader);
            catalogCol.add(readerContainer.getCatalogName());
        }
        return this.getIndexSearcher(executor, relatedReaders, catalogCol, this.relatedSearchers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IndexReaderContainer.LoadingState load(String catalogName, String indexPath, boolean preload, boolean onlySearchIndex, float boost, IIndexManager.IIndexIDRangeProvider baseDocId) {
        IndexReaderContainer.LoadingState state = IndexReaderContainer.LoadingState.None;
        IndexReaderContainer container = this.getIndexReaderContainer(catalogName);
        if (container != null) {
            IndexReaderData readerData;
            Object object;
            Map<List<String>, Object> usedCatalogs;
            IndexReaderData oldReaderData = this.getIndexReaderData(container.getIndexReaderNoWait());
            if (oldReaderData != null) {
                usedCatalogs = oldReaderData.getUsedCatalogNames();
                Map<String, Set<String>> map = this.catalogToContainingCatalogs;
                synchronized (map) {
                    object = usedCatalogs.iterator();
                    while (object.hasNext()) {
                        String catalog = object.next();
                        Set<String> usedIn = this.catalogToContainingCatalogs.get(catalog);
                        if (usedIn == null) continue;
                        usedIn.remove(oldReaderData.getCatalogName());
                        if (!usedIn.isEmpty()) continue;
                        this.catalogToContainingCatalogs.remove(catalog);
                    }
                }
            }
            if ((state = indexPath.isEmpty() ? container.unload() : container.load(indexPath, preload, onlySearchIndex, boost, baseDocId, this.dataByReader)) == IndexReaderContainer.LoadingState.Reloaded || state == IndexReaderContainer.LoadingState.Unloaded) {
                usedCatalogs = this.readerStates;
                synchronized (usedCatalogs) {
                    this.readerStates.entrySet().removeIf(entry -> ((Collection)entry.getKey()).contains(catalogName));
                }
                usedCatalogs = this.indexSearchers;
                synchronized (usedCatalogs) {
                    Iterator<Map.Entry<List<String>, IIndexManager.IndexSearcherContainer>> iter = this.indexSearchers.entrySet().iterator();
                    block19: while (iter.hasNext()) {
                        Map.Entry<List<String>, IIndexManager.IndexSearcherContainer> entry2 = iter.next();
                        for (String catalog : entry2.getKey()) {
                            if (!catalog.equals(catalogName)) continue;
                            entry2.getValue().close();
                            iter.remove();
                            continue block19;
                        }
                    }
                }
                usedCatalogs = this.spellSearchers;
                synchronized (usedCatalogs) {
                    this.updateSearchers(catalogName, this.spellSearchers);
                }
                usedCatalogs = this.relatedSearchers;
                synchronized (usedCatalogs) {
                    this.updateSearchers(catalogName, this.relatedSearchers);
                }
            }
            if (state != IndexReaderContainer.LoadingState.UpToDate && (readerData = this.getIndexReaderData(container.getIndexReader())) != null) {
                Set<String> usedCatalogs2 = readerData.getUsedCatalogNames();
                object = this.catalogToContainingCatalogs;
                synchronized (object) {
                    for (String catalog : usedCatalogs2) {
                        Set usedIn = this.catalogToContainingCatalogs.computeIfAbsent(catalog, k -> new HashSet());
                        usedIn.add(readerData.getCatalogName());
                    }
                }
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> mapToContainingCatalogs(List<String> catalogs) {
        HashSet<String> mappedCatalogs = new HashSet<String>();
        Map<String, Set<String>> map = this.catalogToContainingCatalogs;
        synchronized (map) {
            for (String catalog : catalogs) {
                Set<String> usedIn = this.catalogToContainingCatalogs.get(catalog);
                if (usedIn != null) {
                    mappedCatalogs.addAll(usedIn);
                    if (usedIn.size() <= 1) continue;
                    mappedCatalogs.remove(catalog);
                    continue;
                }
                mappedCatalogs.add(catalog);
            }
        }
        return mappedCatalogs.stream().toList();
    }

    private void updateSearchers(String catalogName, Map<List<String>, IndexSearcher> relatedSearchers) {
        Iterator<Map.Entry<List<String>, IndexSearcher>> iter = relatedSearchers.entrySet().iterator();
        block2: while (iter.hasNext()) {
            Map.Entry<List<String>, IndexSearcher> entry = iter.next();
            for (String catalog : entry.getKey()) {
                if (!catalog.equals(catalogName)) continue;
                try {
                    entry.getValue().getIndexReader().close();
                }
                catch (IOException e) {
                    logger.error(e.toString());
                }
                iter.remove();
                continue block2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void shutdown() {
        Map<Object, Object> map = this.indexReaders;
        synchronized (map) {
            for (IndexReaderContainer ir : this.indexReaders.values()) {
                ir.close();
            }
            this.indexReaders.clear();
        }
        map = this.dataByReader;
        synchronized (map) {
            this.dataByReader.clear();
        }
    }

    private static class LruCache
    extends LinkedHashMap<Collection<String>, SortedSetDocValuesReaderState[]> {
        private final int cacheSize;

        public LruCache(int cacheSize) {
            super(1, 0.8f, true);
            this.cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Collection<String>, SortedSetDocValuesReaderState[]> eldest) {
            return this.size() >= this.cacheSize;
        }
    }

    private static class IndexSearcherContainer
    extends IIndexManager.IndexSearcherContainer {
        private IndexSearcherContainer() {
        }

        @Override
        public IIndexManager.BoostRange[] getCatalogBoosts() {
            ArrayList<IIndexManager.BoostRange> boostList = new ArrayList<IIndexManager.BoostRange>();
            IndexReader indexReader = this.multiReader;
            if (indexReader instanceof CatalogMappingIndexReader) {
                CatalogMappingIndexReader mappingIndexReader = (CatalogMappingIndexReader)indexReader;
                FieldDefinitions.CatalogBoost[] catalogBoosts = FieldDefinitions.catalogBoost;
                if (catalogBoosts != null && catalogBoosts.length != 0) {
                    for (FieldDefinitions.CatalogBoost catBoost : catalogBoosts) {
                        if (catBoost == null) continue;
                        List<CatalogMappingIndexReader.Range> rangeList = mappingIndexReader.getDocIdRange(catBoost.catalog, catBoost.byPrefix);
                        for (CatalogMappingIndexReader.Range range : rangeList) {
                            IIndexManager.BoostRange boostRange = new IIndexManager.BoostRange();
                            boostRange.low = range.lowBorder;
                            boostRange.up = range.upperBorder;
                            boostRange.boost = catBoost.boost;
                            boostList.add(boostRange);
                        }
                    }
                }
            }
            Object[] boostArray = boostList.toArray(new IIndexManager.BoostRange[0]);
            Arrays.sort(boostArray);
            return boostArray;
        }

        public boolean hasCatalogBoosts() {
            IndexReader indexReader = this.multiReader;
            if (indexReader instanceof CatalogMappingIndexReader) {
                CatalogMappingIndexReader mappingIndexReader = (CatalogMappingIndexReader)indexReader;
                FieldDefinitions.CatalogBoost[] catalogBoosts = FieldDefinitions.catalogBoost;
                if (catalogBoosts != null) {
                    for (FieldDefinitions.CatalogBoost boost : catalogBoosts) {
                        if (boost == null) continue;
                        for (String catalog : mappingIndexReader.getCatalogList()) {
                            boolean matches = boost.byPrefix ? catalog.startsWith(boost.catalog) : catalog.equals(boost.catalog);
                            if (!matches) continue;
                            return true;
                        }
                    }
                }
            }
            return false;
        }
    }
}

