/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.io;

import de.cadenas.catalogsearch.api.ITreePathIndex;
import de.cadenas.util.PDataStream;
import de.cadenas.util.PLogger;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;

public class TreePathIndex
implements ITreePathIndex {
    private static final PLogger logger = new PLogger(TreePathIndex.class.getSimpleName());
    private final String defaultCatalogPath;
    private int[] docIdToPathId = null;
    private PathItem[] pathIdToItem = null;
    private Object2IntMap<PathItem> pathLookup = null;
    private Int2ObjectMap<IntList> additionalPathIds = null;

    public TreePathIndex(String catalogName) {
        this.defaultCatalogPath = catalogName;
    }

    private boolean loadV1(PDataStream stream, String filePath) {
        int pathCount;
        int headerSize = stream.readVInt();
        int maxDocId = stream.readInt();
        TreePathIndex.readAndIgnore(stream, 4, headerSize);
        if (maxDocId > 50000000) {
            logger.error("max docId in " + filePath + " is " + maxDocId + ". The index might be broken");
        }
        if ((pathCount = stream.readInt()) > 50000000) {
            logger.error("path count in " + filePath + " is " + pathCount + ". The index might be broken");
        }
        this.pathLookup = new Object2IntOpenHashMap<PathItem>();
        this.docIdToPathId = new int[maxDocId + 1];
        this.pathIdToItem = new PathItem[pathCount];
        this.additionalPathIds = new Int2ObjectOpenHashMap<IntList>();
        this.pathLookup.defaultReturnValue(-1);
        Arrays.fill(this.docIdToPathId, -1);
        for (int i = 0; i < pathCount; ++i) {
            PathItem item;
            String name = stream.readVString();
            int parentId = stream.readInt();
            TreePathIndex.readAndIgnore(stream, 0, stream.readVInt());
            this.pathIdToItem[i] = item = new PathItem(parentId, name);
            this.pathLookup.put(item, i);
            int lineCount = stream.readVInt();
            for (int l = 0; l < lineCount; ++l) {
                if (stream.atEnd()) {
                    logger.error("file incomplete " + filePath);
                    return false;
                }
                stream.readInt();
                int docId = stream.readInt();
                TreePathIndex.readAndIgnore(stream, 0, stream.readVInt());
                if (docId > maxDocId) {
                    logger.error("docId (" + docId + ") > maxDocId (" + maxDocId + ") in " + filePath);
                    continue;
                }
                if (this.docIdToPathId[docId] == -1) {
                    this.docIdToPathId[docId] = i;
                    continue;
                }
                if (this.additionalPathIds == null) {
                    this.additionalPathIds = new Int2ObjectOpenHashMap<IntList>();
                }
                IntList list = this.additionalPathIds.computeIfAbsent(docId, f -> new IntArrayList());
                list.add(i);
            }
        }
        return true;
    }

    public static void readAndIgnore(PDataStream stream, int sizeRead, int sizeExpected) {
        while (sizeRead < sizeExpected) {
            stream.readByte();
            ++sizeRead;
        }
    }

    public boolean load(String filePath) {
        boolean ret = false;
        File file = new File(filePath);
        try (FileInputStream inputStream = new FileInputStream(file);){
            byte[] data = new byte[(int)file.length()];
            if (inputStream.read(data) > 0) {
                PDataStream stream = new PDataStream(data, 0, data.length);
                int version = stream.readInt();
                stream.readInt();
                if (version == 1) {
                    ret = this.loadV1(stream, filePath);
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        return ret;
    }

    @Override
    public int getPathId(String treePath) {
        String[] parts;
        int parentId = -1;
        if (this.pathLookup == null) {
            return parentId;
        }
        for (String part : parts = treePath.split("/")) {
            if ((parentId = this.pathLookup.getInt(new PathItem(parentId, part))) != -1) continue;
            return -1;
        }
        return parentId;
    }

    @Override
    public int getFirstPathId(int docId) {
        if (this.docIdToPathId == null || docId < 0 || docId > this.docIdToPathId.length) {
            return -1;
        }
        return this.docIdToPathId[docId];
    }

    public int getParentId(int pathId) {
        if (pathId < 0 || pathId > this.pathIdToItem.length) {
            return -1;
        }
        return this.pathIdToItem[pathId].parentId;
    }

    public String getPath(int pathId) {
        if (this.pathIdToItem == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        while (pathId != -1) {
            if (pathId < 0 || pathId > this.pathIdToItem.length) {
                return null;
            }
            PathItem item = this.pathIdToItem[pathId];
            if (!builder.isEmpty()) {
                builder.insert(0, '/');
            }
            builder.insert(0, item.name);
            pathId = item.parentId;
        }
        return builder.toString();
    }

    @Override
    public String getName(int pathId) {
        if (this.pathIdToItem == null || pathId < 0 || pathId > this.pathIdToItem.length) {
            return null;
        }
        return this.pathIdToItem[pathId].name;
    }

    @Override
    public void findMatchingChildPath(int parentId, int docId, IntSet childIds) {
        int pathId = this.getFirstPathId(docId);
        if (pathId != -1) {
            IntList addIdList;
            this.findMatchingChildPathHelper(parentId, pathId, childIds);
            if (this.additionalPathIds != null && !this.additionalPathIds.isEmpty() && (addIdList = (IntList)this.additionalPathIds.get(docId)) != null) {
                IntListIterator intListIterator = addIdList.iterator();
                while (intListIterator.hasNext()) {
                    int pId = (Integer)intListIterator.next();
                    this.findMatchingChildPathHelper(parentId, pId, childIds);
                }
            }
        }
    }

    private void findMatchingChildPathHelper(int parentId, int pathId, IntSet childIds) {
        while (pathId != -1) {
            int pId = this.getParentId(pathId);
            if (pId == parentId) {
                childIds.add(pathId);
                break;
            }
            pathId = pId;
        }
    }

    public static class PathItem {
        int parentId;
        String name;

        public PathItem(int parentId, String name) {
            this.parentId = parentId;
            this.name = name;
        }

        public int hashCode() {
            if (this.name != null) {
                return this.parentId + this.name.hashCode();
            }
            return this.parentId;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof PathItem) {
                PathItem item = (PathItem)object;
                if (this.parentId != item.parentId) {
                    return false;
                }
                if (this.name == null && item.name == null) {
                    return true;
                }
                if (this.name != null && item.name != null && this.name.equals(item.name)) {
                    return true;
                }
            }
            return false;
        }
    }
}

