/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.io;

import de.cadenas.catalogsearch.lucene.index.CatalogIndexer;
import de.cadenas.catalogsearch.lucene.io.TreePathIndex;
import de.cadenas.util.PDataStream;
import de.cadenas.util.PLogger;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiBits;
import org.apache.lucene.util.Bits;

public class TreePathIndexBuilder {
    private static final PLogger logger = new PLogger(CatalogIndexer.class.getSimpleName());
    private final Int2ObjectOpenHashMap<LineData> dataMap = new Int2ObjectOpenHashMap();
    private final Object2IntMap<PathItem> pathMap = new Object2IntOpenHashMap<PathItem>();
    private final List<PathItem> pathList = new ArrayList<PathItem>();

    public TreePathIndexBuilder() {
        this.pathMap.defaultReturnValue(-1);
    }

    public int readTreepathIndex(String indexPath) {
        int maxId = -1;
        File file = new File(indexPath);
        try (FileInputStream inputStream = new FileInputStream(file);){
            byte[] data = new byte[(int)file.length()];
            inputStream.read(data);
            PDataStream stream = new PDataStream(data, 0, data.length);
            int version = stream.readInt();
            if (version == 1) {
                stream.readInt();
                int headerSize = stream.readVInt();
                int maxDocId = stream.readInt();
                TreePathIndex.readAndIgnore(stream, 4, headerSize);
                int pathCount = stream.readInt();
                for (int i = 0; i < pathCount; ++i) {
                    String name = stream.readVString();
                    int parentId = stream.readInt();
                    TreePathIndex.readAndIgnore(stream, 0, stream.readVInt());
                    PathItem pathItem = new PathItem(parentId, name);
                    int lineCount = stream.readVInt();
                    if (lineCount > 0) {
                        pathItem.data = new ArrayList<LineData>();
                    }
                    for (int l = 0; l < lineCount; ++l) {
                        int persistentId = stream.readInt();
                        int docId = stream.readInt();
                        TreePathIndex.readAndIgnore(stream, 0, stream.readVInt());
                        LineData item = new LineData();
                        item.persistentId = persistentId;
                        this.dataMap.put(persistentId, item);
                        pathItem.data.add(item);
                        if (persistentId <= maxId) continue;
                        maxId = persistentId;
                    }
                    this.pathMap.put(pathItem, this.pathList.size());
                    this.pathList.add(pathItem);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return maxId;
    }

    public synchronized void addLineData(String treePath, int presistantId) {
        String[] itemNames;
        LineData data = this.dataMap.computeIfAbsent(presistantId, k -> new LineData());
        PathItem searchKey = new PathItem(-1, null);
        int parentId = -1;
        for (String itemName : itemNames = treePath.split("/")) {
            searchKey.parentId = parentId;
            searchKey.name = itemName;
            int pathId = this.pathMap.getInt(searchKey);
            if (pathId == -1) {
                pathId = this.pathList.size();
                PathItem newItem = new PathItem(parentId, itemName);
                this.pathMap.put(newItem, pathId);
                this.pathList.add(newItem);
            }
            parentId = pathId;
        }
        if (parentId != -1) {
            PathItem pathItem = this.pathList.get(parentId);
            List<LineData> dataList = pathItem.data;
            if (dataList == null) {
                pathItem.data = dataList = new ArrayList<LineData>();
            }
            dataList.add(data);
        }
    }

    public synchronized void buildIndex(IndexReader reader, String outPath) {
        try (FileOutputStream outputStream = new FileOutputStream(outPath);){
            PDataStream stream = new PDataStream(outputStream);
            int maxDocId = 0;
            int count = reader.maxDoc();
            Bits bits = MultiBits.getLiveDocs(reader);
            for (int i = 0; i < count; ++i) {
                try {
                    Document doc;
                    if (bits != null && !bits.get(i) || (doc = reader.document(i)) == null) continue;
                    int persistentId = -1;
                    String persIdValue = doc.get("persid");
                    if (persIdValue == null) continue;
                    try {
                        if (persIdValue.startsWith("v")) continue;
                        persistentId = Integer.parseInt(persIdValue);
                    }
                    catch (NumberFormatException nfe) {
                        continue;
                    }
                    LineData lineData = this.dataMap.get(persistentId);
                    if (lineData == null) continue;
                    lineData.persistentId = persistentId;
                    lineData.docId = i;
                    if (i <= maxDocId) continue;
                    maxDocId = i;
                    continue;
                }
                catch (Exception doc) {
                    // empty catch block
                }
            }
            int version = 1;
            int subVersion = 0;
            stream.write(version);
            stream.write(subVersion);
            stream.writeVInt(4);
            stream.write(maxDocId);
            stream.write(this.pathList.size());
            for (PathItem item : this.pathList) {
                stream.writeVString(item.name);
                stream.write(item.parentId);
                stream.writeVInt(0);
                List<LineData> lineList = item.data;
                if (lineList != null) {
                    int lineCount = 0;
                    for (LineData lineData : lineList) {
                        if (lineData.docId == -1) continue;
                        ++lineCount;
                    }
                    stream.writeVInt(lineCount);
                    for (LineData lineData : lineList) {
                        if (lineData.docId == -1) continue;
                        stream.write(lineData.persistentId);
                        stream.write(lineData.docId);
                        stream.writeVInt(0);
                    }
                    continue;
                }
                stream.writeVInt(0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class PathItem {
        int parentId;
        String name;
        List<LineData> data;

        public PathItem(int parentId, String name) {
            this.parentId = parentId;
            this.name = name;
            this.data = null;
        }

        public int hashCode() {
            if (this.name != null) {
                return this.parentId + this.name.hashCode();
            }
            return this.parentId;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof PathItem) {
                PathItem item = (PathItem)object;
                if (this.parentId != item.parentId) {
                    return false;
                }
                if (this.name == null && item.name == null) {
                    return true;
                }
                if (this.name != null && item.name != null && this.name.equals(item.name)) {
                    return true;
                }
            }
            return false;
        }
    }

    private static class LineData {
        int persistentId = -1;
        int docId = -1;

        private LineData() {
        }
    }
}

