/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser;

import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;

public class BooleanQueryBuilder {
    public static final int CONJ_NONE = 0;
    public static final int CONJ_AND = 1;
    public static final int CONJ_OR = 2;
    public static final int MOD_NONE = 0;
    public static final int MOD_NOT = 10;
    private BooleanQuery.Builder builder = null;
    private Query query = null;
    private boolean negate = false;
    private BooleanClause.Occur occur;

    public BooleanQueryBuilder() {
        this(BooleanClause.Occur.MUST);
    }

    public BooleanQueryBuilder(BooleanClause.Occur o) {
        this.occur = o;
    }

    public void clear() {
        this.builder = null;
        this.query = null;
        this.occur = BooleanClause.Occur.MUST;
        this.negate = false;
    }

    public void add(Query pq) {
        if (pq == null) {
            return;
        }
        this.processLastQuery();
        this.query = pq;
    }

    public void add(Query pq, boolean not) {
        if (pq == null) {
            return;
        }
        this.processLastQuery();
        this.query = pq;
        this.negate = not;
    }

    public void add(Query pq, float boost) {
        if (pq == null) {
            return;
        }
        this.processLastQuery();
        Query q = boost != 1.0f ? new BoostQuery(pq, boost) : pq;
        this.query = q;
    }

    public boolean isEmpty() {
        return this.query == null;
    }

    public Query build() {
        if (this.builder == null && !this.negate) {
            return this.query;
        }
        this.processLastQuery();
        return this.builder.build();
    }

    private void processLastQuery() {
        if (this.query != null) {
            if (this.builder == null) {
                this.builder = new BooleanQuery.Builder();
            }
            BooleanClause.Occur oc = this.occur;
            if (this.negate) {
                if (this.occur == BooleanClause.Occur.MUST) {
                    oc = BooleanClause.Occur.MUST_NOT;
                } else {
                    BooleanQueryBuilder builder = new BooleanQueryBuilder();
                    MatchAllDocsQuery mad = new MatchAllDocsQuery();
                    builder.add(mad);
                    builder.add(this.query, true);
                    this.query = builder.build();
                }
            }
            this.builder.add(this.query, oc);
            this.query = null;
            this.negate = false;
        }
    }
}

