/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser;

import de.cadenas.catalogsearch.lucene.queryparser.TokenType;
import de.cadenas.util.NumUtils;

public class LexerToken {
    public String data = "";
    public double number = Double.NaN;
    public String unit = "";
    public TokenType type = TokenType.TT_UNKNOWN;
    public boolean whitespacePrefix = false;
    public int begin = -1;
    public int end = -1;

    public LexerToken(String data, TokenType type) {
        this.data = data;
        this.type = type;
    }

    public LexerToken(String data, TokenType type, int begin, int end) {
        this.data = data;
        this.type = type;
        this.begin = begin;
        this.end = end;
    }

    public LexerToken(char data, TokenType type) {
        this.data = String.valueOf(data);
        this.type = type;
    }

    void setWhitespacePrefix() {
        this.whitespacePrefix = true;
    }

    public double toNumber() {
        if (Double.isNaN(this.number)) {
            this.number = NumUtils.getNumeric(this.data);
        }
        return this.number;
    }

    public int toInteger() {
        return NumUtils.getInteger(this.data);
    }

    public Operator toOperator() {
        return switch (this.data) {
            case "=", "==" -> Operator.EQ;
            case "<" -> Operator.LT;
            case "<=", "=<" -> Operator.LE;
            case ">" -> Operator.GT;
            case ">=", "=>" -> Operator.GE;
            case "<>", "!=" -> Operator.NE;
            case "x-y" -> Operator.RANGE;
            default -> Operator.INVALID;
        };
    }

    public String toString() {
        return this.data;
    }

    static enum Operator {
        EQ,
        LT,
        LE,
        GT,
        GE,
        NE,
        RANGE,
        INVALID;

    }
}

