/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser;

import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.analysis.filter.WordDelimiterIterator;
import de.cadenas.catalogsearch.lucene.analysis.helper.TokenFlags;
import de.cadenas.catalogsearch.lucene.exceptions.ParseException;
import de.cadenas.catalogsearch.lucene.exceptions.UserInputException;
import de.cadenas.catalogsearch.lucene.exceptions.VariableNotAllowedException;
import de.cadenas.catalogsearch.lucene.index.ErpConfiguration;
import de.cadenas.catalogsearch.lucene.queryparser.BooleanQueryBuilder;
import de.cadenas.catalogsearch.lucene.queryparser.LexerToken;
import de.cadenas.catalogsearch.lucene.queryparser.QueryLexer;
import de.cadenas.catalogsearch.lucene.queryparser.QueryParserData;
import de.cadenas.catalogsearch.lucene.queryparser.SearchField;
import de.cadenas.catalogsearch.lucene.queryparser.TokenType;
import de.cadenas.catalogsearch.lucene.queryparser.boost.PSolBoost;
import de.cadenas.catalogsearch.lucene.queryparser.boost.PSolExactBoost;
import de.cadenas.catalogsearch.lucene.queryparser.boost.PSolStandardBoost;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQuery;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemBoost;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemDoc;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemExact;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemOr;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemPhrase;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemPrefix;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemTerm;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemTermList;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemWildcard;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemWrapper;
import de.cadenas.catalogsearch.lucene.search.ValueRangeQuery;
import de.cadenas.util.NumUtils;
import de.cadenas.util.PGenericPair;
import de.cadenas.util.PLazyInit;
import de.cadenas.util.PLogger;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.QueryBuilder;

public class QueryParser
extends QueryBuilder {
    private static final PLogger logger = new PLogger(QueryParser.class.getSimpleName());
    private boolean searchDocuments = false;
    private AtomicLong wildcardCostLimit = null;

    public QueryParser(Analyzer analyzer) {
        super(analyzer);
    }

    public void setSearchDocuments(boolean searchDocuments) {
        this.searchDocuments = searchDocuments;
    }

    public Query parse(String query, List<String> languageList, String erpGroup) throws UserInputException {
        if (query.isEmpty()) {
            return null;
        }
        QueryLexer lexer = new QueryLexer(query);
        List<LexerToken> tokens = lexer.getTokens();
        if (tokens.isEmpty()) {
            return null;
        }
        return this.parse(tokens, languageList, erpGroup);
    }

    public Query parse(List<LexerToken> tokens, List<String> languageList, String erpGroup) throws UserInputException {
        QueryItem result;
        if (tokens.size() == 1) {
            LexerToken token = tokens.get(0);
            if (token.type == TokenType.TT_TERM_WILDCARD) {
                boolean valid = false;
                for (int i = 0; i < token.data.length(); ++i) {
                    char ch = token.data.charAt(i);
                    if (ch == '?' || ch == '*') continue;
                    valid = true;
                    break;
                }
                if (!valid) {
                    return null;
                }
            }
        }
        if ((result = this.matchQuery(new QueryParserData(tokens, languageList, erpGroup))) == null) {
            return null;
        }
        if (result.negate && result.query != null) {
            BooleanQueryBuilder builder = new BooleanQueryBuilder();
            builder.add((Query)new MatchAllDocsQuery(), true);
            builder.add(result.query, true);
            result.query = builder.build();
        }
        return result.query;
    }

    private QueryItem matchQuery(QueryParserData data) throws UserInputException {
        QueryItem queryItem;
        ArrayList<QueryItem> subQueryList = new ArrayList<QueryItem>();
        while (!data.isEof() && data.peekNextTokenType() != TokenType.TT_RPAREN) {
            int conjunction = this.matchConjunction(data);
            int modifier = this.matchModifier(data);
            if (conjunction != 0) {
                subQueryList.add(new QueryItem(conjunction));
            }
            if ((queryItem = this.matchClause(data)) == null) continue;
            if (modifier == 10) {
                queryItem.negate = true;
            }
            subQueryList.add(queryItem);
        }
        if (!this.checkOperators(subQueryList)) {
            throw new ParseException(UserInputException.NO.InvalidOperator, "", -1, new Object[0]);
        }
        int bgn = 0;
        for (int i = 0; i < subQueryList.size(); ++i) {
            queryItem = (QueryItem)subQueryList.get(i);
            if (!queryItem.isOperator()) continue;
            if (i > bgn) {
                i = this.combineQueryItems(subQueryList, bgn, i);
            }
            bgn = i + 1;
        }
        this.combineQueryItems(subQueryList, bgn, subQueryList.size());
        this.combineANDQueries(subQueryList);
        this.combineORQueries(subQueryList);
        if (subQueryList.size() > 1) {
            throw new ParseException(UserInputException.NO.InvalidQuery, "", -1, new Object[0]);
        }
        if (subQueryList.size() == 1) {
            return (QueryItem)subQueryList.get(0);
        }
        return null;
    }

    private boolean checkOperators(List<QueryItem> subQueryList) {
        if (subQueryList.isEmpty()) {
            return true;
        }
        boolean lastWasOp = true;
        for (QueryItem queryItem : subQueryList) {
            if (queryItem.isOperator() && lastWasOp) {
                return false;
            }
            lastWasOp = queryItem.isOperator();
        }
        return !lastWasOp;
    }

    private int combineQueryItems(List<QueryItem> subQueryList, int start, int end) {
        BooleanQueryBuilder builder = new BooleanQueryBuilder();
        boolean negate = false;
        int bgn = start;
        for (int i = start; i < end; ++i) {
            QueryItem queryItem = subQueryList.get(i);
            if (queryItem.subQuery != null && !queryItem.negate) continue;
            this.addSubQuery(builder, subQueryList.subList(bgn, i));
            if (queryItem.negate && end == start + 1) {
                negate = true;
                this.addSubQuery(builder, queryItem, false);
            } else {
                this.addSubQuery(builder, queryItem, queryItem.negate);
            }
            bgn = i + 1;
        }
        this.addSubQuery(builder, subQueryList.subList(bgn, end));
        QueryItem newItem = new QueryItem(builder.build(), negate);
        subQueryList.add(start, newItem);
        for (int i = start; i < end; ++i) {
            subQueryList.remove(start + 1);
        }
        return start;
    }

    private void combineANDQueries(List<QueryItem> subQueryList) {
        this.combineANDorORQueries(subQueryList, 1, BooleanClause.Occur.MUST);
    }

    private void combineORQueries(List<QueryItem> subQueryList) {
        this.combineANDorORQueries(subQueryList, 2, BooleanClause.Occur.SHOULD);
    }

    private void combineANDorORQueries(List<QueryItem> subQueryList, int conjunction, BooleanClause.Occur occur) {
        BooleanQueryBuilder builder = new BooleanQueryBuilder(occur);
        int i = 1;
        while (i + 1 < subQueryList.size()) {
            QueryItem queryItem = subQueryList.get(i);
            if (queryItem.conjunction == conjunction) {
                int iStart = i - 1;
                builder.add(subQueryList.get((int)(i - 1)).query, subQueryList.get((int)(i - 1)).negate);
                builder.add(subQueryList.get((int)(i + 1)).query, subQueryList.get((int)(i + 1)).negate);
                while (i + 2 < subQueryList.size() && subQueryList.get((int)(i + 2)).conjunction == conjunction) {
                    builder.add(subQueryList.get((int)(i + 3)).query, subQueryList.get((int)(i + 3)).negate);
                    i += 2;
                }
                for (int c = iStart; c <= i + 1; ++c) {
                    subQueryList.remove(iStart);
                }
                Query subQuery = builder.build();
                subQueryList.add(iStart, new QueryItem(subQuery));
                builder.clear();
                continue;
            }
            ++i;
        }
    }

    private int matchModifier(QueryParserData data) {
        if (data.isEof()) {
            return 0;
        }
        TokenType type = data.peekNextTokenType();
        if (type == TokenType.TT_NOT) {
            data.removeNextToken();
            return 10;
        }
        return 0;
    }

    private int matchConjunction(QueryParserData data) {
        if (data.isEof()) {
            return 0;
        }
        TokenType type = data.peekNextTokenType();
        if (type == TokenType.TT_AND) {
            data.removeNextToken();
            return 1;
        }
        if (type == TokenType.TT_OR) {
            data.removeNextToken();
            return 2;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private QueryItem matchClause(QueryParserData data) throws UserInputException {
        if (data.isEof()) {
            return null;
        }
        QueryItem queryItem = null;
        if (data.peekNextTokenType() != TokenType.TT_LPAREN) return this.matchTerm(data);
        data.removeNextToken();
        queryItem = this.matchQuery(data);
        if (data.peekNextTokenType() != TokenType.TT_RPAREN) throw new ParseException(UserInputException.NO.MissingBracket, "", -1, new Object[0]);
        data.removeNextToken();
        return queryItem;
    }

    private String parseUnitInRange(QueryParserData data) throws UserInputException {
        LexerToken token = data.takeNextToken();
        if (data.peekNextTokenType() != TokenType.TT_RBRACKET) {
            throw new ParseException(UserInputException.NO.MissingBracket, "", -1, new Object[0]);
        }
        return token.data;
    }

    private void parseNumericUpperRangePart(QueryParserData data, NumericRangeData ret) throws UserInputException {
        data.takeNextToken();
        boolean preferInch = false;
        boolean negative = false;
        if (data.peekNextTokenType() == TokenType.TT_MINUS && !data.peekNextToken((int)1).whitespacePrefix) {
            data.takeNextToken();
            negative = true;
        }
        if (data.peekNextTokenType() == TokenType.TT_TERM_NUMBER) {
            ret.operator = LexerToken.Operator.RANGE;
            LexerToken secondNum = data.takeNextToken();
            ret.to = NumUtils.getNumeric(secondNum.data);
            if (data.peekNextTokenType() == TokenType.TT_TERM) {
                LexerToken numToken = this.convertToNumericToken(data.peekNextToken());
                if (numToken != null) {
                    data.takeNextToken();
                    ret.to += numToken.number;
                    preferInch = true;
                    if (data.peekNextTokenType() == TokenType.TT_TERM) {
                        ret.unit = this.parseUnitInRange(data);
                    } else if (data.peekNextTokenType() != TokenType.TT_RBRACKET) {
                        throw new ParseException(UserInputException.NO.MissingBracket, "", -1, new Object[0]);
                    }
                } else {
                    ret.unit = this.parseUnitInRange(data);
                }
            } else if (data.peekNextTokenType() != TokenType.TT_RBRACKET) {
                throw new ParseException(UserInputException.NO.MissingBracket, "", -1, new Object[0]);
            }
        } else if (data.peekNextTokenType() == TokenType.TT_TERM) {
            LexerToken numToken = this.convertToNumericToken(data.peekNextToken());
            if (numToken == null) {
                throw new ParseException(UserInputException.NO.InvalidQuery, "", -1, new Object[0]);
            }
            data.takeNextToken();
            preferInch = true;
            ret.operator = LexerToken.Operator.RANGE;
            ret.to = numToken.number;
            if (data.peekNextTokenType() == TokenType.TT_TERM) {
                ret.unit = this.parseUnitInRange(data);
            } else if (data.peekNextTokenType() != TokenType.TT_RBRACKET) {
                throw new ParseException(UserInputException.NO.MissingBracket, "", -1, new Object[0]);
            }
        } else {
            throw new ParseException(UserInputException.NO.MissingBracket, "", -1, new Object[0]);
        }
        if (preferInch && ret.unit.isEmpty()) {
            ret.unit = "inch";
        }
        if (negative) {
            ret.to *= -1.0;
        }
    }

    private NumericRangeData matchNumericQuery(QueryParserData data) throws UserInputException {
        NumericRangeData ret = null;
        boolean preferInch = false;
        boolean negative = false;
        if (data.peekNextTokenType() == TokenType.TT_MINUS && !data.peekNextToken((int)1).whitespacePrefix) {
            data.takeNextToken();
            negative = true;
        }
        if (data.peekNextTokenType() == TokenType.TT_TERM_NUMBER) {
            LexerToken firstNum = data.takeNextToken();
            ret = new NumericRangeData();
            ret.from = NumUtils.getNumeric(firstNum.data);
            if (data.peekNextTokenType() == TokenType.TT_TERM) {
                LexerToken numToken = this.convertToNumericToken(data.peekNextToken());
                if (numToken != null) {
                    data.takeNextToken();
                    ret.from += numToken.number;
                    preferInch = true;
                    if (data.peekNextTokenType() == TokenType.TT_TERM) {
                        ret.unit = this.parseUnitInRange(data);
                    } else if (data.peekNextTokenType() == TokenType.TT_MINUS) {
                        this.parseNumericUpperRangePart(data, ret);
                    }
                } else {
                    ret.unit = this.parseUnitInRange(data);
                }
            } else if (data.peekNextTokenType() == TokenType.TT_MINUS) {
                this.parseNumericUpperRangePart(data, ret);
            }
        } else if (data.peekNextTokenType() == TokenType.TT_TERM) {
            ret = new NumericRangeData();
            PGenericPair<Double, Double> range = this.extractRangeFromToken(data.peekNextToken().data);
            if (range != null) {
                ret.from = (Double)range.first;
                ret.to = (Double)range.second;
                ret.operator = LexerToken.Operator.RANGE;
                data.takeNextToken();
                if (data.peekNextTokenType() == TokenType.TT_TERM) {
                    ret.unit = this.parseUnitInRange(data);
                } else if (data.peekNextTokenType() != TokenType.TT_RBRACKET) {
                    throw new ParseException(UserInputException.NO.MissingBracket, "", -1, new Object[0]);
                }
            } else {
                ret.unit = this.parseUnitInRange(data);
            }
        }
        data.takeNextToken();
        if (ret != null && preferInch && ret.unit.isEmpty()) {
            ret.unit = "inch";
        }
        if (ret != null && negative) {
            ret.from *= -1.0;
        }
        return ret;
    }

    private PGenericPair<Double, Double> extractRangeFromToken(String token) {
        int minusIdx = token.indexOf(45, 1);
        if (minusIdx > 0 && minusIdx < token.length() - 1) {
            double d2;
            String substr;
            double d1;
            int secondMinusIdx = token.indexOf(45, minusIdx + 1);
            if (secondMinusIdx != -1) {
                if (secondMinusIdx == token.length() - 1) {
                    return null;
                }
                if (!Character.isDigit(token.charAt(secondMinusIdx + 1))) {
                    return null;
                }
            }
            if (!Double.isNaN(d1 = NumUtils.getNumeric(substr = token.substring(0, minusIdx))) && !Double.isNaN(d2 = NumUtils.getNumeric(substr = token.substring(minusIdx + 1)))) {
                if (d1 > d2) {
                    return null;
                }
                return new PGenericPair<Double, Double>(d1, d2);
            }
        }
        return null;
    }

    private QueryItem matchTerm(QueryParserData data) throws UserInputException {
        LexerToken token = data.takeNextToken();
        if (token.type == TokenType.TT_MINUS) {
            token = this.handleMinusToken(data, token);
        }
        if (token.type == TokenType.TT_TERM_NUMBER) {
            QueryParser.handleNumberToken(data, token);
        }
        switch (token.type) {
            case TT_OPERATOR: {
                if (data.peekNextTokenType() == TokenType.TT_TERM_NUMBER) {
                    LexerToken.Operator op = token.toOperator();
                    LexerToken numToken = data.takeNextToken();
                    QueryParser.handleNumberToken(data, numToken);
                    Query query = this.createNumericRangeQuery(data.getNumericSearchFields(), op, numToken.number, 0.0, numToken.unit, false);
                    return new QueryItem(query, false);
                }
                throw new ParseException(UserInputException.NO.TextualRangesNotAllowed, "", token.begin, new Object[0]);
            }
            case TT_TERM_NUMBER: {
                LexerToken upperToken = this.extractUpperToken(data);
                if (upperToken != null) {
                    Query nquery = this.createNumericRangeQuery(data.getNumericSearchFields(), LexerToken.Operator.RANGE, token.toNumber(), upperToken.toNumber(), token.unit, false);
                    return new QueryItem(nquery, false);
                }
            }
            case TT_QUOTED_NUMBER: {
                Query query = null;
                SubQuery subQuery = null;
                if (!data.getNumericSearchFields().isEmpty()) {
                    query = this.createNumericRangeQuery(data.getNumericSearchFields(), LexerToken.Operator.EQ, token.toNumber(), 0.0, token.unit, false);
                }
                if (token.unit.isEmpty() && !data.getTextSearchFields().isEmpty() && (token.number >= 0.0 || token.type == TokenType.TT_QUOTED_NUMBER)) {
                    subQuery = new SubQuery(token, data.getTextSearchFields());
                }
                return new QueryItem(query, subQuery);
            }
            case TT_LBRACKET: {
                NumericRangeData rangeData = this.matchNumericQuery(data);
                if (rangeData == null || Double.isNaN(rangeData.from)) {
                    throw new ParseException(UserInputException.NO.InvalidQuery, "", -1, new Object[0]);
                }
                Query query = this.createNumericRangeQuery(data.getNumericSearchFields(), rangeData.operator, rangeData.from, rangeData.to, rangeData.unit, false);
                return new QueryItem(query);
            }
            case TT_TERM: {
                if (data.peekNextTokenType() == TokenType.TT_OPERATOR) {
                    QueryItem queryItem = null;
                    try {
                        queryItem = this.matchVariableSearchQuery(data, token.data);
                    }
                    catch (UserInputException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        logger.error(e);
                    }
                    return queryItem;
                }
                LexerToken numToken = this.convertToNumericToken(token);
                if (numToken != null) {
                    String unit = "";
                    if (data.peekNextTokenType() == TokenType.TT_LBRACKET) {
                        LexerToken unitToken = data.takeNextToken();
                        unit = unitToken.data;
                    }
                    LexerToken.Operator op = LexerToken.Operator.EQ;
                    double upperValue = 0.0;
                    LexerToken upperToken = this.extractUpperToken(data);
                    if (upperToken != null) {
                        upperValue = upperToken.toNumber();
                        op = LexerToken.Operator.RANGE;
                        unit = upperToken.unit;
                    }
                    Query rangeQuery = this.createNumericRangeQuery(data.getNumericSearchFields(), op, numToken.toNumber(), upperValue, unit, false);
                    SubQuery subQuery = null;
                    if (unit.isEmpty()) {
                        subQuery = new SubQuery(token, data.getTextSearchFields());
                    }
                    return new QueryItem(rangeQuery, subQuery);
                }
                return new QueryItem(new SubQuery(token, data.getTextSearchFields()));
            }
            case TT_QUOTED: 
            case TT_QUOTED_PREFIX: 
            case TT_QUOTED_ONLY: {
                if (token.data == null || token.data.isEmpty()) {
                    throw new ParseException(UserInputException.NO.EmptyToken, "", token.begin, new Object[0]);
                }
                return new QueryItem(new SubQuery(token, QueryParserData.merge(data.getTextSearchFields(), data.getPhraseSearchFields())));
            }
            case TT_TERM_PREFIX: 
            case TT_TERM_WILDCARD: {
                if (token.data == null || token.data.isEmpty()) {
                    throw new ParseException(UserInputException.NO.EmptyToken, "", token.begin, new Object[0]);
                }
                return new QueryItem(new SubQuery(token, QueryParserData.merge(data.getTextSearchFields(), data.getWildcardFields())));
            }
            case TT_TERM_MATCHALL: {
                return new QueryItem(new DocValuesFieldExistsQuery("$facets"));
            }
            case TT_EXACT: 
            case TT_EXACT_PREFIX: 
            case TT_EXACT_ONLY: {
                return new QueryItem(new SubQuery(token, data.getExactSearchFields()));
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private QueryItem matchVariableSearchQuery(QueryParserData data, String field) throws UserInputException {
        Query query = null;
        boolean negate = false;
        LexerToken opToken = data.takeNextToken();
        LexerToken.Operator op = opToken.toOperator();
        if (op == LexerToken.Operator.NE) {
            op = LexerToken.Operator.EQ;
            negate = true;
        }
        LexerToken valueToken = data.takeNextToken();
        if (valueToken.type == TokenType.TT_EOF) {
            throw new ParseException(UserInputException.NO.MissingRValue, field, valueToken.begin, new Object[0]);
        }
        if (valueToken.type == TokenType.TT_MINUS) {
            valueToken = this.handleMinusToken(data, valueToken);
            if (valueToken.type == TokenType.TT_MINUS) {
                valueToken.type = TokenType.TT_TERM;
                valueToken.data = "-";
            }
        } else if (valueToken.type == TokenType.TT_TERM_NUMBER) {
            QueryParser.handleNumberToken(data, valueToken);
        }
        List<SearchField> textFields = null;
        List<SearchField> numFields = null;
        ArrayList<SearchField> intFields = null;
        ArrayList<SearchField> wildcardFields = null;
        List<SearchField> exactFields = null;
        ArrayList<SearchField> phraseFields = null;
        FieldDefinitions.KeyWordType keyType = FieldDefinitions.KeyWordType.NoKeyWord;
        if (field.equals("catalog")) {
            field = "$catalog";
        }
        if (field.startsWith("$")) {
            Object groupName;
            String keyWord = field.substring(1);
            if (keyWord.equals("$facets")) {
                valueToken.data = valueToken.data.replace(':', '\u001f');
            }
            if ((groupName = data.getErpGroup()) != null) {
                String variableName = null;
                if (keyWord.startsWith("col_text_")) {
                    if (keyWord.endsWith("_lang")) {
                        int pos = keyWord.lastIndexOf(95, keyWord.length() - 6);
                        if (pos != -1) {
                            variableName = keyWord.substring("col_text_".length(), pos);
                        }
                    } else {
                        variableName = keyWord.substring("col_text_".length());
                    }
                } else if (keyWord.startsWith("col_number_")) {
                    variableName = keyWord.substring("col_number_".length());
                }
                if (variableName != null && ErpConfiguration.getInstance().isErpVariable(variableName) && !ErpConfiguration.getInstance().isVariableVisible(variableName, (String)groupName)) {
                    throw new VariableNotAllowedException(variableName);
                }
            }
            keyType = FieldDefinitions.getKeyWordType(keyWord);
            switch (keyType) {
                case StringKeyWord: {
                    textFields = new ArrayList<SearchField>();
                    if (FieldDefinitions.isUntokenizedField(keyWord)) {
                        textFields.add(new SearchField(keyWord, null, false, false, false));
                    } else {
                        SearchField searchField = new SearchField(keyWord);
                        String fieldLanguage = FieldDefinitions.getLanguageOfField(keyWord);
                        if (fieldLanguage != null) {
                            FieldDefinitions.evaluateLanguageFieldSettings(searchField, fieldLanguage);
                        }
                        textFields.add(searchField);
                    }
                    exactFields = FieldDefinitions.toExactFields(textFields);
                    break;
                }
                case NumericKeyWord: {
                    numFields = new ArrayList<SearchField>();
                    numFields.add(new SearchField(keyWord));
                    break;
                }
                case IntKeyWord: {
                    intFields = new ArrayList<SearchField>();
                    intFields.add(new SearchField(keyWord));
                }
            }
        } else {
            String groupName = data.getErpGroup();
            if (groupName != null && ErpConfiguration.getInstance().isErpVariable(field) && !ErpConfiguration.getInstance().isVariableVisible(field, groupName)) {
                throw new VariableNotAllowedException(field);
            }
            textFields = FieldDefinitions.getSearchFieldsForVariable(field, data.getLanguageList(), false);
            numFields = FieldDefinitions.getSearchFieldsForVariable(field, data.getLanguageList(), true);
            exactFields = FieldDefinitions.toExactFields(textFields);
            exactFields.add(new SearchField("col_text_" + field.toLowerCase() + "_exact", 2.0f));
            phraseFields = new ArrayList<SearchField>();
            phraseFields.add(new SearchField("col_text_" + field.toLowerCase() + "_exact", 1.2f));
            wildcardFields = new ArrayList<SearchField>();
            wildcardFields.add(new SearchField("col_text_" + field.toLowerCase() + "_exact"));
        }
        if (valueToken.type == TokenType.TT_LPAREN) {
            List<LexerToken> subTokens = data.takeTokensUntil(TokenType.TT_RPAREN);
            if (data.takeNextToken().type != TokenType.TT_RPAREN) {
                throw new ParseException(UserInputException.NO.MissingBracket, field, valueToken.begin, new Object[0]);
            }
            if (!subTokens.isEmpty() && subTokens.get((int)0).type == TokenType.TT_NOT) {
                subTokens.add(0, new LexerToken("AND", TokenType.TT_AND));
                subTokens.add(0, new LexerToken("*", TokenType.TT_TERM_WILDCARD));
            } else {
                for (LexerToken subTok : subTokens) {
                    if (subTok.type != TokenType.TT_TERM_MATCHALL) continue;
                    subTok.type = TokenType.TT_TERM_WILDCARD;
                }
            }
            query = this.getSubTokensQuery(data, query, textFields, numFields, wildcardFields, exactFields, phraseFields, subTokens);
            return new QueryItem(query, negate);
        } else if (valueToken.type == TokenType.TT_NOT) {
            LexerToken nextValueToken = data.takeNextToken();
            if (nextValueToken == null) {
                throw new ParseException(UserInputException.NO.InvalidQuery, field, valueToken.begin, new Object[0]);
            }
            ArrayList<LexerToken> subTokens = new ArrayList<LexerToken>();
            subTokens.add(new LexerToken("*", TokenType.TT_TERM_WILDCARD));
            subTokens.add(new LexerToken("AND", TokenType.TT_AND));
            subTokens.add(valueToken);
            subTokens.add(nextValueToken);
            query = this.getSubTokensQuery(data, query, textFields, numFields, wildcardFields, exactFields, phraseFields, subTokens);
            return new QueryItem(query, negate);
        } else if (data.peekNextTokenType() == TokenType.TT_MINUS) {
            if (valueToken.type == TokenType.TT_TERM && (valueToken = this.convertToNumericToken(valueToken)) == null) {
                throw new ParseException(UserInputException.NO.TextualRangesNotAllowed, field, -1, new Object[0]);
            }
            LexerToken valueUpToken = data.takeNextToken();
            valueUpToken = data.takeNextToken();
            if (valueUpToken.type == TokenType.TT_MINUS) {
                valueUpToken = data.takeNextToken();
            }
            if (valueUpToken.type == TokenType.TT_TERM_NUMBER) {
                QueryParser.handleNumberToken(data, valueUpToken);
            } else if (valueUpToken.type == TokenType.TT_TERM && (valueUpToken = this.convertToNumericToken(valueUpToken)) == null) {
                throw new ParseException(UserInputException.NO.TextualRangesNotAllowed, field, -1, new Object[0]);
            }
            if (valueToken.type != TokenType.TT_TERM_NUMBER || valueUpToken.type != TokenType.TT_TERM_NUMBER) throw new ParseException(UserInputException.NO.TextualRangesNotAllowed, field, -1, new Object[0]);
            if (intFields != null) {
                query = this.createIntRangeQuery(intFields, LexerToken.Operator.RANGE, valueToken.toInteger(), valueUpToken.toInteger());
                return new QueryItem(query, negate);
            } else {
                if (numFields == null) throw new ParseException(UserInputException.NO.NumericRangeOnTextField, field, valueToken.begin, new Object[0]);
                query = this.createNumericRangeQuery(numFields, LexerToken.Operator.RANGE, valueToken.toNumber(), valueUpToken.toNumber(), valueUpToken.unit, false);
            }
            return new QueryItem(query, negate);
        } else if (valueToken.type == TokenType.TT_LBRACKET) {
            NumericRangeData rangeData = this.matchNumericQuery(data);
            if (rangeData == null) {
                throw new ParseException(UserInputException.NO.InvalidQuery, field, -1, new Object[0]);
            }
            if (intFields != null) {
                query = this.createIntRangeQuery(intFields, rangeData.operator, (int)rangeData.from, (int)rangeData.to);
                return new QueryItem(query, negate);
            } else {
                if (numFields == null) throw new ParseException(UserInputException.NO.NumericRangeOnTextField, field, valueToken.begin, new Object[0]);
                query = this.createNumericRangeQuery(numFields, rangeData.operator, rangeData.from, rangeData.to, rangeData.unit, false);
            }
            return new QueryItem(query, negate);
        } else if (valueToken.type == TokenType.TT_TERM_PREFIX) {
            if (textFields == null) throw new ParseException(UserInputException.NO.PrefixQueryOnNumericField, field, valueToken.begin, new Object[0]);
            query = this.buildSubQuery(textFields, valueToken);
            return new QueryItem(query, negate);
        } else if (valueToken.type == TokenType.TT_QUOTED_PREFIX) {
            if (textFields == null) throw new ParseException(UserInputException.NO.PrefixQueryOnNumericField, field, valueToken.begin, new Object[0]);
            query = this.buildSubQuery(QueryParserData.merge(textFields, phraseFields), valueToken);
            return new QueryItem(query, negate);
        } else if (valueToken.type == TokenType.TT_TERM_WILDCARD || valueToken.type == TokenType.TT_TERM_MATCHALL) {
            if (textFields == null) throw new ParseException(UserInputException.NO.WildcardQueryOnNumericField, field, valueToken.begin, new Object[0]);
            query = this.buildSubQuery(QueryParserData.merge(textFields, wildcardFields), valueToken);
            return new QueryItem(query, negate);
        } else if (valueToken.type == TokenType.TT_QUOTED || valueToken.type == TokenType.TT_QUOTED_ONLY) {
            if (textFields == null) throw new ParseException(UserInputException.NO.QuotedQueryOnNumericField, field, -1, new Object[0]);
            query = this.buildSubQuery(QueryParserData.merge(textFields, phraseFields), valueToken);
            return new QueryItem(query, negate);
        } else if (valueToken.type == TokenType.TT_EXACT || valueToken.type == TokenType.TT_EXACT_ONLY) {
            double numValue;
            Query tquery = null;
            Query nquery = null;
            if (exactFields != null) {
                tquery = this.buildSubQuery(exactFields, valueToken);
            }
            if (numFields != null && !Double.isNaN(numValue = NumUtils.getNumeric(valueToken.data))) {
                nquery = this.createNumericRangeQuery(numFields, LexerToken.Operator.EQ, numValue, 0.0, "", true);
            }
            if (tquery == null) {
                query = nquery;
                return new QueryItem(query, negate);
            } else if (nquery == null) {
                query = tquery;
                return new QueryItem(query, negate);
            } else {
                BooleanQueryBuilder bq = new BooleanQueryBuilder(BooleanClause.Occur.SHOULD);
                bq.add(tquery);
                bq.add(nquery);
                query = bq.build();
            }
            return new QueryItem(query, negate);
        } else if (valueToken.type == TokenType.TT_EXACT_PREFIX) {
            if (exactFields == null) throw new ParseException(UserInputException.NO.ExactQueryOnNumericField, field, valueToken.begin, new Object[0]);
            query = this.buildSubQuery(exactFields, valueToken);
            return new QueryItem(query, negate);
        } else if (valueToken.type == TokenType.TT_TERM) {
            boolean executeTextSearch = true;
            if (numFields != null) {
                PGenericPair<Double, Double> range = null;
                LexerToken.Operator rangeOp = LexerToken.Operator.RANGE;
                LexerToken numToken = this.convertToNumericToken(valueToken);
                if (numToken != null) {
                    range = new PGenericPair<Double, Double>(numToken.number, numToken.number);
                    rangeOp = LexerToken.Operator.EQ;
                }
                if (range != null) {
                    String unit = "";
                    if (data.peekNextTokenType() == TokenType.TT_LBRACKET) {
                        data.takeNextToken();
                        LexerToken unitToken = data.takeNextToken();
                        unit = unitToken.data;
                        if (data.peekNextTokenType() != TokenType.TT_RBRACKET) {
                            throw new ParseException(UserInputException.NO.MissingBracket, "", -1, new Object[0]);
                        }
                        data.takeNextToken();
                    }
                    Query rangeQuery = this.createNumericRangeQuery(numFields, rangeOp, (Double)range.first, (Double)range.second, unit, false);
                    executeTextSearch = false;
                    if (unit.isEmpty() && textFields != null) {
                        query = this.buildSubQuery(textFields, valueToken);
                        BooleanQueryBuilder builder = new BooleanQueryBuilder(BooleanClause.Occur.SHOULD);
                        builder.add(query, 1.0f);
                        builder.add(rangeQuery, 1.0f);
                        query = builder.build();
                    } else {
                        query = rangeQuery;
                    }
                }
            }
            if (textFields == null || op != LexerToken.Operator.EQ || !executeTextSearch) return new QueryItem(query, negate);
            query = this.buildSubQuery(textFields, valueToken);
            return new QueryItem(query, negate);
        } else {
            if (valueToken.type != TokenType.TT_TERM_NUMBER && valueToken.type != TokenType.TT_QUOTED_NUMBER) return new QueryItem(query, negate);
            if (negate) {
                negate = false;
                op = LexerToken.Operator.NE;
            }
            if (intFields != null) {
                query = this.createIntRangeQuery(intFields, op, valueToken.toInteger(), 0);
                return new QueryItem(query, negate);
            } else if (numFields != null) {
                query = this.createNumericRangeQuery(numFields, op, valueToken.toNumber(), 0.0, valueToken.unit, false);
                return new QueryItem(query, negate);
            } else {
                if (textFields == null || op != LexerToken.Operator.EQ) return new QueryItem(query, negate);
                query = this.buildSubQuery(textFields, valueToken);
            }
        }
        return new QueryItem(query, negate);
    }

    private Query getSubTokensQuery(QueryParserData data, Query query, List<SearchField> textFields, List<SearchField> numFields, List<SearchField> wildcardFields, List<SearchField> exactFields, List<SearchField> phraseFields, List<LexerToken> subTokens) throws UserInputException {
        QueryParserData subData = new QueryParserData(subTokens, data.getLanguageList(), data.getErpGroup());
        subData.setTextSearchFields(textFields);
        subData.setNumericSearchFields(numFields);
        subData.setWildcardFields(wildcardFields);
        subData.setExactFields(exactFields);
        subData.setPhraseFields(phraseFields);
        QueryItem queryItem = this.matchQuery(subData);
        if (queryItem != null) {
            query = queryItem.query;
        }
        return query;
    }

    private void addSubQuery(BooleanQueryBuilder builder, List<QueryItem> subQueryList) {
        Query query = this.buildSubQuery(subQueryList);
        if (query != null) {
            builder.add(query, 1.0f);
        }
    }

    private void addSubQuery(BooleanQueryBuilder builder, QueryItem queryItem, boolean negate) {
        Query query = null;
        if (queryItem.subQuery != null) {
            List<QueryItem> itemList = Collections.singletonList(queryItem);
            query = this.buildSubQuery(itemList);
        } else {
            query = queryItem.query;
        }
        if (query != null) {
            builder.add(query, negate);
        }
    }

    private Query buildSubQuery(List<SearchField> fieldList, LexerToken token) {
        List<QueryItem> itemList = Collections.singletonList(new QueryItem(new SubQuery(token, fieldList)));
        return this.buildSubQuery(itemList);
    }

    private Query buildSubQuery(List<QueryItem> subQueryList) {
        if (subQueryList.isEmpty()) {
            return null;
        }
        boolean hasTokenized = false;
        for (QueryItem queryItem : subQueryList) {
            if (queryItem.subQuery == null || !this.hasTokenizedFields(queryItem.subQuery.fieldList)) continue;
            hasTokenized = true;
            break;
        }
        if (!hasTokenized) {
            List<SearchField> fieldList = null;
            for (QueryItem queryItem : subQueryList) {
                if (queryItem.subQuery == null) continue;
                fieldList = queryItem.subQuery.fieldList;
                break;
            }
            ArrayList<Query> arrayList = new ArrayList<Query>();
            if (fieldList != null) {
                for (SearchField field : fieldList) {
                    BooleanQueryBuilder bq = new BooleanQueryBuilder(BooleanClause.Occur.MUST);
                    for (QueryItem queryItem : subQueryList) {
                        Query tquery = this.buildUntokenizedQuery(field, queryItem.subQuery.token);
                        bq.add(tquery, 1.0f);
                    }
                    Query unTokQuery = bq.build();
                    if (unTokQuery == null) continue;
                    arrayList.add(this.boostQuery(unTokQuery, field));
                }
            }
            if (arrayList.size() == 1) {
                return (Query)arrayList.get(0);
            }
            if (arrayList.size() > 0) {
                return new DisjunctionMaxQuery(arrayList, 0.0f);
            }
        } else {
            if (subQueryList.size() <= 1) {
                BooleanQueryBuilder bq = new BooleanQueryBuilder(BooleanClause.Occur.MUST);
                for (QueryItem queryItem : subQueryList) {
                    PSolQueryItem psQueryItem = this.buildSubQuery(queryItem);
                    PSolQuery squery = new PSolQuery(psQueryItem);
                    bq.add((Query)squery, 1.0f);
                }
                return bq.build();
            }
            ArrayList<PSolQueryItem> psQueryList = new ArrayList<PSolQueryItem>();
            for (QueryItem queryItem : subQueryList) {
                PSolQueryItem psQueryItem = this.buildSubQuery(queryItem);
                psQueryList.add(psQueryItem);
            }
            return new PSolQuery(psQueryList);
        }
        return null;
    }

    private Query boostQuery(Query query, SearchField field) {
        if (field.getBoost() != 1.0f) {
            return new BoostQuery(query, field.getBoost());
        }
        return query;
    }

    private boolean hasTokenizedFields(List<SearchField> fieldList) {
        for (SearchField field : fieldList) {
            if (!field.isTokenized()) continue;
            return true;
        }
        return false;
    }

    private PSolQueryItem buildSubQuery(QueryItem subQuery) {
        ArrayList<PSolQueryItem> itemList = new ArrayList<PSolQueryItem>();
        ArrayList<PSolQueryItemOr.ItemData> itemData = new ArrayList<PSolQueryItemOr.ItemData>();
        if (subQuery.subQuery != null) {
            List<SearchField> fieldList = subQuery.subQuery.fieldList;
            for (int f = 0; f < fieldList.size(); ++f) {
                SearchField field = fieldList.get(f);
                if (field.isDocField() && !this.searchDocuments) continue;
                PSolQueryItem queryItem = field.isTokenized() ? this.buildSubQuery(field, subQuery.subQuery.token) : new PSolQueryItemWrapper(this.buildUntokenizedQuery(field, subQuery.subQuery.token));
                if (field.isDocField() && queryItem != null) {
                    queryItem = new PSolQueryItemDoc(queryItem, "facet_document_id");
                }
                if (queryItem == null) continue;
                itemList.add(queryItem);
                itemData.add(new PSolQueryItemOr.ItemData(field.getBoostHandler(), f * 1000000, field.isOptional(), field.isCommonField()));
            }
        }
        if (subQuery.query != null) {
            itemList.add(new PSolQueryItemWrapper(subQuery.query));
            itemData.add(new PSolQueryItemOr.ItemData(null, 0, false, false));
        }
        return new PSolQueryItemOr(itemList, itemData);
    }

    private PSolQueryItem buildSubQuery(SearchField field, LexerToken token) {
        switch (token.type) {
            case TT_TERM_NUMBER: 
            case TT_QUOTED_NUMBER: 
            case TT_TERM: 
            case TT_QUOTED: 
            case TT_EXACT: {
                return this.createFieldSubQuery(field.getName(), token.data, field.isExact(), field.isCompoundField(), false);
            }
            case TT_QUOTED_ONLY: 
            case TT_EXACT_ONLY: {
                return this.createFieldSubQuery(field.getName(), token.data, field.isExact(), field.isCompoundField(), true);
            }
            case TT_QUOTED_PREFIX: 
            case TT_TERM_PREFIX: 
            case TT_EXACT_PREFIX: {
                return this.createPrefixSubQuery(field.getName(), token.data, field.isExact(), field.isCompoundField());
            }
            case TT_TERM_WILDCARD: 
            case TT_TERM_MATCHALL: {
                return this.createWildcardSubQuery(field.getName(), token.data, field.isExact(), field.isCompoundField());
            }
        }
        throw new IllegalArgumentException("invalid field");
    }

    private Query buildUntokenizedQuery(SearchField field, LexerToken token) {
        switch (token.type) {
            case TT_TERM_NUMBER: 
            case TT_QUOTED_NUMBER: 
            case TT_TERM: 
            case TT_QUOTED: 
            case TT_QUOTED_ONLY: 
            case TT_EXACT: 
            case TT_EXACT_ONLY: {
                return new TermQuery(new Term(field.getName(), token.data));
            }
            case TT_QUOTED_PREFIX: 
            case TT_TERM_PREFIX: 
            case TT_EXACT_PREFIX: {
                return new PrefixQuery(new Term(field.getName(), token.data));
            }
            case TT_TERM_WILDCARD: 
            case TT_TERM_MATCHALL: {
                return new WildcardQuery(new Term(field.getName(), token.data));
            }
        }
        throw new IllegalArgumentException("invalid field");
    }

    private List<TermToken> buildTermTokens(String fieldName, String queryText) throws IOException {
        ArrayList<TermToken> list = new ArrayList<TermToken>();
        boolean containsWildards = false;
        StringReader reader = new StringReader(queryText);
        try (TokenStream tokenStream = this.getAnalyzer().tokenStream(fieldName, reader);){
            CharTermAttribute termAttribute = tokenStream.addAttribute(CharTermAttribute.class);
            PositionIncrementAttribute posIncAttr = tokenStream.addAttribute(PositionIncrementAttribute.class);
            FlagsAttribute flagsAttr = tokenStream.addAttribute(FlagsAttribute.class);
            tokenStream.reset();
            TermToken ltoken = null;
            while (tokenStream.incrementToken()) {
                TermToken ttoken = new TermToken(termAttribute.toString());
                if (TokenFlags.isSet(TokenFlags.Flag.CompoundPart, flagsAttr)) {
                    ttoken.isCompound = true;
                }
                if (TokenFlags.isSet(TokenFlags.Flag.ExactToken, flagsAttr)) {
                    ttoken.isExact = true;
                }
                if (TokenFlags.isSet(TokenFlags.Flag.SynonymToken, flagsAttr)) {
                    ttoken.isSynonym = true;
                }
                if (TokenFlags.isSet(TokenFlags.Flag.WildcardToken, flagsAttr)) {
                    ttoken.hasWildcard = true;
                }
                if (TokenFlags.isSet(TokenFlags.Flag.WildcardChar, flagsAttr)) {
                    ttoken.isWildcard = true;
                    containsWildards = true;
                }
                boolean bl = ttoken.hasDigit = this.getStringType(ttoken.text) == StringType.Digit;
                if (TokenFlags.isSet(TokenFlags.Flag.WordBgn, flagsAttr)) {
                    ttoken.wordPart = FieldDefinitions.WordPart.WordBgn;
                } else if (TokenFlags.isSet(TokenFlags.Flag.WordEnd, flagsAttr)) {
                    ttoken.wordPart = FieldDefinitions.WordPart.WordEnd;
                } else if (TokenFlags.isSet(TokenFlags.Flag.WordMid, flagsAttr)) {
                    ttoken.wordPart = FieldDefinitions.WordPart.WordMid;
                }
                if (posIncAttr.getPositionIncrement() > 0) {
                    ltoken = ttoken;
                    list.add(ttoken);
                    continue;
                }
                if (ltoken == null) continue;
                ltoken.incrementAlteredTokens();
                ttoken.isAltered = true;
                list.add(ttoken);
            }
        }
        if (containsWildards) {
            this.mergeWildcardTokens(list);
        }
        return list;
    }

    private StringType getStringType(String text) {
        if (text.isEmpty()) {
            return StringType.None;
        }
        char ch = text.charAt(0);
        if (Character.isLetter(ch)) {
            return StringType.Letter;
        }
        if (ch == '.' || Character.isDigit(ch)) {
            return StringType.Digit;
        }
        return StringType.Ideographic;
    }

    private void mergeWildcardTokens(List<TermToken> list) {
        int i = 1;
        while (i < list.size()) {
            if (list.get((int)i).isWildcard) {
                StringType type1 = this.getStringType(list.get((int)(i - 1)).text);
                StringType type2 = StringType.None;
                if (i + 1 < list.size()) {
                    type2 = this.getStringType(list.get((int)(i + 1)).text);
                }
                if (type1 == type2) {
                    if (type1 != StringType.Ideographic) {
                        list.get((int)(i - 1)).text = list.get((int)(i - 1)).text + list.get((int)i).text + list.get((int)(i + 1)).text;
                        list.get((int)(i - 1)).hasWildcard = true;
                        list.remove(i + 1);
                        list.remove(i);
                        ++i;
                        continue;
                    }
                    i += 3;
                    continue;
                }
                if (type1 == StringType.Ideographic) {
                    i += 2;
                    continue;
                }
                list.get((int)(i - 1)).text = list.get((int)(i - 1)).text + list.get((int)i).text;
                list.get((int)(i - 1)).hasWildcard = true;
                list.remove(i);
                continue;
            }
            ++i;
        }
    }

    public PSolQueryItem createFieldSubQuery(String fieldName, String queryText, boolean isExactQuery, boolean isCompoundField, boolean isStrict) {
        try {
            List<TermToken> tlist = this.buildTermTokens((String)(isExactQuery ? fieldName + "_ex" : fieldName), queryText);
            return this.createFieldSubQuery(fieldName, tlist, isExactQuery, isCompoundField, isStrict);
        }
        catch (Exception e) {
            logger.error(e);
            return null;
        }
    }

    private PSolQueryItem createFieldSubQuery(String fieldName, List<TermToken> tlist, boolean isExactQuery, boolean isCompoundField, boolean isStrict) {
        if (tlist.size() == 1 && !isStrict) {
            PSolQueryItemTerm termQuery;
            TermToken ttoken = tlist.get(0);
            Term term = new Term(fieldName, ttoken.text);
            PSolQueryItem query = termQuery = new PSolQueryItemTerm(term);
            query = isExactQuery ? new PSolQueryItemExact(termQuery, ttoken.wordPart) : (ttoken.isSynonym ? new PSolQueryItemBoost(query, FieldDefinitions.getSynTermBoost(fieldName)) : (ttoken.isExact ? new PSolQueryItemBoost(query, FieldDefinitions.getExactTermBoost(fieldName, ttoken.hasDigit)) : new PSolQueryItemBoost(query, FieldDefinitions.getStandardBoost(fieldName))));
            return query;
        }
        if (tlist.size() > 0) {
            int tokenCount = 0;
            for (TermToken token : tlist) {
                if (token.isAltered) continue;
                ++tokenCount;
            }
            if (tokenCount == 1 && !isStrict) {
                return this.createSubQueryHelper(tlist, fieldName, isExactQuery, 0);
            }
            ArrayList<PSolQueryItem> spanList = new ArrayList<PSolQueryItem>(tokenCount);
            for (int t = 0; t < tlist.size(); t += tlist.get((int)t).altcount + 1) {
                spanList.add(this.createSubQueryHelper(tlist, fieldName, isExactQuery, t));
            }
            return new PSolQueryItemPhrase(spanList, isCompoundField, isStrict);
        }
        return null;
    }

    private PSolQueryItem createSubQueryHelper(List<TermToken> tlist, String fieldName, boolean isExactQuery, int t) {
        PSolQueryItem query;
        PLazyInit<PSolExactBoost> exactBoost = new PLazyInit<PSolExactBoost>(() -> FieldDefinitions.getExactTermBoost(fieldName, false));
        PLazyInit<PSolExactBoost> numExactBoost = new PLazyInit<PSolExactBoost>(() -> FieldDefinitions.getExactTermBoost(fieldName, true));
        PLazyInit<PSolExactBoost> synBoost = new PLazyInit<PSolExactBoost>(() -> FieldDefinitions.getSynTermBoost(fieldName));
        PLazyInit<PSolStandardBoost> stdBoost = new PLazyInit<PSolStandardBoost>(() -> FieldDefinitions.getStandardBoost(fieldName));
        TermToken ttoken = tlist.get(t);
        Term term = new Term(fieldName, ttoken.text);
        if (ttoken.altcount == 0) {
            PSolQueryItemTerm termQuery;
            query = termQuery = new PSolQueryItemTerm(term);
            query = isExactQuery ? new PSolQueryItemExact(termQuery, ttoken.wordPart) : (ttoken.isSynonym ? new PSolQueryItemBoost(query, synBoost.get()) : (ttoken.isExact ? new PSolQueryItemBoost(query, ttoken.hasDigit ? (PSolBoost)numExactBoost.get() : (PSolBoost)exactBoost.get()) : new PSolQueryItemBoost(query, stdBoost.get())));
        } else {
            PSolQueryItemTermList.TermItem[] termList = new PSolQueryItemTermList.TermItem[ttoken.altcount + 1];
            PSolBoost boost = ttoken.isSynonym ? (PSolBoost)synBoost.get() : (ttoken.isExact ? (ttoken.hasDigit ? (PSolBoost)numExactBoost.get() : (PSolBoost)exactBoost.get()) : (PSolBoost)stdBoost.get());
            termList[0] = new PSolQueryItemTermList.TermItem(term, boost);
            for (int s = 0; s < ttoken.altcount; ++s) {
                TermToken stoken = tlist.get(++t);
                boost = stoken.isSynonym ? (PSolBoost)synBoost.get() : (stoken.isExact ? (stoken.hasDigit ? (PSolBoost)numExactBoost.get() : (PSolBoost)exactBoost.get()) : (PSolBoost)stdBoost.get());
                termList[s + 1] = new PSolQueryItemTermList.TermItem(new Term(fieldName, stoken.text), boost);
            }
            query = new PSolQueryItemTermList(termList);
        }
        query.setCompoundPart(ttoken.isCompound);
        return query;
    }

    private PSolQueryItem createPrefixSubQuery(String fieldName, String queryText, boolean isExactQuery, boolean isCompoundField) {
        try {
            String fullFieldName = isExactQuery ? fieldName + "_pre_ex" : fieldName + "_pre";
            List<TermToken> tlist = this.buildTermTokens(fullFieldName, queryText);
            if (tlist.size() == 1) {
                Term term = new Term(fieldName, tlist.get((int)0).text);
                if (this.endsWithSeparator(queryText)) {
                    return new PSolQueryItemTerm(term);
                }
                return new PSolQueryItemPrefix(term, this.getWildcardCostLimit());
            }
            if (tlist.size() > 0) {
                int tokenCount = 0;
                int lastPos = 0;
                int lastNoneCompound = 0;
                for (int i = 0; i < tlist.size(); ++i) {
                    TermToken token = tlist.get(i);
                    if (token.isAltered) continue;
                    ++tokenCount;
                    lastPos = i;
                    if (token.isCompound) continue;
                    lastNoneCompound = i;
                }
                boolean endWithSep = this.endsWithSeparator(queryText);
                ArrayList<PSolQueryItem> spanList = new ArrayList<PSolQueryItem>(tokenCount);
                for (int t = 0; t < tlist.size(); ++t) {
                    PSolQueryItem queryItem;
                    TermToken ttoken = tlist.get(t);
                    Term term = new Term(fieldName, ttoken.text);
                    if (!(endWithSep || t != lastPos && t != lastNoneCompound)) {
                        if (ttoken.altcount == 0) {
                            queryItem = new PSolQueryItemPrefix(term, this.getWildcardCostLimit());
                        } else {
                            ArrayList<PSolQueryItem> orList = new ArrayList<PSolQueryItem>(ttoken.altcount + 1);
                            orList.add(new PSolQueryItemPrefix(term, this.getWildcardCostLimit()));
                            for (int s = 0; s < ttoken.altcount; ++s) {
                                Term synTerm = new Term(fieldName, tlist.get((int)(++t)).text);
                                orList.add(new PSolQueryItemPrefix(synTerm, this.getWildcardCostLimit()));
                            }
                            queryItem = new PSolQueryItemOr(orList);
                        }
                        queryItem.setCompoundPart(ttoken.isCompound);
                        spanList.add(queryItem);
                        continue;
                    }
                    queryItem = this.createSubQueryHelper(tlist, fieldName, isExactQuery, t);
                    t += ttoken.altcount;
                    spanList.add(queryItem);
                }
                if (spanList.size() == 1) {
                    return (PSolQueryItem)spanList.get(0);
                }
                if (spanList.size() > 0) {
                    return new PSolQueryItemPhrase(spanList, isCompoundField, false);
                }
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        return null;
    }

    private boolean endsWithSeparator(String text) {
        if (text.length() > 0) {
            int unicodeIndex = text.codePointAt(text.length() - 1);
            return unicodeIndex < WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE.length && WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE[unicodeIndex] == 8;
        }
        return false;
    }

    private PSolQueryItem createWildcardSubQuery(String fieldName, String queryText, boolean isExactQuery, boolean isCompoundField) {
        try {
            List<TermToken> tlist = this.buildTermTokens(fieldName + "_wld", queryText);
            if (tlist.size() == 1) {
                return new PSolQueryItemWildcard(new Term(fieldName, tlist.get((int)0).text), this.getWildcardCostLimit());
            }
            if (tlist.size() > 0) {
                int tokenCount = 0;
                for (TermToken token : tlist) {
                    if (token.isAltered) continue;
                    ++tokenCount;
                }
                ArrayList<PSolQueryItem> spanList = new ArrayList<PSolQueryItem>(tokenCount);
                for (int t = 0; t < tlist.size(); ++t) {
                    PSolQueryItem queryItem;
                    TermToken ttoken = tlist.get(t);
                    if (ttoken.hasWildcard) {
                        queryItem = new PSolQueryItemWildcard(new Term(fieldName, ttoken.text), this.getWildcardCostLimit());
                    } else {
                        queryItem = this.createSubQueryHelper(tlist, fieldName, isExactQuery, t);
                        t += ttoken.altcount;
                    }
                    spanList.add(queryItem);
                }
                if (spanList.size() == 1) {
                    return (PSolQueryItem)spanList.get(0);
                }
                if (spanList.size() > 0) {
                    return new PSolQueryItemPhrase(spanList, isCompoundField, false);
                }
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        return null;
    }

    private LexerToken extractUpperToken(QueryParserData data) throws UserInputException {
        if (data.peekNextTokenType() != TokenType.TT_MINUS) {
            return null;
        }
        LexerToken minusToken = data.takeNextToken();
        LexerToken nextToken = data.peekNextToken();
        if (!nextToken.whitespacePrefix && minusToken.whitespacePrefix) {
            nextToken.data = "-" + nextToken.data;
            return null;
        }
        if (nextToken.type == TokenType.TT_TERM_NUMBER) {
            LexerToken upperToken = data.takeNextToken();
            QueryParser.handleNumberToken(data, upperToken);
            return upperToken;
        }
        if (nextToken.type == TokenType.TT_TERM) {
            LexerToken upperToken = this.convertToNumericToken(nextToken);
            if (upperToken == null) {
                return null;
            }
            if (data.peekNextTokenType() == TokenType.TT_LBRACKET) {
                LexerToken unitToken = data.takeNextToken();
                upperToken.unit = unitToken.data;
            } else {
                upperToken.unit = "inch";
            }
            return upperToken;
        }
        return null;
    }

    private LexerToken convertToNumericToken(LexerToken token) {
        double value = NumUtils.inchFragmentToDouble(token.data);
        if (Double.isNaN(value)) {
            return null;
        }
        LexerToken numToken = new LexerToken(token.data, TokenType.TT_TERM_NUMBER);
        numToken.data = token.data;
        numToken.number = value;
        return numToken;
    }

    private Query createNumericRangeQuery(List<SearchField> fieldList, LexerToken.Operator op, double value1, double value2, String targetUnit, boolean exactSearch) {
        boolean searchConverted = false;
        int pq = 0;
        if (!targetUnit.isEmpty()) {
            searchConverted = true;
            value1 = NumUtils.convertToBaseUnit(value1, targetUnit);
            pq = NumUtils.getUnitPhysicalQuantity(targetUnit);
            if (op.equals((Object)LexerToken.Operator.RANGE)) {
                value2 = NumUtils.convertToBaseUnit(value2, targetUnit);
            }
        }
        float extraBoost = 1.0f;
        if (op == LexerToken.Operator.RANGE) {
            extraBoost = 0.25f;
        }
        if (fieldList.size() == 1) {
            float boost;
            Query query = this.createNumericRangeQuery(fieldList.get(0).getName(), op, value1, value2, searchConverted, pq, exactSearch);
            if (query != null && (boost = fieldList.get(0).getBoost() * extraBoost) != 1.0f) {
                query = new BoostQuery(query, boost);
            }
            return query;
        }
        BooleanQueryBuilder bq = new BooleanQueryBuilder(BooleanClause.Occur.SHOULD);
        for (SearchField f : fieldList) {
            Query q = this.createNumericRangeQuery(f.getName(), op, value1, value2, searchConverted, pq, exactSearch);
            bq.add(q, f.getBoost() * extraBoost);
        }
        return bq.build();
    }

    private Query createNumericRangeQuery(String fieldName, LexerToken.Operator op, double value1, double value2, boolean searchConverted, int physicalQuantity, boolean exactSearch) {
        switch (op) {
            case EQ: {
                return ValueRangeQuery.newIntersectsQuery(fieldName, value1 - 1.0E-6, value1 + 1.0E-6, value1, searchConverted, physicalQuantity, exactSearch);
            }
            case NE: {
                BooleanQueryBuilder bq = new BooleanQueryBuilder(BooleanClause.Occur.SHOULD);
                bq.add(ValueRangeQuery.newIntersectsQuery(fieldName, Double.NEGATIVE_INFINITY, DoublePoint.nextDown(value1), searchConverted, physicalQuantity));
                bq.add(ValueRangeQuery.newIntersectsQuery(fieldName, DoublePoint.nextUp(value1), Double.POSITIVE_INFINITY, searchConverted, physicalQuantity));
                return bq.build();
            }
            case LT: {
                return ValueRangeQuery.newIntersectsQuery(fieldName, Double.NEGATIVE_INFINITY, DoublePoint.nextDown(value1), searchConverted, physicalQuantity);
            }
            case LE: {
                return ValueRangeQuery.newIntersectsQuery(fieldName, Double.NEGATIVE_INFINITY, value1, searchConverted, physicalQuantity);
            }
            case GT: {
                return ValueRangeQuery.newIntersectsQuery(fieldName, DoublePoint.nextUp(value1), Double.POSITIVE_INFINITY, searchConverted, physicalQuantity);
            }
            case GE: {
                return ValueRangeQuery.newIntersectsQuery(fieldName, value1, Double.POSITIVE_INFINITY, searchConverted, physicalQuantity);
            }
            case RANGE: {
                return ValueRangeQuery.newIntersectsQuery(fieldName, value1, value2, searchConverted, physicalQuantity);
            }
        }
        return null;
    }

    private Query createIntRangeQuery(List<SearchField> fieldList, LexerToken.Operator op, int value1, int value2) {
        BooleanQueryBuilder bq = new BooleanQueryBuilder(BooleanClause.Occur.SHOULD);
        for (SearchField f : fieldList) {
            Query q = this.createIntRangeQuery(f.getName(), op, value1, value2);
            bq.add(q, f.getBoost());
        }
        return bq.build();
    }

    private Query createIntRangeQuery(String fieldName, LexerToken.Operator op, int value1, int value2) {
        switch (op) {
            case EQ: {
                return IntPoint.newExactQuery(fieldName, value1);
            }
            case LT: {
                return IntPoint.newRangeQuery(fieldName, Integer.MIN_VALUE, value1 - 1);
            }
            case LE: {
                return IntPoint.newRangeQuery(fieldName, Integer.MIN_VALUE, value1);
            }
            case GT: {
                return IntPoint.newRangeQuery(fieldName, value1 + 1, Integer.MAX_VALUE);
            }
            case GE: {
                return IntPoint.newRangeQuery(fieldName, value1, Integer.MAX_VALUE);
            }
            case RANGE: {
                return IntPoint.newRangeQuery(fieldName, value1, value2);
            }
        }
        return null;
    }

    private LexerToken handleMinusToken(QueryParserData data, LexerToken minusToken) throws UserInputException {
        LexerToken nextToken = data.peekNextToken();
        if (!nextToken.whitespacePrefix && (nextToken.type == TokenType.TT_TERM_NUMBER || nextToken.type == TokenType.TT_TERM || nextToken.type == TokenType.TT_TERM_PREFIX || nextToken.type == TokenType.TT_TERM_WILDCARD) || nextToken.type == TokenType.TT_TERM_MATCHALL) {
            LexerToken valueToken = data.takeNextToken();
            valueToken.data = minusToken.data + valueToken.data;
            if (valueToken.type == TokenType.TT_TERM_NUMBER && data.peekNextTokenType() == TokenType.TT_LBRACKET && data.peekNextToken((int)1).type == TokenType.TT_TERM) {
                LexerToken unitToken = data.peekNextToken(1);
                PGenericPair<Double, Double> range = this.extractRangeFromToken(unitToken.data);
                if (range == null) {
                    valueToken.unit = unitToken.data;
                    data.takeNextToken();
                    data.takeNextToken();
                    if (data.peekNextTokenType() != TokenType.TT_RBRACKET) {
                        throw new ParseException(UserInputException.NO.MissingBracket, "", -1, new Object[0]);
                    }
                    data.takeNextToken();
                }
            }
            return valueToken;
        }
        return minusToken;
    }

    private static void handleNumberToken(QueryParserData data, LexerToken numToken) throws UserInputException {
        numToken.number = NumUtils.getNumeric(numToken.data);
        LexerToken nextToken = data.peekNextToken();
        if (nextToken.type == TokenType.TT_TERM) {
            double numValue = NumUtils.inchFragmentToDouble(nextToken.data);
            if (Double.isNaN(numValue)) {
                return;
            }
            data.takeNextToken();
            numToken.number += numValue;
            nextToken = data.peekNextToken();
            if (nextToken.type != TokenType.TT_LBRACKET) {
                numToken.unit = "inch";
            }
        }
        if (nextToken.type == TokenType.TT_LBRACKET) {
            data.takeNextToken();
            nextToken = data.takeNextToken();
            numToken.unit = nextToken.data;
            if (data.peekNextTokenType() != TokenType.TT_RBRACKET) {
                throw new ParseException(UserInputException.NO.MissingBracket, "", -1, new Object[0]);
            }
            data.takeNextToken();
        }
    }

    AtomicLong getWildcardCostLimit() {
        if (this.wildcardCostLimit == null) {
            this.wildcardCostLimit = new AtomicLong(FieldDefinitions.WILDCARD_COST_LIMIT);
        }
        return this.wildcardCostLimit;
    }

    private static class QueryItem {
        public Query query;
        public SubQuery subQuery;
        public boolean negate;
        public int conjunction;

        QueryItem(Query q) {
            this(q, false);
        }

        QueryItem(Query q, boolean n) {
            this.query = q;
            this.subQuery = null;
            this.negate = n;
            this.conjunction = 0;
        }

        QueryItem(Query q, SubQuery s) {
            this.query = q;
            this.subQuery = s;
            this.negate = false;
            this.conjunction = 0;
        }

        QueryItem(SubQuery s) {
            this.query = null;
            this.subQuery = s;
            this.negate = false;
            this.conjunction = 0;
        }

        QueryItem(int c) {
            this.query = null;
            this.subQuery = null;
            this.negate = false;
            this.conjunction = c;
        }

        boolean isOperator() {
            return this.conjunction != 0;
        }
    }

    private static class SubQuery {
        LexerToken token;
        List<SearchField> fieldList;

        SubQuery(LexerToken token, List<SearchField> fieldList) {
            this.token = token;
            this.fieldList = fieldList;
        }
    }

    private static class NumericRangeData {
        double from = Double.NaN;
        double to = Double.NaN;
        String unit = "";
        LexerToken.Operator operator = LexerToken.Operator.EQ;

        private NumericRangeData() {
        }
    }

    static class TermToken {
        public String text;
        boolean isAltered = false;
        boolean isCompound = false;
        boolean isExact = false;
        boolean isSynonym = false;
        boolean hasWildcard = false;
        boolean isWildcard = false;
        boolean hasDigit = false;
        FieldDefinitions.WordPart wordPart = FieldDefinitions.WordPart.WordComplete;
        int altcount = 0;

        TermToken(String t) {
            this.text = t;
        }

        void incrementAlteredTokens() {
            ++this.altcount;
        }
    }

    static enum StringType {
        None,
        Letter,
        Digit,
        Ideographic;

    }
}

