/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class QueryWrapper
extends Query {
    private final Query query;

    public QueryWrapper(Query query) {
        this.query = query;
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.query.visit(visitor);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        final Weight innerWeight = searcher.createWeight(this.query, scoreMode, boost);
        return new Weight(this){

            @Override
            public Explanation explain(LeafReaderContext leafReaderContext, int i) throws IOException {
                if (QueryWrapper.this.isDisabled(leafReaderContext)) {
                    return null;
                }
                return innerWeight.explain(leafReaderContext, i);
            }

            @Override
            public Scorer scorer(LeafReaderContext leafReaderContext) throws IOException {
                if (QueryWrapper.this.isDisabled(leafReaderContext)) {
                    int md = leafReaderContext.reader().maxDoc();
                    return new ConstantScoreScorer((Weight)this, 1.0f, ScoreMode.COMPLETE, DocIdSetIterator.all(md));
                }
                return innerWeight.scorer(leafReaderContext);
            }

            @Override
            public boolean isCacheable(LeafReaderContext leafReaderContext) {
                return false;
            }
        };
    }

    @Override
    public String toString(String field) {
        return "Wrapper(" + this.query.toString(field) + ")";
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.query.equals(((QueryWrapper)other).query);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + this.query.hashCode();
    }

    public boolean isDisabled(LeafReaderContext leafReaderContext) {
        return false;
    }
}

