/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser;

import de.cadenas.catalogsearch.lucene.queryparser.boost.PSolExactBoost;
import de.cadenas.catalogsearch.lucene.queryparser.boost.PSolFieldBoost;
import de.cadenas.catalogsearch.lucene.queryparser.boost.PSolStandardBoost;

public class SearchField
implements Cloneable {
    private String name;
    private PSolFieldBoost boost;
    private final boolean languageField;
    private final boolean tokenized;
    private boolean docField;
    private final boolean optional;
    private boolean exact;
    private boolean compound;
    private boolean fulltext;
    private final boolean isCommonField;
    private PSolExactBoost exactTermBoost;
    private PSolExactBoost numericExactTermBoost;
    private PSolExactBoost synTermBoost;
    private PSolStandardBoost standardBoost;

    public SearchField(String name, PSolFieldBoost boost, boolean languageField, boolean tokenized, boolean optional, boolean exact, boolean fulltext, boolean isCommonField) {
        this.name = name;
        this.boost = boost;
        this.languageField = languageField;
        this.tokenized = tokenized;
        this.docField = false;
        this.optional = optional;
        this.exact = exact;
        this.compound = false;
        this.fulltext = fulltext;
        this.exactTermBoost = null;
        this.numericExactTermBoost = null;
        this.synTermBoost = null;
        this.standardBoost = null;
        this.isCommonField = isCommonField;
    }

    public SearchField(String name, PSolFieldBoost boost, boolean languageField, boolean tokenized, boolean optional, boolean exact, boolean fulltext) {
        this(name, boost, languageField, tokenized, optional, exact, fulltext, false);
    }

    public SearchField(String name, PSolFieldBoost boost, boolean languageField, boolean tokenized, boolean optional, boolean exact) {
        this(name, boost, languageField, tokenized, optional, exact, false);
    }

    public SearchField(String name, PSolFieldBoost boost, boolean languageField, boolean tokenized, boolean optional) {
        this(name, boost, languageField, tokenized, optional, false);
    }

    public SearchField(String name, PSolFieldBoost boost, boolean languageField) {
        this(name, boost, languageField, true, false, false);
    }

    public SearchField(String name, PSolFieldBoost boost) {
        this(name, boost, false);
    }

    public SearchField(String name, float boost) {
        this(name, new PSolFieldBoost(boost, false), false);
    }

    public SearchField(String name) {
        this(name, null);
    }

    public Object clone() throws CloneNotSupportedException {
        SearchField cloned = (SearchField)super.clone();
        if (cloned.boost != null) {
            cloned.boost = (PSolFieldBoost)cloned.boost.clone();
        }
        if (cloned.exactTermBoost != null) {
            cloned.exactTermBoost = (PSolExactBoost)cloned.exactTermBoost.clone();
        }
        if (cloned.numericExactTermBoost != null) {
            cloned.numericExactTermBoost = (PSolExactBoost)cloned.numericExactTermBoost.clone();
        }
        if (cloned.synTermBoost != null) {
            cloned.synTermBoost = (PSolExactBoost)cloned.synTermBoost.clone();
        }
        if (cloned.standardBoost != null) {
            cloned.standardBoost = (PSolStandardBoost)cloned.standardBoost.clone();
        }
        return cloned;
    }

    public SearchField clone(String newName) throws CloneNotSupportedException {
        SearchField field = (SearchField)this.clone();
        field.name = newName;
        return field;
    }

    public String getName() {
        return this.name;
    }

    public float getBoost() {
        if (this.boost != null) {
            return this.boost.defaultBoost();
        }
        return 1.0f;
    }

    public PSolFieldBoost getBoostHandler() {
        return this.boost;
    }

    public boolean isLanguageField() {
        return this.languageField;
    }

    public boolean isTokenized() {
        return this.tokenized;
    }

    public void setIsDocField(boolean yesno) {
        this.docField = yesno;
    }

    public boolean isDocField() {
        return this.docField;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setIsExact(boolean yesno) {
        this.exact = yesno;
    }

    public boolean isExact() {
        return this.exact;
    }

    public void setIsCompoundField(boolean yesno) {
        this.compound = yesno;
    }

    public boolean isCompoundField() {
        return this.compound;
    }

    public boolean isFulltext() {
        return this.fulltext;
    }

    public boolean isCommonField() {
        return this.isCommonField;
    }

    public SearchField setFulltext(boolean yesno) {
        this.fulltext = yesno;
        return this;
    }

    public void setExactTermBoost(PSolExactBoost boost) {
        this.exactTermBoost = boost;
    }

    public void setNumericExactTermBoost(PSolExactBoost boost) {
        this.numericExactTermBoost = boost;
    }

    public PSolExactBoost getExactTermBoost(boolean numeric) {
        if (numeric && this.numericExactTermBoost != null) {
            return this.numericExactTermBoost;
        }
        return this.exactTermBoost;
    }

    public void setSynTermBoost(PSolExactBoost boost) {
        this.synTermBoost = boost;
    }

    public PSolExactBoost getSynTermBoost() {
        return this.synTermBoost;
    }

    public void setStandardBoost(PSolStandardBoost boost) {
        this.standardBoost = boost;
    }

    public PSolStandardBoost getStandardBoost() {
        return this.standardBoost;
    }

    public String toString() {
        return this.name;
    }
}

