/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser;

import de.cadenas.catalogsearch.lucene.LuceneSearchService;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.ContextCache;
import de.cadenas.util.PLogger;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

public class TraceQuery
extends Query {
    private static final PLogger logger = new PLogger(LuceneSearchService.class.getSimpleName());
    private final Query query;

    public TraceQuery(Query query) {
        this.query = query;
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.query.visit(visitor);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        final Weight innerWeight = searcher.createWeight(this.query, scoreMode, boost);
        return new Weight(this){

            @Override
            public Explanation explain(LeafReaderContext leafReaderContext, int i) throws IOException {
                return innerWeight.explain(leafReaderContext, i);
            }

            @Override
            public Scorer scorer(LeafReaderContext leafReaderContext) throws IOException {
                return innerWeight.scorer(leafReaderContext);
            }

            @Override
            public BulkScorer bulkScorer(final LeafReaderContext context) throws IOException {
                final long startTime = System.currentTimeMillis();
                final BulkScorer innerScorer = innerWeight.bulkScorer(context);
                if (innerScorer == null) {
                    return null;
                }
                return new BulkScorer(){

                    @Override
                    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
                        int ret = innerScorer.score(collector, acceptDocs, min, max);
                        long elapsed = System.currentTimeMillis() - startTime;
                        String indexpath = ContextCache.getIndexPath(context);
                        if (indexpath != null) {
                            logger.trace("Search in: " + indexpath + "; elapsed: " + String.valueOf(elapsed) + "ms");
                        }
                        return ret;
                    }

                    @Override
                    public long cost() {
                        return innerScorer.cost();
                    }
                };
            }

            @Override
            public boolean isCacheable(LeafReaderContext leafReaderContext) {
                return false;
            }
        };
    }

    @Override
    public String toString(String field) {
        return "Trace(" + this.query.toString(field) + ")";
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.query.equals(((TraceQuery)other).query);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + this.query.hashCode();
    }

    public boolean isDisabled(LeafReaderContext leafReaderContext) {
        return false;
    }
}

