/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.boost;

import java.io.IOException;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.util.BytesRef;

public abstract class PSolBoost
implements Cloneable {
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public abstract float computeBoost(int var1, PostingsEnum var2);

    public abstract String explainBoost(int var1, PostingsEnum var2);

    public abstract float defaultBoost();

    public abstract boolean needPositions();

    public static boolean isOnExactMatchPosition(int position) {
        int pos = position % 100000;
        if (pos < 10000) {
            return true;
        }
        return pos % 100 == 0;
    }

    public static byte getTokenPriority(PostingsEnum posting) {
        try {
            BytesRef payLoad = posting.getPayload();
            if (payLoad != null && payLoad.length > 0) {
                return payLoad.bytes[payLoad.offset];
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    public static boolean isStemmedPriority(byte prio) {
        return (prio & 1) == 1;
    }

    public static boolean isLowTokenPriority(byte prio) {
        return (prio & 0x10) == 16;
    }

    public static boolean isStemmedToken(PostingsEnum posting) {
        byte b = PSolBoost.getTokenPriority(posting);
        return PSolBoost.isStemmedPriority(b);
    }
}

