/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.boost;

import de.cadenas.catalogsearch.lucene.queryparser.boost.PSolBoost;
import org.apache.lucene.index.PostingsEnum;

public class PSolExactBoost
extends PSolBoost {
    private float fix;
    private float lowPrio;
    private float compoundLastFactor = 1.0f;
    private float compoundMidFactor = 1.0f;

    public PSolExactBoost(float fix, float lowPrio, float compoundMidFactor, float compoundLastFactor) {
        this.fix = fix;
        this.lowPrio = lowPrio;
        this.compoundMidFactor = compoundMidFactor;
        this.compoundLastFactor = compoundLastFactor;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public float computeBoost(int position, PostingsEnum posting) {
        float fixValue;
        byte b = PSolExactBoost.getTokenPriority(posting);
        if (PSolExactBoost.isStemmedPriority(b)) {
            return PSolExactBoost.isLowTokenPriority(b) ? this.lowPrio : 1.0f;
        }
        float f = fixValue = PSolExactBoost.isLowTokenPriority(b) ? this.lowPrio * this.fix : this.fix;
        if (position < 0) {
            return fixValue;
        }
        float compoundFactor = 1.0f;
        int pos = position % 100000;
        if (pos >= 10000) {
            int cpos = pos - 10000;
            if (cpos % 2 == 1) {
                compoundFactor = this.compoundMidFactor;
            } else if (cpos % 100 != 0) {
                compoundFactor = this.compoundLastFactor;
            }
        }
        return fixValue * compoundFactor;
    }

    @Override
    public String explainBoost(int position, PostingsEnum posting) {
        if (position < 0) {
            return "factor for found exact: " + this.fix;
        }
        byte b = PSolExactBoost.getTokenPriority(posting);
        if (PSolExactBoost.isStemmedPriority(b)) {
            if (PSolExactBoost.isLowTokenPriority(b)) {
                return "factor (alternate match): " + this.lowPrio;
            }
            return "factor: 1.0";
        }
        float fixValue = PSolExactBoost.isLowTokenPriority(b) ? this.lowPrio * this.fix : this.fix;
        String compoundDesc = null;
        float compoundFactor = 1.0f;
        int pos = position % 100000;
        if (pos >= 10000) {
            int cpos = pos - 10000;
            if (cpos % 2 == 1) {
                compoundFactor = this.compoundMidFactor;
                compoundDesc = " (part of word)";
            } else if (cpos % 100 != 0) {
                compoundFactor = this.compoundLastFactor;
                compoundDesc = " (last part of word)";
            }
        }
        String result = PSolExactBoost.isLowTokenPriority(b) ? "factor (alternate match): " + this.lowPrio + " * " + this.fix : "factor for found exact: " + fixValue;
        if (compoundFactor != 1.0f) {
            result = result + " * " + compoundFactor;
            if (compoundDesc != null) {
                result = result + compoundDesc;
            }
        }
        return result;
    }

    public void setDefaultBoost(float boostValue) {
        this.fix = boostValue;
    }

    public void setMidFactor(float mid) {
        this.compoundMidFactor = mid;
    }

    public void setLastFactor(float last) {
        this.compoundLastFactor = last;
    }

    public void setLowPrioBoost(float boostValue) {
        this.lowPrio = boostValue;
    }

    @Override
    public float defaultBoost() {
        return this.fix;
    }

    @Override
    public boolean needPositions() {
        return true;
    }
}

