/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.MMapDirectory;

public class ContextCache {
    private final LeafReaderContext context;
    private Map<String, TermsOrEnum> termByField;

    ContextCache(LeafReaderContext context) {
        this.context = context;
        this.termByField = new HashMap<String, TermsOrEnum>();
    }

    public LeafReaderContext getLeafReaderContext() {
        return this.context;
    }

    public Terms getTerms(String field) throws IOException {
        TermsOrEnum te = this.getTermsOrEnum(field);
        return te.getTerms();
    }

    public TermsEnum getTermsEnum(String field) throws IOException {
        TermsOrEnum te = this.getTermsOrEnum(field);
        return te.getTermsEnum();
    }

    private TermsOrEnum getTermsOrEnum(String field) throws IOException {
        TermsOrEnum item = this.termByField.get(field);
        if (item == null) {
            LeafReader reader = this.context.reader();
            Terms fieldTerms = reader.terms(field);
            item = new TermsOrEnum(fieldTerms);
            this.termByField.put(field, item);
        }
        return item;
    }

    public static String getIndexPath(LeafReaderContext context) {
        SegmentReader sr;
        SegmentCommitInfo sci;
        if (context.reader() instanceof SegmentReader && (sci = (sr = (SegmentReader)context.reader()).getSegmentInfo()) != null && sci.info.dir instanceof MMapDirectory) {
            MMapDirectory mmd = (MMapDirectory)sci.info.dir;
            Path path = mmd.getDirectory();
            String indexpath = path.toString();
            return indexpath;
        }
        return null;
    }

    private static class TermsOrEnum {
        private Terms terms;
        private TermsEnum te;

        TermsOrEnum(Terms terms) {
            this.terms = terms;
            this.te = null;
        }

        public Terms getTerms() {
            return this.terms;
        }

        public TermsEnum getTermsEnum() throws IOException {
            if (this.te == null && this.terms != null) {
                this.te = this.terms.iterator();
            }
            return this.te;
        }
    }
}

